/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPBodyElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.ws.addressing.AddressingProperties;
/*     */ import javax.xml.ws.addressing.AttributedURI;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ 
/*     */ public class SOAPMessageDispatcher
/*     */ {
/*  51 */   private static Logger log = Logger.getLogger(SOAPMessageDispatcher.class);
/*     */ 
/*     */   public OperationMetaData getDispatchDestination(EndpointMetaData epMetaData, SOAPMessage soapMessage)
/*     */     throws SOAPException
/*     */   {
/*  57 */     OperationMetaData opMetaData = null;
/*     */ 
/*  60 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/*  61 */     AddressingProperties inProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.inbound");
/*     */     String wsaAction;
/*  62 */     if ((inProps != null) && (inProps.getAction() != null))
/*     */     {
/*  64 */       wsaAction = inProps.getAction().getURI().toASCIIString();
/*  65 */       for (OperationMetaData opAux : epMetaData.getOperations())
/*     */       {
/*  67 */         if (wsaAction.equals(opAux.getSOAPAction()))
/*     */         {
/*  69 */           opMetaData = opAux;
/*  70 */           log.debug("Use wsa:Action dispatch: " + wsaAction);
/*  71 */           break;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  77 */     if ((opMetaData == null) && (epMetaData.getServiceMode() != null))
/*     */     {
/*  79 */       QName xmlName = new QName(epMetaData.getPortName().getNamespaceURI(), "invoke");
/*  80 */       opMetaData = epMetaData.getOperation(xmlName);
/*     */     }
/*     */ 
/*  84 */     if (opMetaData == null)
/*     */     {
/*  86 */       SOAPBody soapBody = soapMessage.getSOAPBody();
/*     */ 
/*  88 */       SOAPBodyElement soapBodyElement = null;
/*  89 */       Iterator bodyChildren = soapBody.getChildElements();
/*  90 */       while ((bodyChildren.hasNext()) && (soapBodyElement == null))
/*     */       {
/*  92 */         Object childNode = bodyChildren.next();
/*  93 */         if ((childNode instanceof SOAPBodyElement))
/*     */         {
/*  95 */           soapBodyElement = (SOAPBodyElement)childNode;
/*     */         }
/*     */       }
/*     */ 
/*  99 */       if (soapBodyElement == null)
/*     */       {
/* 101 */         if (epMetaData.getStyle() == Style.RPC) {
/* 102 */           throw new SOAPException("Empty SOAP body with no child element not supported for RPC");
/*     */         }
/*     */ 
/* 105 */         for (OperationMetaData opAux : epMetaData.getOperations())
/*     */         {
/* 107 */           if (opAux.getParameters().size() == 0)
/*     */           {
/* 109 */             log.debug("Dispatching empty SOAP body");
/* 110 */             opMetaData = opAux;
/* 111 */             break;
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 117 */         Name soapName = soapBodyElement.getElementName();
/* 118 */         QName xmlElementName = new QName(soapName.getURI(), soapName.getLocalName());
/* 119 */         opMetaData = epMetaData.getOperation(xmlElementName);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 124 */     if (opMetaData == null)
/*     */     {
/* 126 */       for (OperationMetaData opAux : epMetaData.getOperations())
/*     */       {
/* 128 */         if (opAux.isMessageEndpoint())
/*     */         {
/* 130 */           log.debug("Use generic message style dispatch");
/* 131 */           opMetaData = opAux;
/* 132 */           break;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 137 */     log.debug("getDispatchDestination: " + (opMetaData != null ? opMetaData.getQName() : null));
/* 138 */     return opMetaData;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPMessageDispatcher
 * JD-Core Version:    0.6.0
 */