/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Comment;
/*     */ import org.w3c.dom.DOMException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.DocumentFragment;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.w3c.dom.UserDataHandler;
/*     */ 
/*     */ public class NodeImpl
/*     */   implements javax.xml.soap.Node
/*     */ {
/*  61 */   private static Logger log = Logger.getLogger(NodeImpl.class);
/*     */   protected SOAPElementImpl soapParent;
/*     */   protected org.w3c.dom.Node domNode;
/*  68 */   private List<NodeImpl> soapChildren = new ArrayList();
/*     */ 
/*     */   NodeImpl(org.w3c.dom.Node node)
/*     */   {
/*  81 */     if ((node instanceof NodeImpl)) {
/*  82 */       throw new IllegalArgumentException("Copy constructor should be used");
/*     */     }
/*  84 */     this.domNode = node;
/*     */ 
/*  87 */     if (DOMUtils.hasChildElements(node))
/*  88 */       throw new IllegalArgumentException("Node cannot have child elements");
/*     */   }
/*     */ 
/*     */   NodeImpl(NodeImpl node)
/*     */   {
/*  95 */     this.soapParent = node.soapParent;
/*  96 */     this.domNode = node.domNode;
/*  97 */     Iterator i = node.soapChildren.iterator();
/*  98 */     while (i.hasNext())
/*     */     {
/* 100 */       NodeImpl childNode = (NodeImpl)i.next();
/* 101 */       childNode.soapParent = ((SOAPElementImpl)this);
/* 102 */       this.soapChildren.add(childNode);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void detachNode()
/*     */   {
/* 113 */     org.w3c.dom.Node domParent = this.domNode.getParentNode();
/* 114 */     if (domParent != null) {
/* 115 */       domParent.removeChild(this.domNode);
/*     */     }
/* 117 */     if (this.soapParent != null) {
/* 118 */       this.soapParent.soapChildren.remove(this);
/*     */     }
/* 120 */     this.soapParent = null;
/*     */   }
/*     */ 
/*     */   public SOAPElement getParentElement()
/*     */   {
/* 131 */     return this.soapParent;
/*     */   }
/*     */ 
/*     */   public void setParentElement(SOAPElement parent)
/*     */     throws SOAPException
/*     */   {
/* 143 */     if (this.soapParent != null) {
/* 144 */       detachNode();
/*     */     }
/* 146 */     this.soapParent = ((SOAPElementImpl)parent);
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/* 162 */     if ((this instanceof javax.xml.soap.Text)) {
/* 163 */       throw new WSException("javax.xml.soap.Text should take care of this");
/*     */     }
/* 165 */     String nodeValue = null;
/* 166 */     org.w3c.dom.Node child = getFirstChild();
/* 167 */     if ((child instanceof org.w3c.dom.Text)) {
/* 168 */       nodeValue = ((org.w3c.dom.Text)child).getNodeValue();
/*     */     }
/* 170 */     return nodeValue;
/*     */   }
/*     */ 
/*     */   public void setValue(String value)
/*     */   {
/* 185 */     if ((this instanceof javax.xml.soap.Text)) {
/* 186 */       throw new WSException("javax.xml.soap.Text should take care of this");
/*     */     }
/* 188 */     org.w3c.dom.Node child = getFirstChild();
/*     */ 
/* 190 */     if ((child instanceof org.w3c.dom.Text)) {
/* 191 */       ((org.w3c.dom.Text)child).setNodeValue(value);
/*     */     }
/* 193 */     if (child == null)
/*     */     {
/* 195 */       child = this.domNode.getOwnerDocument().createTextNode(value);
/* 196 */       appendChild(new TextImpl(child));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void recycleNode()
/*     */   {
/*     */   }
/*     */ 
/*     */   private List<NodeImpl> convertDocumentFragment(DocumentFragment docFragment)
/*     */     throws DOMException
/*     */   {
/* 212 */     List list = new ArrayList();
/*     */     try
/*     */     {
/* 215 */       SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
/* 216 */       for (org.w3c.dom.Node node = docFragment.getFirstChild(); node != null; node = node.getNextSibling())
/*     */       {
/* 218 */         switch (node.getNodeType())
/*     */         {
/*     */         case 1:
/* 222 */           SOAPElementImpl soapChild = (SOAPElementImpl)soapFactory.createElement((Element)node);
/* 223 */           list.add(soapChild);
/* 224 */           break;
/*     */         case 3:
/* 228 */           TextImpl text = new TextImpl(node);
/* 229 */           list.add(text);
/* 230 */           break;
/*     */         case 4:
/* 234 */           TextImpl text = new TextImpl(node);
/* 235 */           list.add(text);
/*     */         case 2:
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 243 */       throw new DOMException(11, "Could not convert a document fragment to a node");
/*     */     }
/* 245 */     return list;
/*     */   }
/*     */ 
/*     */   public String getNodeName()
/*     */   {
/* 252 */     return this.domNode.getNodeName();
/*     */   }
/*     */ 
/*     */   public String getNodeValue() throws DOMException
/*     */   {
/* 257 */     return this.domNode.getNodeValue();
/*     */   }
/*     */ 
/*     */   public void setNodeValue(String nodeValue) throws DOMException
/*     */   {
/* 262 */     this.domNode.setNodeValue(nodeValue);
/*     */   }
/*     */ 
/*     */   public short getNodeType()
/*     */   {
/* 267 */     return this.domNode.getNodeType();
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Node getParentNode()
/*     */   {
/* 272 */     assertSOAPParent();
/* 273 */     return this.soapParent;
/*     */   }
/*     */ 
/*     */   public NodeList getChildNodes()
/*     */   {
/* 278 */     return new NodeListImpl(this.soapChildren);
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Node getFirstChild()
/*     */   {
/* 283 */     NodeImpl child = null;
/* 284 */     org.w3c.dom.Node domChild = this.domNode.getFirstChild();
/* 285 */     if (domChild != null)
/*     */     {
/* 287 */       child = (NodeImpl)this.soapChildren.get(0);
/* 288 */       if (domChild != child.domNode)
/* 289 */         throw new WSException("Inconsistent node, child lists not synchronized");
/*     */     }
/* 291 */     return child;
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Node getLastChild()
/*     */   {
/* 296 */     NodeImpl child = null;
/* 297 */     org.w3c.dom.Node domChild = this.domNode.getLastChild();
/* 298 */     if (domChild != null)
/*     */     {
/* 300 */       child = (NodeImpl)this.soapChildren.get(this.soapChildren.size() - 1);
/* 301 */       if (domChild != child.domNode)
/* 302 */         throw new WSException("Inconsistent node, child lists not synchronized");
/*     */     }
/* 304 */     return child;
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Node getPreviousSibling()
/*     */   {
/* 309 */     assertSOAPParent();
/*     */ 
/* 311 */     NodeImpl sibling = null;
/* 312 */     if (this.soapParent != null)
/*     */     {
/* 314 */       List children = this.soapParent.soapChildren;
/* 315 */       for (int i = 0; i < children.size(); i++)
/*     */       {
/* 317 */         NodeImpl node = (NodeImpl)children.get(i);
/* 318 */         if ((node != this) || (i <= 0))
/*     */           continue;
/* 320 */         sibling = (NodeImpl)children.get(i - 1);
/* 321 */         break;
/*     */       }
/*     */ 
/* 325 */       if ((sibling != null) && (sibling.domNode != this.domNode.getPreviousSibling())) {
/* 326 */         throw new WSException("Inconsistent node, child lists not synchronized");
/*     */       }
/*     */     }
/* 329 */     return sibling;
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Node getNextSibling()
/*     */   {
/* 334 */     assertSOAPParent();
/*     */ 
/* 336 */     NodeImpl sibling = null;
/* 337 */     if (this.soapParent != null)
/*     */     {
/* 339 */       List children = this.soapParent.soapChildren;
/* 340 */       for (int i = 0; i < children.size(); i++)
/*     */       {
/* 342 */         NodeImpl node = (NodeImpl)children.get(i);
/* 343 */         if ((node != this) || (i + 1 >= children.size()))
/*     */           continue;
/* 345 */         sibling = (NodeImpl)children.get(i + 1);
/* 346 */         break;
/*     */       }
/*     */ 
/* 350 */       if ((sibling != null) && (sibling.domNode != this.domNode.getNextSibling())) {
/* 351 */         throw new WSException("Inconsistent node, child lists not synchronized");
/*     */       }
/*     */     }
/* 354 */     return sibling;
/*     */   }
/*     */ 
/*     */   public NamedNodeMap getAttributes()
/*     */   {
/* 359 */     return this.domNode.getAttributes();
/*     */   }
/*     */ 
/*     */   public Document getOwnerDocument()
/*     */   {
/* 366 */     if (this.soapParent == null) {
/* 367 */       return new SOAPDocument();
/*     */     }
/* 369 */     return this.soapParent.getOwnerDocument();
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild)
/*     */     throws DOMException
/*     */   {
/* 375 */     if (refChild == null) {
/* 376 */       return appendChild(newChild);
/*     */     }
/* 378 */     newChild = convertDOMNode(newChild);
/* 379 */     refChild = convertDOMNode(refChild);
/*     */ 
/* 381 */     if ((newChild instanceof DocumentFragment))
/*     */     {
/* 383 */       List list = convertDocumentFragment((DocumentFragment)newChild);
/* 384 */       for (NodeImpl node : list)
/*     */       {
/* 386 */         insertBefore(node, refChild);
/*     */       }
/* 388 */       return newChild;
/*     */     }
/*     */ 
/* 391 */     int index = this.soapChildren.indexOf(refChild);
/* 392 */     if (index < 0) {
/* 393 */       throw new IllegalArgumentException("Cannot find refChild in list of javax.xml.soap.Node children");
/*     */     }
/* 395 */     NodeImpl soapNewNode = (NodeImpl)newChild;
/* 396 */     soapNewNode.detachNode();
/*     */ 
/* 398 */     NodeImpl soapRefNode = (NodeImpl)refChild;
/* 399 */     this.domNode.insertBefore(soapNewNode.domNode, soapRefNode.domNode);
/* 400 */     this.soapChildren.add(index, soapNewNode);
/*     */ 
/* 402 */     soapNewNode.soapParent = ((SOAPElementImpl)this);
/*     */ 
/* 404 */     return newChild;
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) throws DOMException
/*     */   {
/* 409 */     newChild = convertDOMNode(newChild);
/* 410 */     oldChild = convertDOMNode(oldChild);
/*     */ 
/* 412 */     if ((newChild instanceof DocumentFragment))
/*     */     {
/* 414 */       insertBefore(newChild, oldChild);
/* 415 */       ((NodeImpl)oldChild).detachNode();
/* 416 */       return newChild;
/*     */     }
/*     */ 
/* 419 */     int index = this.soapChildren.indexOf(oldChild);
/* 420 */     if (index < 0) {
/* 421 */       throw new DOMException(8, "Cannot find oldChild in list of javax.xml.soap.Node children");
/*     */     }
/* 423 */     NodeImpl soapNewNode = (NodeImpl)newChild;
/* 424 */     NodeImpl soapOldNode = (NodeImpl)oldChild;
/*     */ 
/* 426 */     soapNewNode.detachNode();
/*     */ 
/* 428 */     if (soapNewNode.domNode != soapOldNode.domNode) {
/* 429 */       this.domNode.replaceChild(soapNewNode.domNode, soapOldNode.domNode);
/*     */     }
/* 431 */     this.soapChildren.remove(index);
/* 432 */     this.soapChildren.add(index, soapNewNode);
/*     */ 
/* 434 */     soapNewNode.soapParent = soapOldNode.soapParent;
/* 435 */     soapOldNode.soapParent = null;
/*     */ 
/* 437 */     return newChild;
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) throws DOMException
/*     */   {
/* 442 */     oldChild = convertDOMNode(oldChild);
/*     */ 
/* 444 */     int index = this.soapChildren.indexOf(oldChild);
/* 445 */     if (index < 0) {
/* 446 */       throw new DOMException(8, "Cannot find oldChild in list of javax.xml.soap.Node children");
/*     */     }
/* 448 */     NodeImpl soapOldNode = (NodeImpl)oldChild;
/* 449 */     this.domNode.removeChild(soapOldNode.domNode);
/* 450 */     this.soapChildren.remove(index);
/*     */ 
/* 452 */     soapOldNode.soapParent = null;
/*     */ 
/* 454 */     return oldChild;
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) throws DOMException
/*     */   {
/* 459 */     newChild = convertDOMNode(newChild);
/*     */ 
/* 461 */     if ((newChild instanceof DocumentFragment))
/*     */     {
/* 463 */       List list = convertDocumentFragment((DocumentFragment)newChild);
/* 464 */       for (NodeImpl node : list)
/*     */       {
/* 466 */         appendChild(node);
/*     */       }
/* 468 */       return newChild;
/*     */     }
/*     */ 
/* 471 */     if (!(this instanceof SOAPElementImpl)) {
/* 472 */       throw new DOMException(15, "Cannot append child to this node: " + this);
/*     */     }
/* 474 */     NodeImpl soapNode = (NodeImpl)newChild;
/* 475 */     soapNode.detachNode();
/*     */ 
/* 477 */     this.domNode.appendChild(soapNode.domNode);
/* 478 */     soapNode.soapParent = ((SOAPElementImpl)this);
/*     */ 
/* 480 */     this.soapChildren.add(soapNode);
/*     */ 
/* 482 */     return newChild;
/*     */   }
/*     */ 
/*     */   public boolean hasChildNodes()
/*     */   {
/* 487 */     return this.domNode.hasChildNodes();
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Node cloneNode(boolean deep)
/*     */   {
/* 492 */     return this.domNode.cloneNode(deep);
/*     */   }
/*     */ 
/*     */   public void normalize()
/*     */   {
/* 497 */     this.domNode.normalize();
/*     */   }
/*     */ 
/*     */   public boolean isSupported(String feature, String version)
/*     */   {
/* 502 */     return this.domNode.isSupported(feature, version);
/*     */   }
/*     */ 
/*     */   public String getNamespaceURI()
/*     */   {
/* 507 */     return this.domNode.getNamespaceURI();
/*     */   }
/*     */ 
/*     */   public String getPrefix()
/*     */   {
/* 512 */     return this.domNode.getPrefix();
/*     */   }
/*     */ 
/*     */   public void setPrefix(String prefix) throws DOMException
/*     */   {
/* 517 */     this.domNode.setPrefix(prefix);
/*     */   }
/*     */ 
/*     */   public String getLocalName()
/*     */   {
/* 522 */     return this.domNode.getLocalName();
/*     */   }
/*     */ 
/*     */   public boolean hasAttributes()
/*     */   {
/* 527 */     return this.domNode.hasAttributes();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 532 */     return this.domNode.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 537 */     return super.toString() + "[" + this.domNode.toString() + "]";
/*     */   }
/*     */ 
/*     */   private org.w3c.dom.Node convertDOMNode(org.w3c.dom.Node node)
/*     */   {
/*     */     org.w3c.dom.Node retNode;
/*     */     org.w3c.dom.Node retNode;
/* 543 */     if ((node instanceof NodeImpl))
/*     */     {
/* 545 */       retNode = node;
/*     */     }
/*     */     else
/*     */     {
/*     */       org.w3c.dom.Node retNode;
/* 547 */       if ((node instanceof DocumentFragment))
/*     */       {
/* 549 */         retNode = new DocumentFragmentImpl((DocumentFragment)node);
/*     */       }
/*     */       else
/*     */       {
/*     */         org.w3c.dom.Node retNode;
/* 551 */         if ((node instanceof org.w3c.dom.Text))
/*     */         {
/* 553 */           retNode = new TextImpl(node);
/*     */         }
/*     */         else
/*     */         {
/*     */           org.w3c.dom.Node retNode;
/* 555 */           if ((node instanceof Comment))
/*     */           {
/* 557 */             retNode = new TextImpl(node);
/*     */           }
/* 559 */           else if ((node instanceof Element))
/*     */           {
/*     */             try
/*     */             {
/* 563 */               retNode = new SOAPFactoryImpl().createElement((Element)node);
/*     */             }
/*     */             catch (SOAPException ex)
/*     */             {
/* 567 */               throw new DOMException(9, "CAnnot convert to SOAP element: " + node);
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 572 */             throw new DOMException(9, "Operation not supported on this type of node: " + node);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 574 */     return retNode;
/*     */   }
/*     */ 
/*     */   private void assertSOAPParent()
/*     */   {
/* 579 */     org.w3c.dom.Node domParent = this.domNode.getParentNode();
/* 580 */     if ((domParent != null) && (this.soapParent == null))
/* 581 */       throw new WSException("Inconsistent node, has a DOM parent but no SOAP parent [" + this + "] " + DOMWriter.printNode(this, false));
/* 582 */     if ((domParent != null) && (this.soapParent != null) && (domParent != this.soapParent.domNode))
/* 583 */       throw new WSException("Inconsistent node, SOAP parent is not identical with DOM parent [" + this + "] " + DOMWriter.printNode(this, false));
/*     */   }
/*     */ 
/*     */   public short compareDocumentPosition(org.w3c.dom.Node other)
/*     */     throws DOMException
/*     */   {
/* 593 */     throw new NotImplementedException("compareDocumentPosition");
/*     */   }
/*     */ 
/*     */   public String getBaseURI()
/*     */   {
/* 599 */     throw new NotImplementedException("getBaseURI");
/*     */   }
/*     */ 
/*     */   public Object getFeature(String feature, String version)
/*     */   {
/* 605 */     throw new NotImplementedException("getFeature");
/*     */   }
/*     */ 
/*     */   public String getTextContent()
/*     */     throws DOMException
/*     */   {
/* 611 */     throw new NotImplementedException("getTextContent");
/*     */   }
/*     */ 
/*     */   public Object getUserData(String key)
/*     */   {
/* 617 */     throw new NotImplementedException("getUserData");
/*     */   }
/*     */ 
/*     */   public boolean isDefaultNamespace(String namespaceURI)
/*     */   {
/* 623 */     throw new NotImplementedException("isDefaultNamespace");
/*     */   }
/*     */ 
/*     */   public boolean isEqualNode(org.w3c.dom.Node arg)
/*     */   {
/* 628 */     return this.domNode.isEqualNode(arg);
/*     */   }
/*     */ 
/*     */   public boolean isSameNode(org.w3c.dom.Node other)
/*     */   {
/* 634 */     throw new NotImplementedException("isSameNode");
/*     */   }
/*     */ 
/*     */   public String lookupNamespaceURI(String prefix)
/*     */   {
/* 640 */     throw new NotImplementedException("lookupNamespaceURI");
/*     */   }
/*     */ 
/*     */   public String lookupPrefix(String namespaceURI)
/*     */   {
/* 646 */     throw new NotImplementedException("lookupPrefix");
/*     */   }
/*     */ 
/*     */   public void setTextContent(String textContent)
/*     */     throws DOMException
/*     */   {
/* 652 */     throw new NotImplementedException("setTextContent");
/*     */   }
/*     */ 
/*     */   public Object setUserData(String key, Object data, UserDataHandler handler)
/*     */   {
/* 658 */     throw new NotImplementedException("setUserData");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.NodeImpl
 * JD-Core Version:    0.6.0
 */