/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.mail.internet.ContentType;
/*     */ import javax.mail.internet.ParseException;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.MessageFactory;
/*     */ import javax.xml.soap.MimeHeader;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.ws.Service.Mode;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.soap.attachment.MultipartRelatedDecoder;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.wsf.common.IOUtils;
/*     */ import org.jboss.wsf.spi.util.ServiceLoader;
/*     */ 
/*     */ public class MessageFactoryImpl extends MessageFactory
/*     */ {
/*  58 */   private static Logger log = Logger.getLogger(MessageFactoryImpl.class);
/*     */   private String envNamespace;
/*     */   private Service.Mode serviceMode;
/*     */   private Style style;
/*     */   private boolean dynamic;
/*     */   private EnvelopeBuilder envelopeBuilder;
/*     */ 
/*     */   public MessageFactoryImpl()
/*     */   {
/*  74 */     this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
/*  75 */     this.envelopeBuilder = ((EnvelopeBuilder)ServiceLoader.loadService(EnvelopeBuilder.class.getName(), EnvelopeBuilderDOM.class.getName()));
/*     */   }
/*     */ 
/*     */   public MessageFactoryImpl(String protocol) throws SOAPException
/*     */   {
/*  80 */     this.envelopeBuilder = ((EnvelopeBuilder)ServiceLoader.loadService(EnvelopeBuilder.class.getName(), EnvelopeBuilderDOM.class.getName()));
/*     */ 
/*  82 */     if (("SOAP 1.1 Protocol".equals(protocol)) || ("SOAP 1.1 Protocol".equals(protocol)))
/*  83 */       this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
/*  84 */     else if ("SOAP 1.2 Protocol".equals(protocol))
/*  85 */       this.envNamespace = "http://www.w3.org/2003/05/soap-envelope";
/*  86 */     else if ("Dynamic Protocol".equals(protocol))
/*  87 */       this.dynamic = true;
/*     */     else
/*  89 */       throw new SOAPException("Unknown protocol: " + protocol);
/*     */   }
/*     */ 
/*     */   public String getEnvNamespace()
/*     */   {
/*  97 */     return this.envNamespace;
/*     */   }
/*     */ 
/*     */   public void setEnvNamespace(String envelopeURI)
/*     */   {
/* 105 */     this.envNamespace = envelopeURI;
/*     */   }
/*     */ 
/*     */   public Style getStyle()
/*     */   {
/* 113 */     if (this.style == null)
/*     */     {
/* 115 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 116 */       if ((msgContext != null) && (msgContext.getOperationMetaData() != null))
/*     */       {
/* 118 */         this.style = msgContext.getOperationMetaData().getStyle();
/*     */       }
/* 120 */       log.trace("Using style: " + this.style);
/*     */     }
/* 122 */     return this.style;
/*     */   }
/*     */ 
/*     */   public void setStyle(Style style)
/*     */   {
/* 127 */     this.style = style;
/*     */   }
/*     */ 
/*     */   public Service.Mode getServiceMode()
/*     */   {
/* 132 */     return this.serviceMode;
/*     */   }
/*     */ 
/*     */   public void setServiceMode(Service.Mode serviceMode)
/*     */   {
/* 137 */     this.serviceMode = serviceMode;
/*     */   }
/*     */ 
/*     */   public SOAPMessage createMessage()
/*     */     throws SOAPException
/*     */   {
/* 158 */     if (this.dynamic) {
/* 159 */       throw new UnsupportedOperationException("Cannot create default message when protocol is dynamic");
/*     */     }
/* 161 */     SOAPMessageImpl soapMessage = new SOAPMessageImpl();
/* 162 */     SOAPPartImpl soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
/* 163 */     new SOAPEnvelopeImpl(soapPart, this.envNamespace, true);
/* 164 */     return soapMessage;
/*     */   }
/*     */ 
/*     */   public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream ins)
/*     */     throws IOException, SOAPException
/*     */   {
/* 185 */     return createMessage(mimeHeaders, ins, false);
/*     */   }
/*     */ 
/*     */   public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream inputStream, boolean ignoreParseError) throws IOException, SOAPException
/*     */   {
/* 190 */     if (mimeHeaders == null)
/*     */     {
/* 192 */       mimeHeaders = new MimeHeaders();
/*     */     }
/* 194 */     else if (log.isTraceEnabled())
/*     */     {
/* 196 */       Iterator itMimeHeaders = mimeHeaders.getAllHeaders();
/* 197 */       while (itMimeHeaders.hasNext())
/*     */       {
/* 199 */         MimeHeader mh = (MimeHeader)itMimeHeaders.next();
/* 200 */         log.trace(mh);
/*     */       }
/*     */     }
/*     */ 
/* 204 */     ContentType contentType = getContentType(mimeHeaders);
/* 205 */     log.debug("createMessage: [contentType=" + contentType + "]");
/*     */ 
/* 207 */     SOAPMessageImpl soapMessage = new SOAPMessageImpl();
/* 208 */     if (inputStream != null)
/*     */     {
/* 211 */       if (log.isTraceEnabled())
/*     */       {
/* 213 */         ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
/* 214 */         IOUtils.copyStream(baos, inputStream);
/* 215 */         byte[] bytes = baos.toByteArray();
/*     */ 
/* 217 */         log.trace("createMessage\n" + new String(bytes));
/* 218 */         inputStream = new ByteArrayInputStream(bytes);
/*     */       }
/*     */ 
/* 221 */       Collection attachments = null;
/* 222 */       if (isMultipartRelatedContent(contentType))
/*     */       {
/*     */         MultipartRelatedDecoder decoder;
/*     */         try {
/* 227 */           decoder = new MultipartRelatedDecoder(contentType);
/* 228 */           decoder.decodeMultipartRelatedMessage(inputStream);
/*     */         }
/*     */         catch (RuntimeException rte)
/*     */         {
/* 232 */           throw rte;
/*     */         }
/*     */         catch (IOException ex)
/*     */         {
/* 236 */           throw ex;
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 240 */           throw new SOAPException("Cannot decode multipart related message", ex);
/*     */         }
/*     */ 
/* 243 */         inputStream = decoder.getRootPart().getDataHandler().getInputStream();
/* 244 */         attachments = decoder.getRelatedParts();
/*     */       }
/* 246 */       else if (!isSoapContent(contentType))
/*     */       {
/* 248 */         throw new SOAPException("Unsupported content type: " + contentType);
/*     */       }
/*     */ 
/* 251 */       if (mimeHeaders != null) {
/* 252 */         soapMessage.setMimeHeaders(mimeHeaders);
/*     */       }
/* 254 */       if (attachments != null) {
/* 255 */         soapMessage.setAttachments(attachments);
/*     */       }
/*     */ 
/* 259 */       this.envelopeBuilder.setStyle(getStyle());
/*     */ 
/* 262 */       this.envelopeBuilder.build(soapMessage, inputStream, ignoreParseError);
/*     */     }
/*     */ 
/* 265 */     return soapMessage;
/*     */   }
/*     */ 
/*     */   private static ContentType getContentType(MimeHeaders headers) throws SOAPException
/*     */   {
/* 270 */     ContentType contentType = null;
/*     */     try
/*     */     {
/* 273 */       String[] type = headers.getHeader("Content-Type");
/* 274 */       if (type != null)
/*     */       {
/* 276 */         contentType = new ContentType(type[0]);
/*     */       }
/*     */       else
/*     */       {
/* 280 */         contentType = new ContentType("text/xml");
/*     */       }
/* 282 */       return contentType;
/*     */     }
/*     */     catch (ParseException e) {
/*     */     }
/* 286 */     throw new SOAPException("Could not parse content type:" + e);
/*     */   }
/*     */ 
/*     */   private boolean isSoapContent(ContentType type)
/*     */   {
/* 292 */     String baseType = type.getBaseType();
/* 293 */     return ("text/xml".equalsIgnoreCase(baseType)) || ("application/soap+xml".equalsIgnoreCase(baseType));
/*     */   }
/*     */ 
/*     */   private boolean isMultipartRelatedContent(ContentType type)
/*     */   {
/* 298 */     String baseType = type.getBaseType();
/* 299 */     return "multipart/related".equalsIgnoreCase(baseType);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.MessageFactoryImpl
 * JD-Core Version:    0.6.0
 */