/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Detail;
/*     */ import javax.xml.soap.DetailEntry;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class DetailImpl extends SOAPFaultElementImpl
/*     */   implements Detail
/*     */ {
/*  55 */   private static Logger log = Logger.getLogger(DetailImpl.class);
/*     */ 
/*     */   public DetailImpl()
/*     */   {
/*  60 */     super("detail");
/*     */   }
/*     */ 
/*     */   public DetailImpl(String prefix, String namespace)
/*     */   {
/*  66 */     super("Detail", prefix, namespace);
/*     */   }
/*     */ 
/*     */   DetailImpl(SOAPElementImpl element)
/*     */   {
/*  72 */     super(element.getElementName());
/*     */ 
/*  75 */     DOMUtils.copyAttributes(this, element);
/*     */     try
/*     */     {
/*  79 */       NodeList nodeList = element.getChildNodes();
/*  80 */       for (int i = 0; i < nodeList.getLength(); i++)
/*     */       {
/*  82 */         Node node = nodeList.item(i);
/*  83 */         if ((node instanceof SOAPElement))
/*  84 */           addChildElement((SOAPElement)node);
/*     */         else
/*  86 */           appendChild(node);
/*     */       }
/*     */     }
/*     */     catch (SOAPException e)
/*     */     {
/*  91 */       throw new WSException("Unable to create fault detail", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public DetailEntry addDetailEntry(Name name) throws SOAPException
/*     */   {
/*  97 */     DetailEntryImpl detailEntry = new DetailEntryImpl(name);
/*  98 */     addChildElement(detailEntry);
/*  99 */     return detailEntry;
/*     */   }
/*     */ 
/*     */   public DetailEntry addDetailEntry(QName qname) throws SOAPException
/*     */   {
/* 104 */     DetailEntryImpl detailEntry = new DetailEntryImpl(qname);
/* 105 */     addChildElement(detailEntry);
/* 106 */     return detailEntry;
/*     */   }
/*     */ 
/*     */   public Iterator getDetailEntries()
/*     */   {
/* 111 */     List list = new ArrayList();
/*     */ 
/* 113 */     NodeList nodeList = getChildNodes();
/* 114 */     for (int i = 0; i < nodeList.getLength(); i++)
/*     */     {
/* 116 */       Node node = nodeList.item(i);
/* 117 */       if ((node instanceof DetailEntry)) {
/* 118 */         list.add((DetailEntry)node);
/*     */       }
/*     */     }
/* 121 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(SOAPElement child)
/*     */     throws SOAPException
/*     */   {
/* 127 */     if (!(child instanceof DetailEntry)) {
/* 128 */       child = convertToDetailEntry((SOAPElementImpl)child);
/*     */     }
/* 130 */     return super.addChildElement(child);
/*     */   }
/*     */ 
/*     */   private static DetailEntry convertToDetailEntry(SOAPElementImpl element)
/*     */   {
/* 135 */     element.detachNode();
/* 136 */     DetailEntryImpl detailEntry = new DetailEntryImpl(element);
/* 137 */     log.trace("convertToDetailEntry : " + detailEntry);
/* 138 */     return detailEntry;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.DetailImpl
 * JD-Core Version:    0.6.0
 */