/*     */ package org.jboss.ws.core.server;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class WSDLRequestHandler
/*     */ {
/*  55 */   private Logger log = Logger.getLogger(WSDLRequestHandler.class);
/*     */   private EndpointMetaData epMetaData;
/*     */ 
/*     */   public WSDLRequestHandler(EndpointMetaData epMetaData)
/*     */   {
/*  61 */     this.epMetaData = epMetaData;
/*     */   }
/*     */ 
/*     */   public Document getDocumentForPath(URL reqURL, String wsdlHost, String resPath)
/*     */     throws IOException
/*     */   {
/*  77 */     URL wsdlLocation = this.epMetaData.getServiceMetaData().getWsdlLocation();
/*  78 */     if (wsdlLocation == null)
/*  79 */       throw new IllegalStateException("Cannot obtain wsdl location");
/*     */     Document wsdlDoc;
/*     */     Document wsdlDoc;
/*  82 */     if (resPath == null)
/*     */     {
/*  84 */       Element wsdlElement = DOMUtils.parse(wsdlLocation.openStream());
/*  85 */       wsdlDoc = wsdlElement.getOwnerDocument();
/*     */     }
/*     */     else
/*     */     {
/*  91 */       String impResourcePath = new File(wsdlLocation.getPath()).getParent() + File.separatorChar + resPath;
/*  92 */       File impResourceFile = new File(impResourcePath);
/*     */ 
/*  94 */       Element wsdlElement = DOMUtils.parse(impResourceFile.toURL().openStream());
/*  95 */       wsdlDoc = wsdlElement.getOwnerDocument();
/*     */     }
/*     */ 
/*  98 */     modifyAddressReferences(reqURL, wsdlHost, resPath, wsdlDoc.getDocumentElement());
/*  99 */     return wsdlDoc;
/*     */   }
/*     */ 
/*     */   private void modifyAddressReferences(URL reqURL, String wsdlHost, String resPath, Element element)
/*     */     throws IOException
/*     */   {
/* 108 */     NodeList nlist = element.getChildNodes();
/* 109 */     for (int i = 0; i < nlist.getLength(); i++)
/*     */     {
/* 111 */       Node childNode = nlist.item(i);
/* 112 */       if (childNode.getNodeType() != 1)
/*     */         continue;
/* 114 */       Element childElement = (Element)childNode;
/* 115 */       String nodeName = childElement.getLocalName();
/*     */ 
/* 118 */       if (("import".equals(nodeName)) || ("include".equals(nodeName)))
/*     */       {
/* 120 */         Attr locationAttr = childElement.getAttributeNode("schemaLocation");
/* 121 */         if (locationAttr == null) {
/* 122 */           locationAttr = childElement.getAttributeNode("location");
/*     */         }
/* 124 */         if (locationAttr != null)
/*     */         {
/* 126 */           String orgLocation = locationAttr.getNodeValue();
/*     */ 
/* 128 */           while (orgLocation.startsWith("./")) {
/* 129 */             orgLocation = orgLocation.substring(2);
/*     */           }
/* 131 */           boolean isAbsolute = (orgLocation.startsWith("http://")) || (orgLocation.startsWith("https://"));
/* 132 */           if ((!isAbsolute) && (!orgLocation.startsWith(reqURL.getPath())))
/*     */           {
/* 134 */             String newResourcePath = orgLocation;
/*     */ 
/* 136 */             if ((resPath != null) && (resPath.indexOf("/") > 0))
/*     */             {
/* 138 */               String resParent = resPath.substring(0, resPath.lastIndexOf("/"));
/*     */ 
/* 141 */               while ((orgLocation.startsWith("../")) && (resParent != null))
/*     */               {
/* 143 */                 if (resParent.indexOf("/") > 0)
/*     */                 {
/* 145 */                   resParent = resParent.substring(0, resParent.lastIndexOf("/"));
/* 146 */                   orgLocation = orgLocation.substring(3);
/* 147 */                   newResourcePath = resParent + "/" + orgLocation; continue;
/*     */                 }
/*     */ 
/* 151 */                 orgLocation = orgLocation.substring(3);
/* 152 */                 newResourcePath = orgLocation;
/* 153 */                 resParent = null;
/*     */               }
/*     */ 
/* 158 */               if (resParent != null) {
/* 159 */                 newResourcePath = resParent + "/" + orgLocation;
/*     */               }
/*     */             }
/* 162 */             String reqPath = reqURL.getPath();
/* 163 */             String completeHost = wsdlHost;
/*     */ 
/* 165 */             if ((!wsdlHost.startsWith("http://")) && (!wsdlHost.startsWith("https://")))
/*     */             {
/* 167 */               String reqProtocol = reqURL.getProtocol();
/* 168 */               int reqPort = reqURL.getPort();
/* 169 */               String hostAndPort = wsdlHost + (reqPort > 0 ? ":" + reqPort : "");
/* 170 */               completeHost = reqProtocol + "://" + hostAndPort;
/*     */             }
/*     */ 
/* 173 */             String newLocation = completeHost + reqPath + "?wsdl&resource=" + newResourcePath;
/* 174 */             locationAttr.setNodeValue(newLocation);
/*     */ 
/* 176 */             this.log.trace("Mapping import from '" + orgLocation + "' to '" + newLocation + "'");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/* 182 */       else if ("address".equals(nodeName))
/*     */       {
/* 184 */         Attr locationAttr = childElement.getAttributeNode("location");
/* 185 */         if (locationAttr != null)
/*     */         {
/* 187 */           String orgLocation = locationAttr.getNodeValue();
/*     */ 
/* 189 */           URL orgURL = new URL(orgLocation);
/* 190 */           String orgProtocol = orgURL.getProtocol();
/* 191 */           String orgHost = orgURL.getHost();
/* 192 */           int orgPort = orgURL.getPort();
/* 193 */           String orgPath = orgURL.getPath();
/*     */ 
/* 195 */           if ("jbossws.undefined.host".equals(orgHost))
/*     */           {
/* 197 */             URL newURL = new URL(wsdlHost);
/* 198 */             String newHost = newURL.getHost();
/* 199 */             int newPort = newURL.getPort();
/*     */ 
/* 201 */             String newLocation = orgProtocol + "://" + newHost;
/* 202 */             if (orgPort != -1)
/* 203 */               newLocation = newLocation + ":" + orgPort;
/* 204 */             else if (newPort != -1) {
/* 205 */               newLocation = newLocation + ":" + newPort;
/*     */             }
/* 207 */             newLocation = newLocation + orgPath;
/* 208 */             locationAttr.setNodeValue(newLocation);
/*     */ 
/* 210 */             this.log.trace("Mapping address from '" + orgLocation + "' to '" + newLocation + "'");
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 216 */         modifyAddressReferences(reqURL, wsdlHost, resPath, childElement);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.server.WSDLRequestHandler
 * JD-Core Version:    0.6.0
 */