/*     */ package org.jboss.ws.core.server;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonBinding;
/*     */ import org.jboss.ws.core.CommonBindingProvider;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.EndpointInvocation;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.invocation.HandlerCallback;
/*     */ import org.jboss.wsf.spi.invocation.Invocation;
/*     */ import org.jboss.wsf.spi.invocation.InvocationContext;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class ServiceEndpointInvokerEJB21 extends ServiceEndpointInvoker
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(ServiceEndpointInvokerEJB21.class);
/*     */ 
/*     */   protected Invocation setupInvocation(Endpoint ep, EndpointInvocation epInv, InvocationContext invContext)
/*     */     throws Exception
/*     */   {
/*  56 */     Invocation inv = super.setupInvocation(ep, epInv, invContext);
/*     */ 
/*  59 */     ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)this.endpoint.getAttachment(ServerEndpointMetaData.class);
/*  60 */     invContext.addAttachment(HandlerCallback.class, new HandlerCallbackImpl(sepMetaData));
/*     */ 
/*  62 */     return inv;
/*     */   }
/*     */ 
/*     */   public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/*  69 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/*  70 */       return this.delegate.callRequestHandlerChain(sepMetaData, type);
/*  71 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/*  78 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/*  79 */       return this.delegate.callResponseHandlerChain(sepMetaData, type);
/*  80 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type, Exception ex)
/*     */   {
/*  87 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/*  88 */       return this.delegate.callFaultHandlerChain(sepMetaData, type, ex);
/*  89 */     return true;
/*     */   }
/*     */ 
/*     */   public class HandlerCallbackImpl implements HandlerCallback
/*     */   {
/*     */     private ServerEndpointMetaData sepMetaData;
/*     */ 
/*     */     public HandlerCallbackImpl(ServerEndpointMetaData sepMetaData)
/*     */     {
/*  99 */       this.sepMetaData = sepMetaData;
/*     */     }
/*     */ 
/*     */     public boolean callRequestHandlerChain(Invocation wsInv, UnifiedHandlerMetaData.HandlerType type)
/*     */     {
/* 105 */       boolean handlerPass = true;
/* 106 */       if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT)
/*     */       {
/* 108 */         handlerPass = ServiceEndpointInvokerEJB21.this.delegate.callRequestHandlerChain(this.sepMetaData, type);
/*     */       }
/* 110 */       else if (type == UnifiedHandlerMetaData.HandlerType.POST)
/*     */       {
/* 112 */         handlerPass = ServiceEndpointInvokerEJB21.this.delegate.callRequestHandlerChain(this.sepMetaData, type);
/*     */ 
/* 115 */         CommonMessageContext messageContext = MessageContextAssociation.peekMessageContext();
/* 116 */         if ((handlerPass) && (messageContext.isModified()))
/*     */         {
/*     */           try
/*     */           {
/* 120 */             OperationMetaData opMetaData = messageContext.getOperationMetaData();
/* 121 */             CommonBindingProvider bindingProvider = new CommonBindingProvider(opMetaData.getEndpointMetaData());
/* 122 */             CommonBinding binding = bindingProvider.getCommonBinding();
/*     */ 
/* 124 */             ServiceEndpointInvokerEJB21.log.debug("Handler modified payload, unbind message and update invocation args");
/* 125 */             EndpointInvocation epInv = binding.unbindRequestMessage(opMetaData, messageContext.getMessageAbstraction());
/* 126 */             wsInv.getInvocationContext().addAttachment(EndpointInvocation.class, epInv);
/*     */           }
/*     */           catch (BindingException ex)
/*     */           {
/* 130 */             throw new WSException(ex);
/*     */           }
/*     */         }
/*     */       }
/* 134 */       return handlerPass;
/*     */     }
/*     */ 
/*     */     public boolean callResponseHandlerChain(Invocation wsInv, UnifiedHandlerMetaData.HandlerType type)
/*     */     {
/* 140 */       if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/* 141 */         return true;
/* 142 */       return ServiceEndpointInvokerEJB21.this.delegate.callResponseHandlerChain(this.sepMetaData, type);
/*     */     }
/*     */ 
/*     */     public boolean callFaultHandlerChain(Invocation wsInv, UnifiedHandlerMetaData.HandlerType type, Exception ex)
/*     */     {
/* 148 */       if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/* 149 */         return true;
/* 150 */       return ServiceEndpointInvokerEJB21.this.delegate.callFaultHandlerChain(this.sepMetaData, type, ex);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.server.ServiceEndpointInvokerEJB21
 * JD-Core Version:    0.6.0
 */