/*     */ package org.jboss.ws.core.jaxws.spi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.net.URL;
/*     */ import java.security.CodeSource;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.Executor;
/*     */ import java.util.concurrent.ExecutorService;
/*     */ import java.util.concurrent.Executors;
/*     */ import javax.jws.WebService;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.BindingProvider;
/*     */ import javax.xml.ws.Dispatch;
/*     */ import javax.xml.ws.EndpointReference;
/*     */ import javax.xml.ws.Service;
/*     */ import javax.xml.ws.Service.Mode;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.WebServiceFeature;
/*     */ import javax.xml.ws.handler.HandlerResolver;
/*     */ import javax.xml.ws.spi.ServiceDelegate21;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.core.StubExt;
/*     */ import org.jboss.ws.core.jaxws.client.ClientImpl;
/*     */ import org.jboss.ws.core.jaxws.client.ClientProxy;
/*     */ import org.jboss.ws.core.jaxws.client.DispatchImpl;
/*     */ import org.jboss.ws.core.jaxws.client.ServiceObjectFactoryJAXWS;
/*     */ import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
/*     */ import org.jboss.ws.metadata.builder.jaxws.JAXWSClientMetaDataBuilder;
/*     */ import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilder;
/*     */ import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.wsf.common.ResourceLoaderAdapter;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
/*     */ 
/*     */ public class ServiceDelegateImpl extends ServiceDelegate21
/*     */ {
/*  91 */   private final Logger log = Logger.getLogger(ServiceDelegateImpl.class);
/*     */ 
/*  94 */   private static ExecutorService defaultExecutor = Executors.newCachedThreadPool();
/*     */   private ServiceMetaData serviceMetaData;
/* 111 */   private UnifiedServiceRefMetaData usRef = ServiceObjectFactoryJAXWS.getServiceRefAssociation();
/*     */   private HandlerResolver handlerResolver;
/*     */   private ExecutorService executor;
/* 105 */   private List<QName> annotatedPorts = new ArrayList();
/*     */ 
/*     */   public ServiceDelegateImpl(URL wsdlURL, QName serviceName, Class serviceClass)
/*     */   {
/*     */     UnifiedVirtualFile vfsRoot;
/* 112 */     UnifiedVirtualFile vfsRoot = this.usRef != null ? (vfsRoot = this.usRef.getVfsRoot()) : new ResourceLoaderAdapter();
/*     */ 
/* 115 */     if ((wsdlURL != null) && (serviceClass != Service.class))
/*     */     {
/*     */       try
/*     */       {
/* 119 */         InputStream is = wsdlURL.openStream();
/* 120 */         is.close();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 124 */         this.log.warn("Cannot access wsdlURL: " + wsdlURL);
/* 125 */         wsdlURL = null;
/*     */       }
/*     */     }
/*     */ 
/* 129 */     if (wsdlURL != null)
/*     */     {
/* 131 */       JAXWSClientMetaDataBuilder builder = new JAXWSClientMetaDataBuilder();
/* 132 */       this.serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, vfsRoot);
/*     */     }
/*     */     else
/*     */     {
/* 136 */       UnifiedMetaData wsMetaData = new UnifiedMetaData(vfsRoot);
/* 137 */       this.serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
/* 138 */       wsMetaData.addService(this.serviceMetaData);
/*     */     }
/*     */ 
/* 141 */     this.handlerResolver = new HandlerResolverImpl();
/*     */ 
/* 143 */     if (this.usRef != null)
/*     */     {
/* 145 */       this.serviceMetaData.setServiceRefName(this.usRef.getServiceRefName());
/*     */ 
/* 148 */       if (this.usRef.getHandlerChain() != null)
/*     */       {
/* 150 */         String filename = this.usRef.getHandlerChain();
/* 151 */         UnifiedHandlerChainsMetaData handlerChainsMetaData = JAXWSMetaDataBuilder.getHandlerChainsMetaData(serviceClass, filename);
/* 152 */         for (UnifiedHandlerChainMetaData UnifiedHandlerChainMetaData : handlerChainsMetaData.getHandlerChains())
/*     */         {
/* 154 */           for (UnifiedHandlerMetaData uhmd : UnifiedHandlerChainMetaData.getHandlers())
/*     */           {
/* 156 */             HandlerMetaDataJAXWS hmd = HandlerMetaDataJAXWS.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/* 157 */             this.serviceMetaData.addHandler(hmd);
/*     */           }
/*     */         }
/* 160 */         ((HandlerResolverImpl)this.handlerResolver).initServiceHandlerChain(this.serviceMetaData);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public <T> T getPort(QName portName, Class<T> seiClass)
/*     */   {
/* 172 */     assertSEIConstraints(seiClass);
/*     */ 
/* 174 */     if (this.serviceMetaData == null) {
/* 175 */       throw new WebServiceException("Service meta data not available");
/*     */     }
/*     */ 
/* 178 */     EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
/* 179 */     if ((this.serviceMetaData.getEndpoints().size() > 0) && (epMetaData == null)) {
/* 180 */       throw new WebServiceException("Cannot get port meta data for: " + portName);
/*     */     }
/*     */ 
/* 183 */     if (this.serviceMetaData.getEndpoints().size() == 0)
/*     */     {
/* 185 */       this.log.warn("Cannot get port meta data for: " + portName);
/*     */ 
/* 187 */       QName portType = getPortTypeName(seiClass);
/* 188 */       epMetaData = new ClientEndpointMetaData(this.serviceMetaData, portName, portType, EndpointMetaData.Type.JAXWS);
/*     */     }
/*     */ 
/* 191 */     String seiClassName = seiClass.getName();
/* 192 */     epMetaData.setServiceEndpointInterfaceName(seiClassName);
/*     */ 
/* 194 */     return getPortInternal(epMetaData, seiClass);
/*     */   }
/*     */ 
/*     */   public <T> T getPort(Class<T> seiClass)
/*     */   {
/* 204 */     assertSEIConstraints(seiClass);
/*     */ 
/* 206 */     if (this.serviceMetaData == null) {
/* 207 */       throw new WebServiceException("Service meta data not available");
/*     */     }
/* 209 */     String seiClassName = seiClass.getName();
/* 210 */     EndpointMetaData epMetaData = this.serviceMetaData.getEndpointByServiceEndpointInterface(seiClassName);
/*     */     QName portTypeName;
/* 212 */     if ((epMetaData == null) && (this.serviceMetaData.getEndpoints().size() == 1))
/*     */     {
/* 214 */       epMetaData = (EndpointMetaData)this.serviceMetaData.getEndpoints().get(0);
/* 215 */       epMetaData.setServiceEndpointInterfaceName(seiClassName);
/*     */     }
/*     */     else
/*     */     {
/* 219 */       portTypeName = getPortTypeName(seiClass);
/* 220 */       for (EndpointMetaData epmd : this.serviceMetaData.getEndpoints())
/*     */       {
/* 222 */         if (portTypeName.equals(epmd.getPortTypeName()))
/*     */         {
/* 224 */           epmd.setServiceEndpointInterfaceName(seiClass.getName());
/* 225 */           epMetaData = epmd;
/* 226 */           break;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 231 */     if (epMetaData == null) {
/* 232 */       throw new WebServiceException("Cannot get port meta data for: " + seiClassName);
/*     */     }
/* 234 */     return getPortInternal(epMetaData, seiClass);
/*     */   }
/*     */ 
/*     */   private <T> QName getPortTypeName(Class<T> seiClass)
/*     */   {
/* 239 */     if (!seiClass.isAnnotationPresent(WebService.class)) {
/* 240 */       throw new IllegalArgumentException("Cannot find @WebService on: " + seiClass.getName());
/*     */     }
/* 242 */     WebService anWebService = (WebService)seiClass.getAnnotation(WebService.class);
/* 243 */     String localPart = anWebService.name();
/* 244 */     if (localPart.length() == 0) {
/* 245 */       localPart = WSDLUtils.getJustClassName(seiClass);
/*     */     }
/* 247 */     String nsURI = anWebService.targetNamespace();
/* 248 */     if (nsURI.length() == 0) {
/* 249 */       nsURI = WSDLUtils.getTypeNamespace(seiClass);
/*     */     }
/* 251 */     QName portType = new QName(nsURI, localPart);
/* 252 */     return portType;
/*     */   }
/*     */ 
/*     */   private <T> T getPortInternal(EndpointMetaData epMetaData, Class<T> seiClass)
/*     */   {
/* 257 */     QName portName = epMetaData.getPortName();
/*     */ 
/* 260 */     if (!this.annotatedPorts.contains(portName))
/*     */     {
/* 262 */       JAXWSClientMetaDataBuilder metaDataBuilder = new JAXWSClientMetaDataBuilder();
/* 263 */       metaDataBuilder.rebuildEndpointMetaData(epMetaData, seiClass);
/* 264 */       this.annotatedPorts.add(portName);
/*     */     }
/*     */ 
/* 267 */     return createProxy(seiClass, epMetaData);
/*     */   }
/*     */ 
/*     */   private void assertSEIConstraints(Class seiClass)
/*     */   {
/* 272 */     if (seiClass == null) {
/* 273 */       throw new IllegalArgumentException("Service endpoint interface cannot be null");
/*     */     }
/* 275 */     if (!seiClass.isAnnotationPresent(WebService.class))
/* 276 */       throw new WebServiceException("SEI is missing @WebService annotation: " + seiClass);
/*     */   }
/*     */ 
/*     */   public void addPort(QName portName, String bindingId, String epAddress)
/*     */   {
/* 287 */     EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
/* 288 */     if (epMetaData == null)
/*     */     {
/* 290 */       epMetaData = new ClientEndpointMetaData(this.serviceMetaData, portName, null, EndpointMetaData.Type.JAXWS);
/* 291 */       this.serviceMetaData.addEndpoint(epMetaData);
/*     */     }
/* 293 */     epMetaData.setBindingId(bindingId);
/* 294 */     epMetaData.setEndpointAddress(epAddress);
/*     */   }
/*     */ 
/*     */   public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode)
/*     */   {
/* 300 */     ExecutorService executor = (ExecutorService)getExecutor();
/* 301 */     EndpointMetaData epMetaData = getEndpointMetaData(portName);
/* 302 */     DispatchImpl dispatch = new DispatchImpl(executor, epMetaData, type, mode);
/* 303 */     return dispatch;
/*     */   }
/*     */ 
/*     */   public Dispatch<Object> createDispatch(QName portName, JAXBContext jbc, Service.Mode mode)
/*     */   {
/* 309 */     ExecutorService executor = (ExecutorService)getExecutor();
/* 310 */     EndpointMetaData epMetaData = getEndpointMetaData(portName);
/* 311 */     DispatchImpl dispatch = new DispatchImpl(executor, epMetaData, jbc, mode);
/* 312 */     return dispatch;
/*     */   }
/*     */ 
/*     */   private EndpointMetaData getEndpointMetaData(QName portName)
/*     */   {
/* 317 */     EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
/* 318 */     if (epMetaData == null) {
/* 319 */       throw new WebServiceException("Cannot find port: " + portName);
/*     */     }
/* 321 */     return epMetaData;
/*     */   }
/*     */ 
/*     */   public QName getServiceName()
/*     */   {
/* 328 */     return this.serviceMetaData.getServiceName();
/*     */   }
/*     */ 
/*     */   public Iterator<QName> getPorts()
/*     */   {
/* 335 */     ArrayList portNames = new ArrayList();
/* 336 */     for (EndpointMetaData epMetaData : this.serviceMetaData.getEndpoints())
/*     */     {
/* 338 */       portNames.add(epMetaData.getPortName());
/*     */     }
/* 340 */     return portNames.iterator();
/*     */   }
/*     */ 
/*     */   public URL getWSDLDocumentLocation()
/*     */   {
/* 346 */     return this.serviceMetaData.getWsdlLocation();
/*     */   }
/*     */ 
/*     */   public HandlerResolver getHandlerResolver()
/*     */   {
/* 352 */     return this.handlerResolver;
/*     */   }
/*     */ 
/*     */   public void setHandlerResolver(HandlerResolver handlerResolver)
/*     */   {
/* 358 */     this.handlerResolver = handlerResolver;
/*     */   }
/*     */ 
/*     */   public Executor getExecutor()
/*     */   {
/* 364 */     if (this.executor == null)
/*     */     {
/* 366 */       this.executor = defaultExecutor;
/*     */     }
/* 368 */     return this.executor;
/*     */   }
/*     */ 
/*     */   public void setExecutor(Executor executor)
/*     */   {
/* 374 */     if (!(executor instanceof ExecutorService)) {
/* 375 */       throw new IllegalArgumentException("Supported executors must implement " + ExecutorService.class.getName());
/*     */     }
/* 377 */     this.executor = ((ExecutorService)executor);
/*     */   }
/*     */ 
/*     */   private <T> T createProxy(Class<T> seiClass, EndpointMetaData epMetaData) throws WebServiceException
/*     */   {
/* 382 */     if (seiClass == null) {
/* 383 */       throw new IllegalArgumentException("SEI class cannot be null");
/*     */     }try {
/* 387 */       ExecutorService executor = (ExecutorService)getExecutor();
/* 388 */       ClientProxy handler = new ClientProxy(executor, new ClientImpl(epMetaData, this.handlerResolver));
/* 389 */       ClassLoader cl = epMetaData.getClassLoader();
/*     */       Object proxy;
/*     */       try {
/* 394 */         proxy = Proxy.newProxyInstance(cl, new Class[] { seiClass, BindingProvider.class, StubExt.class }, handler);
/*     */       }
/*     */       catch (RuntimeException rte)
/*     */       {
/* 398 */         URL codeLocation = seiClass.getProtectionDomain().getCodeSource().getLocation();
/* 399 */         this.log.error("Cannot create proxy for SEI " + seiClass.getName() + " from: " + codeLocation);
/* 400 */         throw rte;
/*     */       }
/*     */ 
/* 404 */       configureStub((StubExt)proxy);
/*     */ 
/* 406 */       return proxy;
/*     */     }
/*     */     catch (WebServiceException ex)
/*     */     {
/* 410 */       throw ex;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 414 */     throw new WebServiceException("Cannot create proxy", ex);
/*     */   }
/*     */ 
/*     */   private void configureStub(StubExt stub)
/*     */   {
/* 420 */     EndpointMetaData epMetaData = stub.getEndpointMetaData();
/* 421 */     String seiName = epMetaData.getServiceEndpointInterfaceName();
/* 422 */     QName portName = epMetaData.getPortName();
/*     */ 
/* 424 */     if (this.usRef == null)
/*     */     {
/* 426 */       this.log.debug("No port configuration for: " + portName);
/* 427 */       return;
/*     */     }
/*     */ 
/* 430 */     String configFile = this.usRef.getConfigFile();
/* 431 */     String configName = this.usRef.getConfigName();
/*     */ 
/* 433 */     UnifiedPortComponentRefMetaData pcref = this.usRef.getPortComponentRef(seiName, portName);
/*     */     Map reqCtx;
/* 434 */     if (pcref != null)
/*     */     {
/* 436 */       if (pcref.getConfigFile() != null)
/* 437 */         configFile = pcref.getConfigFile();
/* 438 */       if (pcref.getConfigName() != null) {
/* 439 */         configName = pcref.getConfigName();
/*     */       }
/* 441 */       BindingProvider bp = (BindingProvider)stub;
/* 442 */       reqCtx = bp.getRequestContext();
/* 443 */       for (UnifiedStubPropertyMetaData prop : pcref.getStubProperties())
/*     */       {
/* 445 */         this.log.debug("Set stub property: " + prop);
/* 446 */         reqCtx.put(prop.getPropName(), prop.getPropValue());
/*     */       }
/*     */     }
/*     */ 
/* 450 */     if ((configName != null) || (configFile != null))
/*     */     {
/* 452 */       this.log.debug("Configure Stub: [configName=" + configName + ",configFile=" + configFile + "]");
/* 453 */       stub.setConfigName(configName, configFile);
/*     */     }
/*     */   }
/*     */ 
/*     */   public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode, WebServiceFeature[] features)
/*     */   {
/* 460 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public <T> Dispatch<T> createDispatch(EndpointReference endpointReference, Class<T> type, Service.Mode mode, WebServiceFeature[] features)
/*     */   {
/* 466 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode, WebServiceFeature[] features)
/*     */   {
/* 472 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Dispatch<Object> createDispatch(EndpointReference endpointReference, JAXBContext context, Service.Mode mode, WebServiceFeature[] features)
/*     */   {
/* 478 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public <T> T getPort(QName portName, Class<T> serviceEndpointInterface, WebServiceFeature[] features)
/*     */   {
/* 484 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature[] features)
/*     */   {
/* 490 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public <T> T getPort(Class<T> serviceEndpointInterface, WebServiceFeature[] features)
/*     */   {
/* 496 */     throw new NotImplementedException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.spi.ServiceDelegateImpl
 * JD-Core Version:    0.6.0
 */