/*     */ package org.jboss.ws.core.jaxws.handler;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.xml.ws.LogicalMessage;
/*     */ import javax.xml.ws.handler.LogicalMessageContext;
/*     */ import javax.xml.ws.handler.MessageContext;
/*     */ import javax.xml.ws.handler.MessageContext.Scope;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ 
/*     */ public class LogicalMessageContextImpl
/*     */   implements LogicalMessageContext
/*     */ {
/*     */   private LogicalMessage logicalMessage;
/*     */   private MessageContext delegate;
/*     */ 
/*     */   public LogicalMessageContextImpl(MessageContextJAXWS msgContext)
/*     */   {
/*  52 */     this.delegate = msgContext;
/*     */ 
/*  54 */     Style style = msgContext.getEndpointMetaData().getStyle();
/*  55 */     MessageAbstraction message = msgContext.getMessageAbstraction();
/*  56 */     this.logicalMessage = new LogicalMessageImpl(message, style);
/*     */   }
/*     */ 
/*     */   public LogicalMessage getMessage()
/*     */   {
/*  65 */     return this.logicalMessage;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  72 */     this.delegate.clear();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/*  77 */     return this.delegate.containsKey(key);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object value)
/*     */   {
/*  82 */     return this.delegate.containsValue(value);
/*     */   }
/*     */ 
/*     */   public Set<Map.Entry<String, Object>> entrySet()
/*     */   {
/*  87 */     return this.delegate.entrySet();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*  92 */     return this.delegate.equals(o);
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/*  97 */     return this.delegate.get(key);
/*     */   }
/*     */ 
/*     */   public MessageContext.Scope getScope(String name)
/*     */   {
/* 102 */     return this.delegate.getScope(name);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 107 */     return this.delegate.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 112 */     return this.delegate.isEmpty();
/*     */   }
/*     */ 
/*     */   public Set<String> keySet()
/*     */   {
/* 117 */     return this.delegate.keySet();
/*     */   }
/*     */ 
/*     */   public Object put(String key, Object value)
/*     */   {
/* 122 */     return this.delegate.put(key, value);
/*     */   }
/*     */ 
/*     */   public void putAll(Map<? extends String, ? extends Object> t)
/*     */   {
/* 127 */     this.delegate.putAll(t);
/*     */   }
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/* 132 */     return this.delegate.remove(key);
/*     */   }
/*     */ 
/*     */   public void setScope(String name, MessageContext.Scope scope)
/*     */   {
/* 137 */     this.delegate.setScope(name, scope);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 142 */     return this.delegate.size();
/*     */   }
/*     */ 
/*     */   public Collection<Object> values()
/*     */   {
/* 147 */     return this.delegate.values();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.handler.LogicalMessageContextImpl
 * JD-Core Version:    0.6.0
 */