/*     */ package org.jboss.ws.core.jaxws.handler;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.annotation.PostConstruct;
/*     */ import javax.annotation.Resource;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.handler.Handler;
/*     */ import javax.xml.ws.handler.HandlerResolver;
/*     */ import javax.xml.ws.handler.PortInfo;
/*     */ import javax.xml.ws.handler.soap.SOAPHandler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaData;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class HandlerResolverImpl
/*     */   implements HandlerResolver
/*     */ {
/*  68 */   private static Logger log = Logger.getLogger(HandlerResolverImpl.class);
/*     */ 
/*  70 */   private static final Map<String, String> protocolMap = new HashMap();
/*     */   private List<ScopedHandler> preHandlers;
/*     */   private List<ScopedHandler> jaxwsHandlers;
/*     */   private List<ScopedHandler> postHandlers;
/*     */   Set<QName> headers;
/*     */ 
/*     */   public HandlerResolverImpl()
/*     */   {
/*  80 */     this.preHandlers = new ArrayList();
/*  81 */     this.jaxwsHandlers = new ArrayList();
/*  82 */     this.postHandlers = new ArrayList();
/*     */ 
/*  85 */     this.headers = new HashSet();
/*     */   }
/*     */ 
/*     */   public Set<QName> getHeaders() {
/*  89 */     return this.headers;
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain(PortInfo info)
/*     */   {
/*  94 */     return getHandlerChain(info, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain(PortInfo info, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/*  99 */     log.debug("getHandlerChain: [type=" + type + ",info=" + info + "]");
/*     */ 
/* 101 */     List handlers = new ArrayList();
/* 102 */     for (ScopedHandler scopedHandler : getHandlerMap(type))
/*     */     {
/* 104 */       if (scopedHandler.matches(info))
/* 105 */         handlers.add(scopedHandler.handler);
/*     */     }
/* 107 */     return handlers;
/*     */   }
/*     */ 
/*     */   public void initServiceHandlerChain(ServiceMetaData serviceMetaData)
/*     */   {
/* 112 */     log.debug("initServiceHandlerChain: " + serviceMetaData.getServiceName());
/*     */ 
/* 115 */     List handlerMap = getHandlerMap(UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/* 116 */     handlerMap.clear();
/*     */ 
/* 118 */     ClassLoader classLoader = serviceMetaData.getUnifiedMetaData().getClassLoader();
/* 119 */     for (HandlerMetaData handlerMetaData : serviceMetaData.getHandlerMetaData())
/* 120 */       addHandler(classLoader, UnifiedHandlerMetaData.HandlerType.ENDPOINT, handlerMetaData);
/*     */   }
/*     */ 
/*     */   public void initHandlerChain(EndpointMetaData epMetaData, UnifiedHandlerMetaData.HandlerType type, boolean clearExistingHandlers)
/*     */   {
/* 125 */     log.debug("initHandlerChain: " + type);
/*     */ 
/* 127 */     List handlerMap = getHandlerMap(type);
/*     */ 
/* 129 */     if (clearExistingHandlers) {
/* 130 */       handlerMap.clear();
/*     */     }
/* 132 */     ClassLoader classLoader = epMetaData.getClassLoader();
/* 133 */     for (HandlerMetaData handlerMetaData : epMetaData.getHandlerMetaData(type))
/* 134 */       addHandler(classLoader, type, handlerMetaData);
/*     */   }
/*     */ 
/*     */   private void addHandler(ClassLoader classLoader, UnifiedHandlerMetaData.HandlerType type, HandlerMetaData handlerMetaData)
/*     */   {
/* 139 */     HandlerMetaDataJAXWS jaxwsMetaData = (HandlerMetaDataJAXWS)handlerMetaData;
/* 140 */     String handlerName = jaxwsMetaData.getHandlerName();
/* 141 */     String className = jaxwsMetaData.getHandlerClassName();
/* 142 */     Set soapHeaders = jaxwsMetaData.getSoapHeaders();
/*     */     try
/*     */     {
/* 147 */       Class hClass = classLoader.loadClass(className);
/* 148 */       Handler handler = (Handler)hClass.newInstance();
/*     */ 
/* 150 */       if ((handler instanceof GenericHandler)) {
/* 151 */         ((GenericHandler)handler).setHandlerName(handlerName);
/*     */       }
/* 153 */       if ((handler instanceof GenericSOAPHandler)) {
/* 154 */         ((GenericSOAPHandler)handler).setHeaders(soapHeaders);
/*     */       }
/*     */ 
/* 157 */       injectResources(handler);
/*     */ 
/* 160 */       callPostConstruct(handler);
/*     */ 
/* 162 */       addHandler(jaxwsMetaData, handler, type);
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 166 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 170 */       throw new WSException("Cannot load handler: " + className, ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void injectResources(Handler handler)
/*     */   {
/* 176 */     Class handlerClass = handler.getClass();
/* 177 */     for (Field field : handlerClass.getFields())
/*     */     {
/* 179 */       if (field.isAnnotationPresent(Resource.class))
/* 180 */         throw new NotImplementedException("@Resource not implemented for handler: " + handlerClass.getName());
/*     */     }
/* 182 */     for (Method method : handlerClass.getMethods())
/*     */     {
/* 184 */       if (method.isAnnotationPresent(Resource.class))
/* 185 */         throw new NotImplementedException("@Resource not implemented for handler: " + handlerClass.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void callPostConstruct(Handler handler) throws Exception
/*     */   {
/* 191 */     Class handlerClass = handler.getClass();
/* 192 */     for (Method method : handlerClass.getMethods())
/*     */     {
/* 194 */       if (!method.isAnnotationPresent(PostConstruct.class))
/*     */         continue;
/* 196 */       method.invoke(handler, new Object[0]);
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean addHandler(HandlerMetaDataJAXWS hmd, Handler handler, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 203 */     log.debug("addHandler: " + hmd);
/*     */ 
/* 205 */     List handlerMap = getHandlerMap(type);
/* 206 */     ScopedHandler scopedHandler = new ScopedHandler(handler);
/* 207 */     scopedHandler.servicePattern = hmd.getServiceNamePattern();
/* 208 */     scopedHandler.portPattern = hmd.getPortNamePattern();
/* 209 */     scopedHandler.protocols = hmd.getProtocolBindings();
/* 210 */     handlerMap.add(scopedHandler);
/*     */ 
/* 213 */     if ((handler instanceof SOAPHandler))
/*     */     {
/* 215 */       Set handlerHeaders = ((SOAPHandler)handler).getHeaders();
/* 216 */       if (handlerHeaders != null) {
/* 217 */         this.headers.addAll(handlerHeaders);
/*     */       }
/*     */     }
/* 220 */     return true;
/*     */   }
/*     */ 
/*     */   private List<ScopedHandler> getHandlerMap(UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 225 */     List handlers = null;
/* 226 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/* 227 */       handlers = this.preHandlers;
/* 228 */     else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT)
/* 229 */       handlers = this.jaxwsHandlers;
/* 230 */     else if (type == UnifiedHandlerMetaData.HandlerType.POST)
/* 231 */       handlers = this.postHandlers;
/* 232 */     else throw new IllegalArgumentException("Illegal handler type: " + type);
/*     */ 
/* 234 */     return handlers;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  73 */     protocolMap.put("##SOAP11_HTTP", "http://schemas.xmlsoap.org/wsdl/soap/http");
/*  74 */     protocolMap.put("##SOAP11_HTTP_MTOM", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
/*  75 */     protocolMap.put("##SOAP12_HTTP", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
/*  76 */     protocolMap.put("##SOAP12_HTTP_MTOM", "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
/*  77 */     protocolMap.put("##XML_HTTP", "http://www.w3.org/2004/08/wsdl/http");
/*     */   }
/*     */ 
/*     */   private class ScopedHandler
/*     */   {
/*     */     Handler handler;
/*     */     QName servicePattern;
/*     */     QName portPattern;
/*     */     String protocols;
/*     */     Set<String> bindings;
/*     */ 
/*     */     ScopedHandler(Handler handler)
/*     */     {
/* 248 */       this.handler = handler;
/*     */     }
/*     */ 
/*     */     boolean matches(PortInfo info)
/*     */     {
/* 253 */       boolean match = true;
/* 254 */       if (this.servicePattern != null)
/*     */       {
/* 256 */         QName serviceName = info.getServiceName();
/* 257 */         match = matchQNamePattern(this.servicePattern, serviceName);
/*     */       }
/* 259 */       if ((match) && (this.portPattern != null))
/*     */       {
/* 261 */         QName portName = info.getPortName();
/* 262 */         match = matchQNamePattern(this.portPattern, portName);
/*     */       }
/* 264 */       if ((match) && (this.protocols != null))
/*     */       {
/* 266 */         boolean bindingMatch = false;
/* 267 */         String bindingID = info.getBindingID();
/* 268 */         for (String protocol : this.protocols.split("\\s"))
/*     */         {
/* 270 */           String aux = (String)HandlerResolverImpl.protocolMap.get(protocol);
/* 271 */           if ((aux == null) || (!aux.equals(bindingID)))
/*     */             continue;
/* 273 */           bindingMatch = true;
/* 274 */           break;
/*     */         }
/*     */ 
/* 277 */         match = bindingMatch;
/*     */       }
/* 279 */       return match;
/*     */     }
/*     */ 
/*     */     boolean matchQNamePattern(QName pattern, QName qname)
/*     */     {
/* 284 */       boolean match = true;
/* 285 */       String nsURI = pattern.getNamespaceURI();
/* 286 */       String localPart = pattern.getLocalPart();
/* 287 */       if (!localPart.equals("*"))
/*     */       {
/* 289 */         if (localPart.endsWith("*")) {
/* 290 */           localPart = localPart.substring(0, localPart.length() - 1);
/*     */         }
/* 292 */         String qnameStr = qname.toString();
/* 293 */         String patternStr = new QName(nsURI, localPart).toString();
/* 294 */         match = qnameStr.startsWith(patternStr);
/*     */       }
/* 296 */       return match;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.handler.HandlerResolverImpl
 * JD-Core Version:    0.6.0
 */