/*     */ package org.jboss.ws.core.jaxws.handler;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Observable;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.handler.Handler;
/*     */ import javax.xml.ws.handler.MessageContext;
/*     */ import javax.xml.ws.handler.PortInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.server.ServerHandlerDelegate;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class HandlerDelegateJAXWS extends ServerHandlerDelegate
/*     */ {
/*  51 */   private static Logger log = Logger.getLogger(HandlerDelegateJAXWS.class);
/*  52 */   private HandlerResolverImpl resolver = new HandlerResolverImpl();
/*     */ 
/*  54 */   private ThreadLocal<HandlerChainExecutor> preExecutor = new ThreadLocal();
/*  55 */   private ThreadLocal<HandlerChainExecutor> jaxwsExecutor = new ThreadLocal();
/*  56 */   private ThreadLocal<HandlerChainExecutor> postExecutor = new ThreadLocal();
/*     */ 
/*     */   public HandlerDelegateJAXWS(ServerEndpointMetaData sepMetaData)
/*     */   {
/*  60 */     super(sepMetaData);
/*  61 */     sepMetaData.registerConfigObserver(this);
/*     */   }
/*     */ 
/*     */   public UnifiedHandlerMetaData.HandlerType[] getHandlerTypeOrder()
/*     */   {
/*  69 */     return new UnifiedHandlerMetaData.HandlerType[] { UnifiedHandlerMetaData.HandlerType.POST, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.PRE };
/*     */   }
/*     */ 
/*     */   public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/*  74 */     log.debug("callRequestHandlerChain: " + type);
/*     */ 
/*  77 */     if (!isInitialized())
/*     */     {
/*  79 */       this.resolver.initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.PRE, true);
/*  80 */       this.resolver.initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.ENDPOINT, true);
/*  81 */       this.resolver.initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.POST, true);
/*  82 */       setInitialized(true);
/*     */     }
/*     */ 
/*  85 */     HandlerChainExecutor executor = createExecutor(sepMetaData, type);
/*  86 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/*  87 */     return executor.handleMessage(msgContext);
/*     */   }
/*     */ 
/*     */   public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/*  92 */     log.debug("callResponseHandlerChain: " + type);
/*  93 */     HandlerChainExecutor executor = getExecutor(type);
/*  94 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/*  95 */     return executor != null ? executor.handleMessage(msgContext) : true;
/*     */   }
/*     */ 
/*     */   public void closeHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 100 */     log.debug("closeHandlerChain");
/* 101 */     HandlerChainExecutor executor = getExecutor(type);
/* 102 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/* 103 */     if (executor != null)
/*     */     {
/* 105 */       executor.close(msgContext);
/* 106 */       removeExecutor(type);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type, Exception ex)
/*     */   {
/* 112 */     log.debug("callFaultHandlerChain: " + type);
/* 113 */     HandlerChainExecutor executor = getExecutor(type);
/* 114 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/* 115 */     return executor != null ? executor.handleFault(msgContext, ex) : true;
/*     */   }
/*     */ 
/*     */   private List<Handler> getHandlerChain(EndpointMetaData epMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 120 */     PortInfo info = getPortInfo(epMetaData);
/* 121 */     return this.resolver.getHandlerChain(info, type);
/*     */   }
/*     */ 
/*     */   private PortInfo getPortInfo(EndpointMetaData epMetaData)
/*     */   {
/* 126 */     QName serviceName = epMetaData.getServiceMetaData().getServiceName();
/* 127 */     QName portName = epMetaData.getPortName();
/* 128 */     String bindingId = epMetaData.getBindingId();
/* 129 */     PortInfo info = new PortInfoImpl(serviceName, portName, bindingId);
/* 130 */     return info;
/*     */   }
/*     */ 
/*     */   public Set<QName> getHeaders()
/*     */   {
/* 135 */     return this.resolver.getHeaders();
/*     */   }
/*     */ 
/*     */   private HandlerChainExecutor createExecutor(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 140 */     if (type == UnifiedHandlerMetaData.HandlerType.ALL) {
/* 141 */       throw new IllegalArgumentException("Invalid handler type: " + type);
/*     */     }
/* 143 */     HandlerChainExecutor executor = new HandlerChainExecutor(sepMetaData, getHandlerChain(sepMetaData, type));
/* 144 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/* 145 */       this.preExecutor.set(executor);
/* 146 */     else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT)
/* 147 */       this.jaxwsExecutor.set(executor);
/* 148 */     else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
/* 149 */       this.postExecutor.set(executor);
/*     */     }
/* 151 */     return executor;
/*     */   }
/*     */ 
/*     */   private HandlerChainExecutor getExecutor(UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 156 */     if (type == UnifiedHandlerMetaData.HandlerType.ALL) {
/* 157 */       throw new IllegalArgumentException("Invalid handler type: " + type);
/*     */     }
/* 159 */     HandlerChainExecutor executor = null;
/* 160 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/* 161 */       executor = (HandlerChainExecutor)this.preExecutor.get();
/* 162 */     else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT)
/* 163 */       executor = (HandlerChainExecutor)this.jaxwsExecutor.get();
/* 164 */     else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
/* 165 */       executor = (HandlerChainExecutor)this.postExecutor.get();
/*     */     }
/* 167 */     return executor;
/*     */   }
/*     */ 
/*     */   private void removeExecutor(UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 172 */     if (type == UnifiedHandlerMetaData.HandlerType.ALL) {
/* 173 */       throw new IllegalArgumentException("Invalid handler type: " + type);
/*     */     }
/* 175 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/* 176 */       this.preExecutor.remove();
/* 177 */     else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT)
/* 178 */       this.jaxwsExecutor.remove();
/* 179 */     else if (type == UnifiedHandlerMetaData.HandlerType.POST)
/* 180 */       this.postExecutor.remove();
/*     */   }
/*     */ 
/*     */   public void update(Observable observable, Object object)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.handler.HandlerDelegateJAXWS
 * JD-Core Version:    0.6.0
 */