/*     */ package org.jboss.ws.core.jaxws.client;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.Service;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.ConfigProvider;
/*     */ import org.jboss.ws.core.client.ServiceObjectFactory;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*     */ 
/*     */ public class ServiceObjectFactoryJAXWS extends ServiceObjectFactory
/*     */ {
/*  61 */   private static final Logger log = Logger.getLogger(ServiceObjectFactoryJAXWS.class);
/*     */ 
/*  64 */   private static ThreadLocal<UnifiedServiceRefMetaData> serviceRefAssociation = new ThreadLocal();
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/*  90 */       Reference ref = (Reference)obj;
/*     */ 
/*  93 */       String targetClassName = (String)ref.get("TARGET_CLASS_NAME").getContent();
/*     */ 
/*  96 */       UnifiedServiceRefMetaData serviceRef = unmarshallServiceRef(ref);
/*  97 */       String serviceRefName = serviceRef.getServiceRefName();
/*  98 */       QName serviceQName = serviceRef.getServiceQName();
/*     */ 
/* 100 */       String serviceImplClass = serviceRef.getServiceImplClass();
/* 101 */       if (serviceImplClass == null) {
/* 102 */         serviceImplClass = (String)ref.get("SERVICE_CLASS_NAME").getContent();
/*     */       }
/*     */ 
/* 105 */       if (Service.class.getName().equals(targetClassName)) {
/* 106 */         targetClassName = serviceImplClass;
/*     */       }
/* 108 */       log.debug("[name=" + serviceRefName + ",service=" + serviceImplClass + ",target=" + targetClassName + "]");
/*     */ 
/* 111 */       ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
/* 112 */       Class serviceClass = ctxLoader.loadClass(serviceImplClass);
/* 113 */       Class targetClass = targetClassName != null ? ctxLoader.loadClass(targetClassName) : null;
/*     */ 
/* 115 */       if (!Service.class.isAssignableFrom(serviceClass)) {
/* 116 */         throw new IllegalArgumentException("WebServiceRef type '" + serviceClass + "' is not assignable to javax.xml.ws.Service");
/*     */       }
/*     */ 
/* 118 */       log.debug("Loaded Service '" + serviceClass.getName() + "' from: " + serviceClass.getProtectionDomain().getCodeSource());
/*     */ 
/* 124 */       URL wsdlURL = serviceRef.getWsdlLocation();
/*     */       Object target;
/*     */       try
/*     */       {
/* 128 */         serviceRefAssociation.set(serviceRef);
/*     */ 
/* 131 */         if (serviceClass == Service.class)
/*     */         {
/*     */           Object target;
/* 133 */           if (wsdlURL != null)
/*     */           {
/* 135 */             target = Service.create(wsdlURL, serviceQName);
/*     */           }
/*     */           else
/*     */           {
/* 139 */             throw new IllegalArgumentException("Cannot create generic javax.xml.ws.Service without wsdlLocation: " + serviceRefName);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/*     */           Object target;
/* 145 */           if (wsdlURL != null)
/*     */           {
/* 147 */             Constructor ctor = serviceClass.getConstructor(new Class[] { URL.class, QName.class });
/* 148 */             target = ctor.newInstance(new Object[] { wsdlURL, serviceQName });
/*     */           }
/*     */           else
/*     */           {
/* 152 */             target = (Service)serviceClass.newInstance();
/*     */           }
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 158 */         serviceRefAssociation.set(null);
/*     */       }
/*     */ 
/* 162 */       configureService((Service)target, serviceRef);
/*     */ 
/* 164 */       if ((targetClassName != null) && (!targetClassName.equals(serviceImplClass)))
/*     */       {
/*     */         try
/*     */         {
/* 168 */           Object port = null;
/* 169 */           if (serviceClass != Service.class)
/*     */           {
/* 171 */             for (Method method : serviceClass.getDeclaredMethods())
/*     */             {
/* 173 */               String methodName = method.getName();
/* 174 */               Class retType = method.getReturnType();
/* 175 */               if ((!methodName.startsWith("get")) || (!targetClass.isAssignableFrom(retType)))
/*     */                 continue;
/* 177 */               port = method.invoke(target, new Object[0]);
/* 178 */               target = port;
/* 179 */               break;
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/* 184 */           if (port == null)
/*     */           {
/* 186 */             Method method = serviceClass.getMethod("getPort", new Class[] { Class.class });
/* 187 */             port = method.invoke(target, new Object[] { targetClass });
/* 188 */             target = port;
/*     */           }
/*     */         }
/*     */         catch (InvocationTargetException ex)
/*     */         {
/* 193 */           throw ex.getTargetException();
/*     */         }
/*     */       }
/*     */ 
/* 197 */       return target;
/*     */     }
/*     */     catch (Throwable ex)
/*     */     {
/* 201 */       WSException.rethrow("Cannot create service", ex);
/* 202 */     }return null;
/*     */   }
/*     */ 
/*     */   public static UnifiedServiceRefMetaData getServiceRefAssociation()
/*     */   {
/* 209 */     return (UnifiedServiceRefMetaData)serviceRefAssociation.get();
/*     */   }
/*     */ 
/*     */   private void configureService(Service service, UnifiedServiceRefMetaData serviceRef)
/*     */   {
/* 214 */     String configFile = serviceRef.getConfigFile();
/* 215 */     String configName = serviceRef.getConfigName();
/* 216 */     if ((service instanceof ConfigProvider))
/*     */     {
/* 218 */       if (log.isDebugEnabled()) log.debug("Configure Service: [configName=" + configName + ",configFile=" + configFile + "]");
/*     */ 
/* 220 */       ConfigProvider cp = (ConfigProvider)service;
/* 221 */       if ((configName != null) || (configFile != null))
/* 222 */         cp.setConfigName(configName, configFile); 
/*     */     }
/*     */   }
/*     */ 
/*     */   private UnifiedServiceRefMetaData unmarshallServiceRef(Reference ref) throws ClassNotFoundException, NamingException {
/* 229 */     RefAddr refAddr = ref.get("SERVICE_REF_META_DATA");
/* 230 */     ByteArrayInputStream bais = new ByteArrayInputStream((byte[])(byte[])refAddr.getContent());
/*     */     UnifiedServiceRefMetaData sref;
/*     */     try {
/* 233 */       ObjectInputStream ois = new ObjectInputStream(bais);
/* 234 */       sref = (UnifiedServiceRefMetaData)ois.readObject();
/* 235 */       ois.close();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 239 */       throw new NamingException("Cannot unmarshall service ref meta data, cause: " + e.toString());
/*     */     }
/* 241 */     return sref;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.client.ServiceObjectFactoryJAXWS
 * JD-Core Version:    0.6.0
 */