/*     */ package org.jboss.ws.core.jaxws.client;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.jws.HandlerChain;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Referenceable;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.Service;
/*     */ import javax.xml.ws.WebServiceClient;
/*     */ import javax.xml.ws.WebServiceRef;
/*     */ import javax.xml.ws.WebServiceRefs;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.naming.Util;
/*     */ import org.jboss.wsf.spi.WSFException;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefBinder;
/*     */ 
/*     */ public class NativeServiceRefBinderJAXWS
/*     */   implements ServiceRefBinder
/*     */ {
/*  60 */   private static Logger log = Logger.getLogger(NativeServiceRefBinderJAXWS.class);
/*     */ 
/*     */   public void setupServiceRef(Context encCtx, String encName, AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRef, ClassLoader loader) throws NamingException
/*     */   {
/*  64 */     WebServiceRef wsref = null;
/*     */ 
/*  66 */     if (null == loader) {
/*  67 */       throw new IllegalArgumentException("There needs to be a classloader available");
/*     */     }
/*     */ 
/*  70 */     List wsrefList = new ArrayList();
/*     */ 
/*  72 */     if (anElement != null)
/*     */     {
/*  74 */       for (Annotation an : anElement.getAnnotations())
/*     */       {
/*  76 */         if ((an instanceof WebServiceRef)) {
/*  77 */           wsrefList.add((WebServiceRef)an);
/*     */         }
/*  79 */         if (!(an instanceof WebServiceRefs))
/*     */           continue;
/*  81 */         WebServiceRefs wsrefs = (WebServiceRefs)an;
/*  82 */         for (WebServiceRef aux : wsrefs.value()) {
/*  83 */           wsrefList.add(aux);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  89 */     if (wsrefList.size() == 1)
/*     */     {
/*  91 */       wsref = (WebServiceRef)wsrefList.get(0);
/*     */     }
/*     */     else
/*     */     {
/*  95 */       for (WebServiceRef aux : wsrefList)
/*     */       {
/*  97 */         if (encName.endsWith("/" + aux.name()))
/*     */         {
/*  99 */           wsref = aux;
/* 100 */           break;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 105 */     Class targetClass = null;
/* 106 */     if ((anElement instanceof Field))
/*     */     {
/* 108 */       targetClass = ((Field)anElement).getType();
/*     */     }
/* 110 */     else if ((anElement instanceof Method))
/*     */     {
/* 112 */       targetClass = ((Method)anElement).getParameterTypes()[0];
/*     */     }
/* 116 */     else if ((wsref != null) && (wsref.type() != Object.class)) {
/* 117 */       targetClass = wsref.type();
/*     */     }
/*     */ 
/* 120 */     String targetClassName = targetClass != null ? targetClass.getName() : null;
/* 121 */     String externalName = encCtx.getNameInNamespace() + "/" + encName;
/* 122 */     log.debug("setupServiceRef [jndi=" + externalName + ",target=" + targetClassName + "]");
/*     */ 
/* 124 */     String serviceImplClass = null;
/*     */ 
/* 127 */     if ((wsref != null) && (wsref.value() != Object.class)) {
/* 128 */       serviceImplClass = wsref.value().getName();
/*     */     }
/*     */ 
/* 131 */     if ((serviceImplClass == null) && (targetClass != null) && (Service.class.isAssignableFrom(targetClass))) {
/* 132 */       serviceImplClass = targetClass.getName();
/*     */     }
/*     */ 
/* 135 */     if ((serviceImplClass == null) && (serviceRef.getServiceInterface() != null)) {
/* 136 */       serviceImplClass = serviceRef.getServiceInterface();
/*     */     }
/*     */ 
/* 139 */     if (serviceImplClass == null) {
/* 140 */       serviceImplClass = Service.class.getName();
/*     */     }
/*     */ 
/* 143 */     if ((wsref != null) && (wsref.type() != Object.class)) {
/* 144 */       targetClassName = wsref.type().getName();
/*     */     }
/*     */ 
/* 147 */     if ((targetClassName == null) && (targetClass != null) && (!Service.class.isAssignableFrom(targetClass))) {
/* 148 */       targetClassName = targetClass.getName();
/*     */     }
/*     */ 
/* 151 */     if ((serviceRef.getWsdlOverride() == null) && (wsref != null) && (wsref.wsdlLocation().length() > 0)) {
/* 152 */       serviceRef.setWsdlOverride(wsref.wsdlLocation());
/*     */     }
/*     */ 
/* 155 */     String handlerChain = serviceRef.getHandlerChain();
/* 156 */     if (anElement != null)
/*     */     {
/* 158 */       HandlerChain anHandlerChain = (HandlerChain)anElement.getAnnotation(HandlerChain.class);
/* 159 */       if ((handlerChain == null) && (anHandlerChain != null) && (anHandlerChain.file().length() > 0)) {
/* 160 */         handlerChain = anHandlerChain.file();
/*     */       }
/*     */     }
/*     */ 
/* 164 */     if (handlerChain != null)
/*     */     {
/*     */       try
/*     */       {
/* 168 */         new URL(handlerChain);
/*     */       }
/*     */       catch (MalformedURLException ex)
/*     */       {
/* 172 */         Class declaringClass = null;
/* 173 */         if ((anElement instanceof Field))
/* 174 */           declaringClass = ((Field)anElement).getDeclaringClass();
/* 175 */         else if ((anElement instanceof Method))
/* 176 */           declaringClass = ((Method)anElement).getDeclaringClass();
/* 177 */         else if ((anElement instanceof Class)) {
/* 178 */           declaringClass = (Class)anElement;
/*     */         }
/* 180 */         handlerChain = declaringClass.getPackage().getName().replace('.', '/') + "/" + handlerChain;
/*     */       }
/*     */ 
/* 183 */       serviceRef.setHandlerChain(handlerChain);
/*     */     }
/*     */ 
/* 187 */     if (null == serviceRef.getServiceQName())
/*     */     {
/*     */       try
/*     */       {
/* 191 */         Class serviceClass = loader.loadClass(serviceImplClass);
/* 192 */         if (serviceClass.getAnnotation(WebServiceClient.class) != null)
/*     */         {
/* 194 */           WebServiceClient clientDecl = (WebServiceClient)serviceClass.getAnnotation(WebServiceClient.class);
/* 195 */           serviceRef.setServiceQName(new QName(clientDecl.targetNamespace(), clientDecl.name()));
/*     */         }
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 200 */         WSFException.rethrow("Cannot extract service QName for target service", e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 206 */     Referenceable serviceReferenceable = buildServiceReferenceable(serviceImplClass, targetClassName, serviceRef);
/* 207 */     Util.bind(encCtx, encName, serviceReferenceable);
/*     */   }
/*     */ 
/*     */   protected Referenceable buildServiceReferenceable(String serviceImplClass, String targetClassName, UnifiedServiceRefMetaData serviceRef)
/*     */   {
/* 213 */     return new ServiceReferenceable(serviceImplClass, targetClassName, serviceRef);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.client.NativeServiceRefBinderJAXWS
 * JD-Core Version:    0.6.0
 */