/*     */ package org.jboss.ws.core.jaxws.client;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.StringReader;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.bind.Marshaller;
/*     */ import javax.xml.bind.Unmarshaller;
/*     */ import javax.xml.soap.MessageFactory;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import javax.xml.soap.SOAPFault;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.soap.SOAPPart;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.Transformer;
/*     */ import javax.xml.transform.TransformerFactory;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.transform.stream.StreamResult;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import javax.xml.ws.Service.Mode;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.soap.SOAPFaultException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.soap.SOAPBodyElementDoc;
/*     */ import org.jboss.ws.core.soap.SOAPBodyImpl;
/*     */ import org.jboss.ws.core.soap.SOAPContentElement;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.core.soap.XMLFragment;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ 
/*     */ public class DispatchSOAPBinding extends DispatchBinding
/*     */ {
/*  65 */   private final Logger log = Logger.getLogger(DispatchSOAPBinding.class);
/*     */   private JAXBContext jaxbContext;
/*     */   private Class type;
/*     */   private Service.Mode mode;
/*     */ 
/*     */   public DispatchSOAPBinding(Service.Mode mode, Class type, JAXBContext jaxbContext)
/*     */   {
/*  73 */     this.mode = mode;
/*  74 */     this.type = type;
/*  75 */     this.jaxbContext = jaxbContext;
/*     */   }
/*     */ 
/*     */   public MessageAbstraction getRequestMessage(Object obj)
/*     */   {
/*  80 */     SOAPMessageImpl reqMsg = null;
/*     */     try
/*     */     {
/*  83 */       MessageFactory factory = MessageFactory.newInstance();
/*  84 */       if (SOAPMessage.class.isAssignableFrom(this.type))
/*     */       {
/*  86 */         reqMsg = (SOAPMessageImpl)obj;
/*     */       }
/*  88 */       else if (Source.class.isAssignableFrom(this.type))
/*     */       {
/*  90 */         Source source = (Source)obj;
/*  91 */         if (this.mode == Service.Mode.PAYLOAD)
/*     */         {
/*  93 */           reqMsg = (SOAPMessageImpl)factory.createMessage();
/*  94 */           SOAPBodyImpl soapBody = (SOAPBodyImpl)reqMsg.getSOAPBody();
/*  95 */           SOAPContentElement bodyElement = new SOAPBodyElementDoc(SOAPBodyElementDoc.GENERIC_PARAM_NAME);
/*  96 */           bodyElement = (SOAPContentElement)soapBody.addChildElement(bodyElement);
/*  97 */           XMLFragment xmlFragment = new XMLFragment(source);
/*  98 */           bodyElement.setXMLFragment(xmlFragment);
/*     */ 
/* 101 */           if (this.validateDispatch)
/*     */           {
/* 104 */             xmlFragment.toElement();
/*     */           }
/*     */         }
/*     */ 
/* 108 */         if (this.mode == Service.Mode.MESSAGE)
/*     */         {
/* 110 */           TransformerFactory tf = TransformerFactory.newInstance();
/* 111 */           ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
/* 112 */           tf.newTransformer().transform(source, new StreamResult(baos));
/* 113 */           reqMsg = (SOAPMessageImpl)factory.createMessage(null, new ByteArrayInputStream(baos.toByteArray()));
/*     */         }
/*     */       }
/* 116 */       else if (this.jaxbContext != null)
/*     */       {
/* 118 */         Marshaller marshaller = this.jaxbContext.createMarshaller();
/* 119 */         marshaller.setProperty("jaxb.fragment", Boolean.valueOf(true));
/* 120 */         ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
/* 121 */         marshaller.marshal(obj, baos);
/*     */ 
/* 123 */         reqMsg = (SOAPMessageImpl)factory.createMessage();
/* 124 */         SOAPBodyImpl soapBody = (SOAPBodyImpl)reqMsg.getSOAPBody();
/* 125 */         SOAPContentElement bodyElement = new SOAPBodyElementDoc(SOAPBodyElementDoc.GENERIC_PARAM_NAME);
/* 126 */         bodyElement = (SOAPContentElement)soapBody.addChildElement(bodyElement);
/* 127 */         StreamSource source = new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
/* 128 */         bodyElement.setXMLFragment(new XMLFragment(source));
/*     */       }
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 133 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 137 */       throw new WebServiceException("Cannot create request message", ex);
/*     */     }
/*     */ 
/* 140 */     if (reqMsg == null) {
/* 141 */       throw new WebServiceException("Cannot create request message for: " + obj);
/*     */     }
/* 143 */     return reqMsg;
/*     */   }
/*     */ 
/*     */   public Object getReturnObject(MessageAbstraction message)
/*     */   {
/* 148 */     SOAPMessage resMsg = (SOAPMessage)message;
/*     */ 
/* 150 */     Object retObj = null;
/*     */     try
/*     */     {
/* 153 */       if (SOAPMessage.class.isAssignableFrom(this.type))
/*     */       {
/* 155 */         retObj = resMsg;
/*     */       }
/* 157 */       else if (Source.class.isAssignableFrom(this.type))
/*     */       {
/* 159 */         if (this.mode == Service.Mode.PAYLOAD)
/*     */         {
/* 161 */           SOAPBodyImpl soapBody = (SOAPBodyImpl)resMsg.getSOAPBody();
/*     */ 
/* 163 */           SOAPFault soapFault = soapBody.getFault();
/* 164 */           if (soapFault != null) {
/* 165 */             throw new SOAPFaultException(soapFault);
/*     */           }
/* 167 */           SOAPElement soapElement = soapBody.getBodyElement();
/* 168 */           retObj = new DOMSource(soapElement);
/*     */         }
/* 170 */         if (this.mode == Service.Mode.MESSAGE)
/*     */         {
/* 172 */           SOAPEnvelope soapEnvelope = resMsg.getSOAPPart().getEnvelope();
/* 173 */           String xmlMessage = DOMWriter.printNode(soapEnvelope, false);
/* 174 */           retObj = new StreamSource(new StringReader(xmlMessage));
/*     */         }
/*     */       }
/* 177 */       else if (this.jaxbContext != null)
/*     */       {
/* 179 */         SOAPBodyImpl soapBody = (SOAPBodyImpl)resMsg.getSOAPBody();
/* 180 */         SOAPElement soapElement = soapBody.getBodyElement();
/*     */ 
/* 182 */         this.log.debug("JAXB unmarshal: " + DOMWriter.printNode(soapElement, false));
/* 183 */         Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
/* 184 */         retObj = unmarshaller.unmarshal(soapElement);
/*     */       }
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 189 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 193 */       throw new WebServiceException("Cannot process response message", ex);
/*     */     }
/* 195 */     return retObj;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.client.DispatchSOAPBinding
 * JD-Core Version:    0.6.0
 */