/*     */ package org.jboss.ws.core.jaxws.client;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.UUID;
/*     */ import java.util.concurrent.ExecutorService;
/*     */ import java.util.concurrent.Future;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.ws.AsyncHandler;
/*     */ import javax.xml.ws.BindingProvider;
/*     */ import javax.xml.ws.Response;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.soap.SOAPFaultException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.StubExt;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class ClientProxy
/*     */   implements InvocationHandler
/*     */ {
/*  64 */   private static final Logger log = Logger.getLogger(ClientProxy.class);
/*     */   private ClientImpl client;
/*     */   private List stubMethods;
/*     */   private List objectMethods;
/*     */   private ExecutorService executor;
/*  77 */   private static final Set<String> standardProperties = new HashSet();
/*     */ 
/*     */   public ClientProxy(ExecutorService executor, ClientImpl client)
/*     */   {
/*  90 */     this.client = client;
/*  91 */     this.executor = executor;
/*  92 */     this.stubMethods = new ArrayList(Arrays.asList(BindingProvider.class.getMethods()));
/*  93 */     this.stubMethods.addAll(Arrays.asList(StubExt.class.getMethods()));
/*  94 */     this.objectMethods = Arrays.asList(Object.class.getMethods());
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 102 */     String methodName = method.getName();
/* 103 */     if (this.stubMethods.contains(method))
/*     */     {
/* 105 */       Method stubMethod = ClientImpl.class.getMethod(methodName, method.getParameterTypes());
/* 106 */       return stubMethod.invoke(this.client, args);
/*     */     }
/*     */ 
/* 110 */     if (this.objectMethods.contains(method))
/*     */     {
/* 112 */       Method objMethod = ClientImpl.class.getMethod(methodName, method.getParameterTypes());
/* 113 */       return objMethod.invoke(this.client, args);
/*     */     }
/*     */ 
/* 119 */     EndpointMetaData epMetaData = this.client.getEndpointMetaData();
/* 120 */     OperationMetaData opMetaData = epMetaData.getOperation(method);
/* 121 */     if (opMetaData == null) {
/* 122 */       throw new WSException("Cannot obtain operation meta data for: " + methodName);
/*     */     }
/* 124 */     QName opName = opMetaData.getQName();
/*     */ 
/* 126 */     if (log.isTraceEnabled()) {
/* 127 */       log.trace("Invoke method: " + method + opMetaData);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 132 */       Class retType = method.getReturnType();
/* 133 */       boolean isAsync = methodName.endsWith("Async");
/*     */       Object retObj;
/*     */       Object retObj;
/* 136 */       if ((isAsync) && (JavaUtils.isAssignableFrom(Response.class, retType)))
/*     */       {
/* 138 */         retObj = invokeAsync(opName, args, retType);
/*     */       }
/*     */       else
/*     */       {
/*     */         Object retObj;
/* 141 */         if ((isAsync) && (JavaUtils.isAssignableFrom(Future.class, retType)) && (args.length > 1))
/*     */         {
/* 143 */           Object handler = args[(args.length - 1)];
/* 144 */           retObj = invokeAsync(opName, args, retType, (AsyncHandler)handler);
/*     */         }
/*     */         else
/*     */         {
/* 149 */           Map resContext = this.client.getBindingProvider().getResponseContext();
/* 150 */           retObj = invoke(opName, args, retType, resContext);
/*     */         }
/*     */       }
/* 152 */       return retObj;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 156 */       handleException(ex);
/* 157 */     }return null;
/*     */   }
/*     */ 
/*     */   private Object invoke(QName opName, Object[] args, Class retType, Map<String, Object> resContext)
/*     */     throws RemoteException
/*     */   {
/* 164 */     Object retObj = this.client.invoke(opName, args, resContext);
/* 165 */     if (retObj != null)
/*     */     {
/* 167 */       if (retType == null) {
/* 168 */         throw new WSException("Return value not supported by: " + opName);
/*     */       }
/* 170 */       if (JavaUtils.isPrimitive(retType))
/* 171 */         retObj = JavaUtils.getPrimitiveValueArray(retObj);
/*     */     }
/* 173 */     return retObj;
/*     */   }
/*     */ 
/*     */   private Response invokeAsync(QName opName, Object[] args, Class retType)
/*     */   {
/* 178 */     ResponseImpl response = new ResponseImpl();
/* 179 */     Runnable task = new AsyncRunnable(response, null, opName, args, retType);
/*     */ 
/* 181 */     if (log.isDebugEnabled()) log.debug("Schedule task " + ((AsyncRunnable)task).getTaskID().toString());
/*     */ 
/* 183 */     Future future = this.executor.submit(task);
/* 184 */     response.setFuture(future);
/* 185 */     return response;
/*     */   }
/*     */ 
/*     */   private Future invokeAsync(QName opName, Object[] args, Class retType, AsyncHandler handler)
/*     */   {
/* 190 */     ResponseImpl response = new ResponseImpl();
/* 191 */     Runnable task = new AsyncRunnable(response, handler, opName, args, retType);
/* 192 */     Future future = this.executor.submit(task);
/* 193 */     response.setFuture(future);
/* 194 */     return response;
/*     */   }
/*     */ 
/*     */   private void handleException(Exception ex)
/*     */     throws Throwable
/*     */   {
/* 205 */     if ((ex instanceof SOAPFaultException))
/*     */     {
/* 208 */       Throwable cause = ex.getCause();
/* 209 */       if ((cause instanceof Exception))
/*     */       {
/* 212 */         if ((cause instanceof WebServiceException)) {
/* 213 */           throw ((WebServiceException)cause);
/*     */         }
/*     */ 
/* 216 */         if ((cause instanceof SOAPException)) {
/* 217 */           throw ((SOAPFaultException)ex);
/*     */         }
/*     */ 
/* 220 */         if ((cause instanceof RuntimeException)) {
/* 221 */           throw ((SOAPFaultException)ex);
/*     */         }
/*     */ 
/* 224 */         throw ((Exception)cause);
/*     */       }
/*     */     }
/* 227 */     throw ex;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  80 */     standardProperties.add("javax.xml.ws.service.endpoint.address");
/*  81 */     standardProperties.add("javax.xml.ws.session.maintain");
/*  82 */     standardProperties.add("javax.xml.ws.security.auth.username");
/*  83 */     standardProperties.add("javax.xml.ws.security.auth.password");
/*  84 */     standardProperties.add("javax.xml.ws.soap.http.soapaction.use");
/*  85 */     standardProperties.add("javax.xml.ws.soap.http.soapaction.uri");
/*     */   }
/*     */ 
/*     */   class AsyncRunnable
/*     */     implements Runnable
/*     */   {
/*     */     private ResponseImpl response;
/*     */     private AsyncHandler handler;
/*     */     private QName opName;
/*     */     private Object[] args;
/*     */     private Class retType;
/*     */     private UUID uuid;
/*     */ 
/*     */     public AsyncRunnable(ResponseImpl response, AsyncHandler handler, QName opName, Object[] args, Class retType)
/*     */     {
/* 241 */       this.response = response;
/* 242 */       this.handler = handler;
/* 243 */       this.opName = opName;
/* 244 */       this.args = args;
/* 245 */       this.retType = retType;
/* 246 */       this.uuid = UUID.randomUUID();
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 253 */         Map resContext = this.response.getContext();
/* 254 */         Object result = ClientProxy.this.invoke(this.opName, this.args, this.retType, resContext);
/*     */ 
/* 256 */         if (ClientProxy.log.isDebugEnabled()) ClientProxy.log.debug("Finished task " + getTaskID().toString() + ": " + result);
/*     */ 
/* 258 */         this.response.set(result);
/*     */ 
/* 261 */         if (this.handler != null)
/* 262 */           this.handler.handleResponse(this.response);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 266 */         handleAsynInvokeException(ex);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void handleAsynInvokeException(Exception ex)
/*     */     {
/* 276 */       String msg = "Cannot dispatch message";
/* 277 */       ClientProxy.log.error(msg, ex);
/*     */       WebServiceException wsex;
/*     */       WebServiceException wsex;
/* 280 */       if ((ex instanceof WebServiceException))
/*     */       {
/* 282 */         wsex = (WebServiceException)ex;
/*     */       }
/*     */       else
/*     */       {
/* 286 */         wsex = new WebServiceException(msg, ex);
/*     */       }
/* 288 */       this.response.setException(wsex);
/*     */     }
/*     */ 
/*     */     public UUID getTaskID() {
/* 292 */       return this.uuid;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.client.ClientProxy
 * JD-Core Version:    0.6.0
 */