/*     */ package org.jboss.ws.core.jaxws.binding;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.handler.Handler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonBinding;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.EndpointInvocation;
/*     */ import org.jboss.ws.core.HeaderSource;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.jaxws.SOAPFaultHelperJAXWS;
/*     */ import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.MessageFactoryImpl;
/*     */ import org.jboss.ws.core.soap.SOAPBodyElementDoc;
/*     */ import org.jboss.ws.core.soap.SOAPBodyImpl;
/*     */ import org.jboss.ws.core.soap.SOAPContentElement;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.core.soap.UnboundHeader;
/*     */ import org.jboss.ws.core.soap.XMLFragment;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class PayloadBinding
/*     */   implements CommonBinding, BindingExt
/*     */ {
/*  68 */   private static final Logger log = Logger.getLogger(PayloadBinding.class);
/*     */ 
/*  71 */   private BindingImpl delegate = new BindingImpl();
/*     */ 
/*     */   public MessageAbstraction bindRequestMessage(OperationMetaData opMetaData, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders)
/*     */     throws BindingException
/*     */   {
/*  77 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public EndpointInvocation unbindRequestMessage(OperationMetaData opMetaData, MessageAbstraction payload)
/*     */     throws BindingException
/*     */   {
/*  83 */     log.debug("unbindRequestMessage: " + opMetaData.getQName());
/*     */     try
/*     */     {
/*  87 */       EndpointInvocation epInv = new EndpointInvocation(opMetaData);
/*     */ 
/*  89 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/*  90 */       if (msgContext == null) {
/*  91 */         throw new WSException("MessageContext not available");
/*     */       }
/*  93 */       ParameterMetaData paramMetaData = (ParameterMetaData)opMetaData.getParameters().get(0);
/*  94 */       QName xmlName = paramMetaData.getXmlName();
/*     */ 
/*  96 */       SOAPMessage reqMessage = (SOAPMessage)payload;
/*  97 */       SOAPBodyImpl body = (SOAPBodyImpl)reqMessage.getSOAPBody();
/*     */ 
/*  99 */       SOAPContentElement bodyElement = (SOAPContentElement)body.getBodyElement();
/* 100 */       Source source = bodyElement.getXMLFragment().getSource();
/* 101 */       if (source == null) {
/* 102 */         throw new IllegalStateException("Payload cannot be null");
/*     */       }
/* 104 */       epInv.setRequestParamValue(xmlName, source);
/*     */ 
/* 106 */       return epInv;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 110 */       handleException(e);
/* 111 */     }return null;
/*     */   }
/*     */ 
/*     */   public MessageAbstraction bindResponseMessage(OperationMetaData opMetaData, EndpointInvocation epInv)
/*     */     throws BindingException
/*     */   {
/* 118 */     log.debug("bindResponseMessage: " + opMetaData.getQName());
/*     */     try
/*     */     {
/* 122 */       SOAPMessageContextJAXWS msgContext = (SOAPMessageContextJAXWS)MessageContextAssociation.peekMessageContext();
/* 123 */       if (msgContext == null) {
/* 124 */         throw new WSException("MessageContext not available");
/*     */       }
/*     */ 
/* 127 */       MessageFactoryImpl factory = new MessageFactoryImpl();
/* 128 */       factory.setEnvNamespace("http://schemas.xmlsoap.org/soap/envelope/");
/* 129 */       SOAPMessageImpl resMessage = (SOAPMessageImpl)factory.createMessage();
/* 130 */       msgContext.setSOAPMessage(resMessage);
/*     */ 
/* 132 */       ParameterMetaData retParameter = opMetaData.getReturnParameter();
/* 133 */       QName xmlName = retParameter.getXmlName();
/* 134 */       SOAPBodyImpl soapBody = (SOAPBodyImpl)resMessage.getSOAPBody();
/* 135 */       SOAPContentElement bodyElement = new SOAPBodyElementDoc(xmlName);
/* 136 */       bodyElement = (SOAPContentElement)soapBody.addChildElement(bodyElement);
/*     */ 
/* 138 */       Source payload = (Source)epInv.getReturnValue();
/* 139 */       bodyElement.setXMLFragment(new XMLFragment(payload));
/*     */ 
/* 141 */       return resMessage;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 145 */       handleException(e);
/* 146 */     }return null;
/*     */   }
/*     */ 
/*     */   public void unbindResponseMessage(OperationMetaData opMetaData, MessageAbstraction resMessage, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders)
/*     */     throws BindingException
/*     */   {
/* 154 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public MessageAbstraction bindFaultMessage(Exception ex)
/*     */   {
/* 159 */     SOAPMessageImpl faultMessage = SOAPFaultHelperJAXWS.exceptionToFaultMessage(ex);
/* 160 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 161 */     if (msgContext != null)
/*     */     {
/* 163 */       msgContext.setSOAPMessage(faultMessage);
/*     */     }
/*     */     else
/*     */     {
/* 167 */       log.warn("Cannot set fault message in message context");
/*     */     }
/* 169 */     return faultMessage;
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain()
/*     */   {
/* 174 */     return this.delegate.getHandlerChain();
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain(UnifiedHandlerMetaData.HandlerType handlerType)
/*     */   {
/* 179 */     return this.delegate.getHandlerChain(handlerType);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(List<Handler> handlerChain)
/*     */   {
/* 184 */     this.delegate.setHandlerChain(handlerChain);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(List<Handler> handlerChain, UnifiedHandlerMetaData.HandlerType handlerType)
/*     */   {
/* 189 */     this.delegate.setHandlerChain(handlerChain, handlerType);
/*     */   }
/*     */ 
/*     */   private void handleException(Exception ex) throws BindingException
/*     */   {
/* 194 */     if ((ex instanceof RuntimeException)) {
/* 195 */       throw ((RuntimeException)ex);
/*     */     }
/* 197 */     if ((ex instanceof BindingException)) {
/* 198 */       throw ((BindingException)ex);
/*     */     }
/* 200 */     throw new BindingException(ex);
/*     */   }
/*     */ 
/*     */   public String getBindingID()
/*     */   {
/* 205 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setHeaderSource(HeaderSource source)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.binding.PayloadBinding
 * JD-Core Version:    0.6.0
 */