/*     */ package org.jboss.ws.core.jaxws.binding;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.handler.Handler;
/*     */ import javax.xml.ws.http.HTTPBinding;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonBinding;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.EndpointInvocation;
/*     */ import org.jboss.ws.core.HTTPMessageImpl;
/*     */ import org.jboss.ws.core.HeaderSource;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.UnboundHeader;
/*     */ import org.jboss.ws.core.soap.XMLFragment;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class HTTPBindingJAXWS
/*     */   implements CommonBinding, BindingExt, HTTPBinding
/*     */ {
/*  59 */   private static final Logger log = Logger.getLogger(HTTPBindingJAXWS.class);
/*     */ 
/*  61 */   private BindingImpl delegate = new BindingImpl();
/*     */ 
/*     */   public MessageAbstraction bindRequestMessage(OperationMetaData opMetaData, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders)
/*     */     throws BindingException
/*     */   {
/*  66 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public EndpointInvocation unbindRequestMessage(OperationMetaData opMetaData, MessageAbstraction reqMessage) throws BindingException
/*     */   {
/*  71 */     log.debug("unbindRequestMessage: " + opMetaData.getQName());
/*     */     try
/*     */     {
/*  75 */       EndpointInvocation epInv = new EndpointInvocation(opMetaData);
/*     */ 
/*  77 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/*  78 */       if (msgContext == null) {
/*  79 */         throw new WSException("MessageContext not available");
/*     */       }
/*  81 */       ParameterMetaData paramMetaData = (ParameterMetaData)opMetaData.getParameters().get(0);
/*  82 */       QName xmlName = paramMetaData.getXmlName();
/*     */ 
/*  84 */       HTTPMessageImpl httpMessage = (HTTPMessageImpl)reqMessage;
/*  85 */       Source source = httpMessage.getXmlFragment().getSource();
/*     */ 
/*  87 */       epInv.setRequestParamValue(xmlName, source);
/*     */ 
/*  89 */       return epInv;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  93 */       handleException(e);
/*  94 */     }return null;
/*     */   }
/*     */ 
/*     */   public MessageAbstraction bindResponseMessage(OperationMetaData opMetaData, EndpointInvocation epInv)
/*     */     throws BindingException
/*     */   {
/* 100 */     log.debug("bindResponseMessage: " + opMetaData.getQName());
/*     */     try
/*     */     {
/* 103 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 104 */       if (msgContext == null) {
/* 105 */         throw new WSException("MessageContext not available");
/*     */       }
/*     */ 
/* 108 */       Source source = (Source)epInv.getReturnValue();
/* 109 */       HTTPMessageImpl resMessage = new HTTPMessageImpl(source);
/* 110 */       msgContext.setMessageAbstraction(resMessage);
/*     */ 
/* 112 */       return resMessage;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 116 */       handleException(e);
/* 117 */     }return null;
/*     */   }
/*     */ 
/*     */   public void unbindResponseMessage(OperationMetaData opMetaData, MessageAbstraction resMessage, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders)
/*     */     throws BindingException
/*     */   {
/* 124 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public MessageAbstraction bindFaultMessage(Exception ex)
/*     */   {
/* 129 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain()
/*     */   {
/* 134 */     return this.delegate.getHandlerChain();
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain(UnifiedHandlerMetaData.HandlerType handlerType)
/*     */   {
/* 139 */     return this.delegate.getHandlerChain(handlerType);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(List<Handler> handlerChain)
/*     */   {
/* 144 */     this.delegate.setHandlerChain(handlerChain);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(List<Handler> handlerChain, UnifiedHandlerMetaData.HandlerType handlerType)
/*     */   {
/* 149 */     this.delegate.setHandlerChain(handlerChain, handlerType);
/*     */   }
/*     */ 
/*     */   public String getBindingID()
/*     */   {
/* 154 */     return "http://www.w3.org/2004/08/wsdl/http";
/*     */   }
/*     */ 
/*     */   public void setHeaderSource(HeaderSource source)
/*     */   {
/*     */   }
/*     */ 
/*     */   private void handleException(Exception ex)
/*     */     throws BindingException
/*     */   {
/* 164 */     if ((ex instanceof RuntimeException)) {
/* 165 */       throw ((RuntimeException)ex);
/*     */     }
/* 167 */     if ((ex instanceof BindingException)) {
/* 168 */       throw ((BindingException)ex);
/*     */     }
/* 170 */     throw new BindingException(ex);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.binding.HTTPBindingJAXWS
 * JD-Core Version:    0.6.0
 */