/*     */ package org.jboss.ws.core.jaxws;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.encoding.TypeMapping;
/*     */ import javax.xml.soap.Detail;
/*     */ import javax.xml.soap.DetailEntry;
/*     */ import javax.xml.soap.MessageFactory;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFault;
/*     */ import javax.xml.transform.Result;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.soap.SOAPFaultException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.CommonSOAPFaultException;
/*     */ import org.jboss.ws.core.binding.AbstractDeserializerFactory;
/*     */ import org.jboss.ws.core.binding.AbstractSerializerFactory;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.DeserializerSupport;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.binding.SerializerSupport;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.jaxrpc.SOAPFaultHelperJAXRPC;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.NameImpl;
/*     */ import org.jboss.ws.core.soap.SOAPFactoryImpl;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.core.soap.XMLFragment;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class SOAPFaultHelperJAXWS
/*     */ {
/*  64 */   private static Logger log = Logger.getLogger(SOAPFaultHelperJAXWS.class);
/*     */ 
/*     */   public static SOAPFaultException getSOAPFaultException(SOAPFault soapFault)
/*     */   {
/*  69 */     if (soapFault == null) {
/*  70 */       throw new IllegalArgumentException("SOAPFault cannot be null");
/*     */     }
/*  72 */     SOAPFaultException faultEx = new SOAPFaultException(soapFault);
/*     */ 
/*  74 */     Detail detail = soapFault.getDetail();
/*  75 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/*  76 */     if ((detail != null) && (msgContext != null))
/*     */     {
/*  78 */       log.debug("Processing detail");
/*  79 */       SerializationContext serContext = msgContext.getSerializationContext();
/*  80 */       TypeMapping typeMapping = serContext.getTypeMapping();
/*     */ 
/*  82 */       Iterator it = detail.getDetailEntries();
/*  83 */       while (it.hasNext())
/*     */       {
/*  85 */         DetailEntry deElement = (DetailEntry)it.next();
/*  86 */         QName xmlName = deElement.getElementQName();
/*  87 */         log.debug("Processing detail entry: " + xmlName);
/*     */ 
/*  89 */         OperationMetaData opMetaData = msgContext.getOperationMetaData();
/*  90 */         FaultMetaData faultMetaData = opMetaData.getFault(xmlName);
/*  91 */         if (faultMetaData != null)
/*     */         {
/*  93 */           log.debug("Deserialize fault: " + faultMetaData);
/*  94 */           QName xmlType = faultMetaData.getXmlType();
/*  95 */           Class faultBeanClass = faultMetaData.getFaultBean();
/*     */ 
/*  98 */           AbstractDeserializerFactory desFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(faultBeanClass, xmlType);
/*  99 */           if (desFactory == null) {
/* 100 */             throw new WebServiceException("Cannot obtain deserializer factory: xmlType=" + xmlType + ", javaType=" + faultBeanClass);
/*     */           }
/*     */ 
/* 104 */           String prefix = deElement.getPrefix();
/* 105 */           if ((prefix != null) && (prefix.length() > 0))
/*     */           {
/* 107 */             String nsURI = deElement.getNamespaceURI();
/* 108 */             if ((nsURI.length() > 0) && (deElement.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix).length() == 0))
/*     */             {
/*     */               try
/*     */               {
/* 112 */                 deElement.addNamespaceDeclaration(prefix, nsURI);
/*     */               }
/*     */               catch (SOAPException e)
/*     */               {
/* 116 */                 log.warn("Declaration of detail entry namespace failed", e);
/*     */               }
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 124 */             Class[] types = (Class[])opMetaData.getEndpointMetaData().getRegisteredTypes().toArray(new Class[0]);
/* 125 */             serContext.setProperty("org.jboss.ws.jaxb.context.types", types);
/*     */ 
/* 127 */             Source source = new DOMSource(deElement);
/* 128 */             DeserializerSupport des = desFactory.getDeserializer();
/* 129 */             Object faultBean = des.deserialize(xmlName, xmlType, source, serContext);
/*     */ 
/* 131 */             Exception serviceEx = faultMetaData.toServiceException(faultBean, soapFault.getFaultString());
/* 132 */             faultEx.initCause(serviceEx);
/*     */           }
/*     */           catch (BindingException e)
/*     */           {
/* 136 */             throw new WebServiceException(e);
/*     */           }
/*     */         } else {
/* 139 */           log.debug("Cannot find fault meta data for: " + xmlName);
/*     */         }
/*     */       }
/*     */     }
/* 143 */     return faultEx;
/*     */   }
/*     */ 
/*     */   public static SOAPMessageImpl exceptionToFaultMessage(Exception reqEx)
/*     */   {
/* 149 */     log.error("SOAP request exception", reqEx);
/*     */     try
/*     */     {
/* 154 */       Throwable cause = reqEx.getCause();
/*     */       SOAPMessageImpl faultMessage;
/*     */       SOAPMessageImpl faultMessage;
/* 155 */       if ((reqEx instanceof SOAPFaultException))
/*     */       {
/* 157 */         faultMessage = toSOAPMessage((SOAPFaultException)reqEx);
/*     */       }
/*     */       else
/*     */       {
/*     */         SOAPMessageImpl faultMessage;
/* 164 */         if ((cause != null) && ((cause instanceof SOAPFaultException)))
/*     */         {
/* 166 */           faultMessage = toSOAPMessage((SOAPFaultException)cause);
/*     */         }
/*     */         else
/*     */         {
/*     */           SOAPMessageImpl faultMessage;
/* 168 */           if ((reqEx instanceof CommonSOAPFaultException))
/*     */           {
/* 170 */             faultMessage = SOAPFaultHelperJAXRPC.exceptionToFaultMessage(reqEx);
/*     */           }
/*     */           else
/*     */           {
/* 174 */             faultMessage = toSOAPMessage(reqEx);
/*     */           }
/*     */         }
/*     */       }
/* 177 */       return faultMessage;
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 181 */       log.error("Error creating SOAPFault message", ex);
/* 182 */     }throw new WebServiceException("Cannot create SOAPFault message for: " + reqEx);
/*     */   }
/*     */ 
/*     */   private static SOAPMessageImpl toSOAPMessage(SOAPFaultException faultEx)
/*     */     throws SOAPException
/*     */   {
/* 188 */     MessageFactory factory = MessageFactory.newInstance();
/* 189 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)factory.createMessage();
/*     */ 
/* 191 */     SOAPBody soapBody = soapMessage.getSOAPBody();
/* 192 */     populateSOAPFault(soapBody, faultEx);
/*     */ 
/* 197 */     Detail detail = faultEx.getFault().getDetail();
/* 198 */     if (detail != null) {
/* 199 */       soapBody.getFault().addChildElement(detail);
/*     */     }
/* 201 */     return soapMessage;
/*     */   }
/*     */ 
/*     */   private static void populateSOAPFault(SOAPBody soapBody, SOAPFaultException faultEx) throws SOAPException
/*     */   {
/* 206 */     SOAPFault sourceFault = faultEx.getFault();
/*     */ 
/* 214 */     Name faultCode = sourceFault.getFaultCodeAsName();
/* 215 */     if (faultCode != null)
/*     */     {
/* 217 */       faultCode = new NameImpl(faultCode.getLocalName(), "codeNS", faultCode.getURI());
/*     */     }
/*     */     else
/*     */     {
/* 221 */       faultCode = getFallbackFaultCode();
/*     */     }
/*     */ 
/* 228 */     String faultString = sourceFault.getFaultString();
/* 229 */     if (faultString == null) {
/* 230 */       faultString = getFallbackFaultString(faultEx);
/*     */     }
/* 232 */     SOAPFault targetFault = soapBody.addFault(faultCode, faultString);
/*     */ 
/* 237 */     String faultActor = sourceFault.getFaultActor();
/* 238 */     if (faultActor != null)
/* 239 */       targetFault.setFaultActor(faultActor);
/*     */   }
/*     */ 
/*     */   private static SOAPMessageImpl toSOAPMessage(Exception ex) throws SOAPException
/*     */   {
/* 244 */     MessageFactory factory = MessageFactory.newInstance();
/* 245 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)factory.createMessage();
/*     */ 
/* 247 */     SOAPBody soapBody = soapMessage.getSOAPBody();
/*     */ 
/* 249 */     SOAPFault soapFault = soapBody.addFault(getFallbackFaultCode(), getFallbackFaultString(ex));
/*     */ 
/* 251 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 252 */     SerializationContext serContext = msgContext.getSerializationContext();
/*     */ 
/* 254 */     NameImpl faultCode = (NameImpl)soapFault.getFaultCodeAsName();
/* 255 */     if (faultCode.getURI().length() > 0) {
/* 256 */       serContext.getNamespaceRegistry().registerQName(faultCode.toQName());
/*     */     }
/* 258 */     OperationMetaData opMetaData = msgContext.getOperationMetaData();
/* 259 */     Class exClass = ex.getClass();
/* 260 */     if ((opMetaData != null) && (opMetaData.getFaultMetaData(exClass) != null))
/*     */     {
/* 262 */       FaultMetaData faultMetaData = opMetaData.getFaultMetaData(exClass);
/* 263 */       Object faultBean = faultMetaData.toFaultBean(ex);
/*     */ 
/* 265 */       Detail detail = soapFault.addDetail();
/* 266 */       SOAPElement detailEntry = toDetailEntry(faultBean, serContext, faultMetaData);
/* 267 */       detail.addChildElement(detailEntry);
/*     */     } else {
/* 269 */       log.debug("Cannot obtain fault meta data for: " + exClass);
/*     */     }
/* 271 */     return soapMessage;
/*     */   }
/*     */ 
/*     */   private static Name getFallbackFaultCode()
/*     */   {
/* 279 */     return new NameImpl(Constants.SOAP11_FAULT_CODE_SERVER);
/*     */   }
/*     */ 
/*     */   private static String getFallbackFaultString(Exception ex)
/*     */   {
/* 288 */     String faultString = ex.getMessage();
/*     */ 
/* 290 */     if (faultString == null) {
/* 291 */       faultString = ex.toString();
/*     */     }
/* 293 */     return faultString;
/*     */   }
/*     */ 
/*     */   private static SOAPElement toDetailEntry(Object faultObject, SerializationContext serContext, FaultMetaData faultMetaData) throws SOAPException
/*     */   {
/* 298 */     QName xmlName = faultMetaData.getXmlName();
/* 299 */     xmlName = serContext.getNamespaceRegistry().registerQName(xmlName);
/*     */ 
/* 302 */     QName xmlType = faultMetaData.getXmlType();
/* 303 */     Class javaType = faultMetaData.getFaultBean();
/* 304 */     serContext.setJavaType(javaType);
/* 305 */     AbstractSerializerFactory serFactory = (AbstractSerializerFactory)serContext.getTypeMapping().getSerializer(javaType, xmlType);
/* 306 */     if (serFactory == null) {
/* 307 */       throw new WebServiceException("Cannot obtain serializer factory: xmlType=" + xmlType + ", javaType=" + javaType);
/*     */     }
/*     */     try
/*     */     {
/* 311 */       SerializerSupport ser = serFactory.getSerializer();
/* 312 */       Result result = ser.serialize(xmlName, xmlType, faultObject, serContext, null);
/* 313 */       XMLFragment xmlFragment = new XMLFragment(result);
/* 314 */       String xmlStr = xmlFragment.toXMLString();
/* 315 */       log.debug("Fault detail: " + xmlStr);
/*     */ 
/* 317 */       Element domElement = xmlFragment.toElement();
/* 318 */       SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
/* 319 */       return soapFactory.createElement(domElement);
/*     */     }
/*     */     catch (BindingException e) {
/*     */     }
/* 323 */     throw new WebServiceException(e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.SOAPFaultHelperJAXWS
 * JD-Core Version:    0.6.0
 */