/*     */ package org.jboss.ws.core.jaxws;
/*     */ 
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.bind.JAXBElement;
/*     */ import javax.xml.bind.Unmarshaller;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.ComplexTypeDeserializer;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.extensions.xop.jaxws.AttachmentUnmarshallerImpl;
/*     */ import org.jboss.wsf.spi.binding.BindingCustomization;
/*     */ 
/*     */ public class JAXBDeserializer extends ComplexTypeDeserializer
/*     */ {
/*  54 */   private static final Logger log = Logger.getLogger(JAXBDeserializer.class);
/*     */ 
/*     */   public JAXBDeserializer() throws BindingException
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException
/*     */   {
/*  62 */     if (log.isDebugEnabled()) log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*     */ 
/*  64 */     Object value = null;
/*     */     try
/*     */     {
/*  67 */       Class[] javaTypes = (Class[])(Class[])serContext.getProperty("org.jboss.ws.jaxb.context.types");
/*     */ 
/*  69 */       TypeMappingImpl typeMapping = serContext.getTypeMapping();
/*  70 */       Class javaType = typeMapping.getJavaType(xmlType);
/*     */ 
/*  72 */       JAXBContext jaxbContext = getJAXBContext(javaTypes);
/*     */ 
/*  74 */       Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
/*  75 */       unmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerImpl());
/*     */ 
/*  77 */       JAXBElement jbe = unmarshaller.unmarshal(xmlFragment, javaType);
/*  78 */       value = jbe.getValue();
/*     */ 
/*  80 */       if (log.isDebugEnabled()) log.debug("deserialized: " + (value != null ? value.getClass().getName() : null));
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  84 */       handleUnmarshallException(ex);
/*     */     }
/*  86 */     return value;
/*     */   }
/*     */ 
/*     */   private JAXBContext getJAXBContext(Class[] types)
/*     */   {
/*  97 */     JAXBContextCache cache = JAXBContextCache.getContextCache();
/*  98 */     JAXBContext context = cache.get(types);
/*  99 */     if (null == context)
/*     */     {
/* 101 */       BindingCustomization bindingCustomization = getBindingCustomization();
/* 102 */       context = JAXBContextFactory.newInstance().createContext(types, bindingCustomization);
/* 103 */       cache.add(types, context);
/*     */     }
/* 105 */     return context;
/*     */   }
/*     */ 
/*     */   private void handleUnmarshallException(Exception ex)
/*     */   {
/* 113 */     if ((ex instanceof WebServiceException)) {
/* 114 */       throw ((WebServiceException)ex);
/*     */     }
/* 116 */     throw new WebServiceException(ex);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.JAXBDeserializer
 * JD-Core Version:    0.6.0
 */