/*    */ package org.jboss.ws.core.jaxws;
/*    */ 
/*    */ import java.util.Map;
/*    */ import java.util.concurrent.ConcurrentHashMap;
/*    */ import javax.xml.bind.JAXBContext;
/*    */ import org.jboss.ws.core.CommonMessageContext;
/*    */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*    */ import org.jboss.ws.core.utils.HashCodeUtil;
/*    */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*    */ 
/*    */ public class JAXBContextCache
/*    */ {
/* 43 */   private Map<Integer, JAXBContext> cache = new ConcurrentHashMap();
/*    */ 
/*    */   public JAXBContext get(Class[] clazzes)
/*    */   {
/* 47 */     Integer id = buildId(clazzes);
/* 48 */     return get(id);
/*    */   }
/*    */ 
/*    */   public void add(Class[] clazzes, JAXBContext context)
/*    */   {
/* 53 */     Integer id = buildId(clazzes);
/* 54 */     add(id, context);
/*    */   }
/*    */ 
/*    */   private JAXBContext get(Integer id)
/*    */   {
/* 59 */     return (JAXBContext)this.cache.get(id);
/*    */   }
/*    */ 
/*    */   private void add(Integer id, JAXBContext context)
/*    */   {
/* 64 */     this.cache.put(id, context);
/*    */   }
/*    */ 
/*    */   private static Integer buildId(Class[] classes)
/*    */   {
/* 69 */     int sum = 23;
/* 70 */     for (Class cls : classes)
/*    */     {
/* 72 */       sum = HashCodeUtil.hash(sum, cls.getName());
/*    */     }
/* 74 */     return Integer.valueOf(sum);
/*    */   }
/*    */ 
/*    */   public static JAXBContextCache getContextCache()
/*    */   {
/* 84 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 85 */     EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
/* 86 */     return epMetaData.getJaxbCache();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.JAXBContextCache
 * JD-Core Version:    0.6.0
 */