/*    */ package org.jboss.ws.core.jaxws;
/*    */ 
/*    */ import java.beans.Introspector;
/*    */ import java.lang.reflect.Method;
/*    */ import java.lang.reflect.Modifier;
/*    */ import java.util.HashSet;
/*    */ import java.util.Set;
/*    */ import java.util.SortedMap;
/*    */ import java.util.TreeMap;
/*    */ 
/*    */ public abstract class AbstractWrapperGenerator
/*    */   implements WrapperGenerator
/*    */ {
/* 54 */   private static Set<String> excludedGetters = new HashSet(4);
/*    */   protected ClassLoader loader;
/*    */ 
/*    */   public AbstractWrapperGenerator(ClassLoader loader)
/*    */   {
/* 44 */     this.loader = loader;
/*    */   }
/*    */ 
/*    */   public void reset(ClassLoader loader)
/*    */   {
/* 49 */     this.loader = loader;
/*    */   }
/*    */ 
/*    */   protected SortedMap<String, Class<?>> getExceptionProperties(Class<?> exception)
/*    */   {
/* 63 */     if (!Exception.class.isAssignableFrom(exception)) {
/* 64 */       throw new IllegalArgumentException("Not an exception");
/*    */     }
/* 66 */     TreeMap sortedGetters = new TreeMap();
/*    */ 
/* 68 */     for (Method method : exception.getMethods())
/*    */     {
/* 70 */       if (Modifier.isStatic(method.getModifiers())) {
/*    */         continue;
/*    */       }
/* 73 */       Class returnType = method.getReturnType();
/* 74 */       if (returnType == Void.TYPE) {
/*    */         continue;
/*    */       }
/* 77 */       String name = method.getName();
/* 78 */       if (excludedGetters.contains(name))
/*    */         continue;
/*    */       int offset;
/*    */       int offset;
/* 82 */       if (name.startsWith("get")) {
/* 83 */         offset = 3; } else {
/* 84 */         if (!name.startsWith("is")) continue;
/* 85 */         offset = 2;
/*    */       }
/*    */ 
/* 89 */       name = Introspector.decapitalize(name.substring(offset));
/* 90 */       sortedGetters.put(name, returnType);
/*    */     }
/*    */ 
/* 93 */     return sortedGetters;
/*    */   }
/*    */ 
/*    */   static
/*    */   {
/* 55 */     excludedGetters.add("getCause");
/* 56 */     excludedGetters.add("getClass");
/* 57 */     excludedGetters.add("getLocalizedMessage");
/* 58 */     excludedGetters.add("getStackTrace");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.AbstractWrapperGenerator
 * JD-Core Version:    0.6.0
 */