/*     */ package org.jboss.ws.core.jaxrpc.handler;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import javax.xml.rpc.handler.Handler;
/*     */ import javax.xml.rpc.handler.HandlerInfo;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import javax.xml.rpc.soap.SOAPFaultException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class HandlerWrapper
/*     */   implements Handler
/*     */ {
/*  42 */   private static Logger log = Logger.getLogger(HandlerWrapper.class);
/*     */   public static final int DOES_NOT_EXIST = 0;
/*     */   public static final int METHOD_READY = 1;
/*  48 */   private static String[] stateNames = { "DOES_NOT_EXIST", "METHOD_READY" };
/*     */   private Handler delegate;
/*     */   private int state;
/*     */ 
/*     */   public HandlerWrapper(Handler handler)
/*     */   {
/*  60 */     this.delegate = handler;
/*  61 */     this.state = 0;
/*     */   }
/*     */ 
/*     */   public int getState()
/*     */   {
/*  69 */     return this.state;
/*     */   }
/*     */ 
/*     */   public String getStateAsString()
/*     */   {
/*  77 */     return stateNames[this.state];
/*     */   }
/*     */ 
/*     */   public QName[] getHeaders()
/*     */   {
/*  85 */     return this.delegate.getHeaders();
/*     */   }
/*     */ 
/*     */   public void init(HandlerInfo config)
/*     */     throws JAXRPCException
/*     */   {
/*  93 */     if (log.isDebugEnabled()) log.debug("init: " + this.delegate);
/*  94 */     this.delegate.init(config);
/*  95 */     this.state = 1;
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */     throws JAXRPCException
/*     */   {
/* 103 */     if (log.isDebugEnabled()) log.debug("destroy: " + this.delegate);
/* 104 */     this.state = 0;
/* 105 */     this.delegate.destroy();
/*     */   }
/*     */ 
/*     */   public boolean handleRequest(MessageContext msgContext)
/*     */     throws JAXRPCException, SOAPFaultException
/*     */   {
/* 113 */     if (this.state == 0)
/*     */     {
/* 115 */       log.warn("Handler is in state DOES_NOT_EXIST, skipping Handler.handleRequest for: " + this.delegate);
/* 116 */       return true;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 121 */       return this.delegate.handleRequest(msgContext);
/*     */     }
/*     */     catch (RuntimeException e) {
/*     */     }
/* 125 */     return handleRuntimeException(e);
/*     */   }
/*     */ 
/*     */   public boolean handleResponse(MessageContext msgContext)
/*     */   {
/* 134 */     if (this.state == 0)
/*     */     {
/* 136 */       log.warn("Handler is in state DOES_NOT_EXIST, skipping Handler.handleResponse for: " + this.delegate);
/* 137 */       return true;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 142 */       return this.delegate.handleResponse(msgContext);
/*     */     }
/*     */     catch (RuntimeException e) {
/*     */     }
/* 146 */     return handleRuntimeException(e);
/*     */   }
/*     */ 
/*     */   public boolean handleFault(MessageContext msgContext)
/*     */   {
/* 155 */     if (this.state == 0)
/*     */     {
/* 157 */       log.warn("Handler is in state DOES_NOT_EXIST, skipping Handler.handleFault for: " + this.delegate);
/* 158 */       return true;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 163 */       return this.delegate.handleFault(msgContext);
/*     */     }
/*     */     catch (RuntimeException e) {
/*     */     }
/* 167 */     return handleRuntimeException(e);
/*     */   }
/*     */ 
/*     */   private boolean handleRuntimeException(RuntimeException e)
/*     */   {
/* 177 */     if (!(e instanceof SOAPFaultException))
/*     */     {
/* 179 */       log.warn("RuntimeException in handler method, transition to DOES_NOT_EXIST");
/* 180 */       destroy();
/*     */     }
/*     */ 
/* 183 */     throw e;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 191 */     return this.delegate.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 199 */     return "[state=" + getStateAsString() + ",handler=" + this.delegate + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.handler.HandlerWrapper
 * JD-Core Version:    0.6.0
 */