/*     */ package org.jboss.ws.core.jaxrpc.handler;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import javax.xml.rpc.handler.Handler;
/*     */ import javax.xml.rpc.handler.HandlerChain;
/*     */ import javax.xml.rpc.handler.HandlerInfo;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.soap.SOAPPart;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.soap.SOAPElementWriter;
/*     */ import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public abstract class HandlerChainBaseImpl
/*     */   implements HandlerChain
/*     */ {
/*  64 */   private static Logger log = Logger.getLogger(HandlerChainBaseImpl.class);
/*     */   public static final int STATE_DOES_NOT_EXIST = 0;
/*     */   public static final int STATE_CREATED = 1;
/*     */   public static final int STATE_READY = 2;
/*     */   public static final int STATE_DESTROYED = 3;
/*  72 */   protected List<HandlerEntry> handlers = new ArrayList();
/*     */ 
/*  74 */   protected Set<String> roles = new HashSet();
/*     */ 
/*  76 */   protected int falseIndex = -1;
/*     */   protected int state;
/*     */ 
/*     */   public HandlerChainBaseImpl(List<HandlerInfo> infos, Set<String> roles)
/*     */   {
/*  85 */     log.debug("Create a handler chain for roles: " + roles);
/*  86 */     addHandlersToChain(infos, roles);
/*     */   }
/*     */ 
/*     */   public List<HandlerInfo> getHandlerInfos()
/*     */   {
/*  93 */     List list = new ArrayList();
/*  94 */     for (int i = 0; i < this.handlers.size(); i++)
/*     */     {
/*  96 */       HandlerEntry entry = (HandlerEntry)this.handlers.get(i);
/*  97 */       list.add(entry.info);
/*     */     }
/*  99 */     return list;
/*     */   }
/*     */ 
/*     */   public void pullHeaders(Set<QName> headers)
/*     */   {
/* 104 */     for (HandlerEntry entry : this.handlers)
/*     */     {
/* 106 */       QName[] handlerHeaders = entry.handler.getHeaders();
/* 107 */       if (handlerHeaders != null)
/* 108 */         Collections.addAll(headers, handlerHeaders);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Set<QName> getHeaders()
/*     */   {
/* 114 */     HashSet set = new HashSet();
/* 115 */     pullHeaders(set);
/* 116 */     return set;
/*     */   }
/*     */ 
/*     */   private void addHandlersToChain(List<HandlerInfo> infos, Set<String> roleSet)
/*     */   {
/*     */     try
/*     */     {
/* 126 */       if (infos != null)
/*     */       {
/* 128 */         for (HandlerInfo info : infos)
/*     */         {
/* 130 */           HandlerWrapper handler = new HandlerWrapper((Handler)info.getHandlerClass().newInstance());
/* 131 */           UnifiedHandlerMetaData.HandlerType type = (UnifiedHandlerMetaData.HandlerType)info.getHandlerConfig().get(UnifiedHandlerMetaData.HandlerType.class.getName());
/* 132 */           this.handlers.add(new HandlerEntry(handler, info, type));
/*     */         }
/*     */       }
/* 135 */       if (roleSet != null)
/*     */       {
/* 137 */         this.roles.addAll(roleSet);
/*     */       }
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 142 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 146 */       throw new JAXRPCException("Cannot initialize handler chain", ex);
/*     */     }
/*     */ 
/* 150 */     this.state = 1;
/*     */   }
/*     */ 
/*     */   public int getState()
/*     */   {
/* 158 */     return this.state;
/*     */   }
/*     */ 
/*     */   public void init(Map config)
/*     */   {
/* 169 */     log.debug("init: [config=" + config + "]");
/* 170 */     for (int i = 0; i < this.handlers.size(); i++)
/*     */     {
/* 172 */       HandlerEntry entry = (HandlerEntry)this.handlers.get(i);
/* 173 */       entry.handler.init(entry.info);
/*     */     }
/*     */ 
/* 177 */     this.state = 2;
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 187 */     log.debug("destroy");
/* 188 */     for (int i = 0; i < this.handlers.size(); i++)
/*     */     {
/* 190 */       HandlerEntry entry = (HandlerEntry)this.handlers.get(i);
/* 191 */       entry.handler.destroy();
/*     */     }
/* 193 */     this.handlers.clear();
/*     */ 
/* 196 */     this.state = 3;
/*     */   }
/*     */ 
/*     */   public String[] getRoles()
/*     */   {
/* 207 */     Set auxlist = new HashSet(this.roles);
/* 208 */     auxlist.add("http://schemas.xmlsoap.org/soap/actor/next");
/* 209 */     String[] roleArr = new String[auxlist.size()];
/* 210 */     auxlist.toArray(roleArr);
/* 211 */     return roleArr;
/*     */   }
/*     */ 
/*     */   public void setRoles(String[] soapActorNames)
/*     */   {
/* 226 */     List newRoles = Arrays.asList(soapActorNames);
/* 227 */     log.debug("setRoles: " + newRoles);
/*     */ 
/* 229 */     this.roles.clear();
/* 230 */     this.roles.addAll(newRoles);
/*     */   }
/*     */ 
/*     */   public boolean handleRequest(MessageContext msgContext)
/*     */   {
/* 242 */     return handleRequestInternal(msgContext, UnifiedHandlerMetaData.HandlerType.ALL);
/*     */   }
/*     */ 
/*     */   public boolean handleRequest(MessageContext msgContext, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 247 */     return handleRequestInternal(msgContext, type);
/*     */   }
/*     */ 
/*     */   private boolean handleRequestInternal(MessageContext msgContext, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 252 */     boolean doNext = true;
/*     */ 
/* 254 */     if (this.handlers.size() > 0)
/*     */     {
/* 256 */       log.debug("Enter: handleRequest");
/*     */ 
/* 258 */       SOAPMessageContextJAXRPC jaxrpcContext = (SOAPMessageContextJAXRPC)msgContext;
/* 259 */       jaxrpcContext.setProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
/*     */ 
/* 262 */       replaceDirtyHandlers();
/*     */ 
/* 264 */       int handlerIndex = 0;
/* 265 */       Handler currHandler = null;
/*     */       try
/*     */       {
/* 268 */         String lastMessageTrace = null;
/* 269 */         for (; (doNext) && (handlerIndex < this.handlers.size()); handlerIndex++)
/*     */         {
/* 271 */           HandlerEntry handlerEntry = (HandlerEntry)this.handlers.get(handlerIndex);
/* 272 */           if ((type != UnifiedHandlerMetaData.HandlerType.ALL) && (type != handlerEntry.getType()))
/*     */             continue;
/* 274 */           currHandler = handlerEntry.getHandler();
/*     */ 
/* 276 */           if (log.isTraceEnabled())
/*     */           {
/* 278 */             SOAPPart soapPart = jaxrpcContext.getSOAPMessage().getSOAPPart();
/* 279 */             lastMessageTrace = traceSOAPPart("BEFORE handleRequest - " + currHandler, soapPart, lastMessageTrace);
/*     */           }
/*     */ 
/* 282 */           doNext = currHandler.handleRequest(msgContext);
/*     */ 
/* 284 */           if (!log.isTraceEnabled())
/*     */             continue;
/* 286 */           SOAPPart soapPart = jaxrpcContext.getSOAPMessage().getSOAPPart();
/* 287 */           lastMessageTrace = traceSOAPPart("AFTER handleRequest - " + currHandler, soapPart, lastMessageTrace);
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 294 */         log.error("RuntimeException in request handler", e);
/* 295 */         doNext = false;
/* 296 */         throw e;
/*     */       }
/*     */       finally
/*     */       {
/* 301 */         if (!doNext) {
/* 302 */           this.falseIndex = (handlerIndex - 1);
/*     */         }
/* 304 */         jaxrpcContext.removeProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
/* 305 */         log.debug("Exit: handleRequest with status: " + doNext);
/*     */       }
/*     */     }
/*     */ 
/* 309 */     return doNext;
/*     */   }
/*     */ 
/*     */   public boolean handleResponse(MessageContext msgContext)
/*     */   {
/* 324 */     return handleResponseInternal(msgContext, UnifiedHandlerMetaData.HandlerType.ALL);
/*     */   }
/*     */ 
/*     */   public boolean handleResponse(MessageContext msgContext, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 329 */     return handleResponseInternal(msgContext, type);
/*     */   }
/*     */ 
/*     */   private boolean handleResponseInternal(MessageContext msgContext, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 334 */     boolean doNext = true;
/*     */ 
/* 336 */     if (this.handlers.size() > 0)
/*     */     {
/* 338 */       log.debug("Enter: handleResponse");
/*     */ 
/* 340 */       SOAPMessageContextJAXRPC jaxrpcContext = (SOAPMessageContextJAXRPC)msgContext;
/* 341 */       jaxrpcContext.setProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
/*     */ 
/* 343 */       int handlerIndex = this.handlers.size() - 1;
/* 344 */       if (this.falseIndex != -1) {
/* 345 */         handlerIndex = this.falseIndex;
/*     */       }
/* 347 */       Handler currHandler = null;
/*     */       try
/*     */       {
/* 350 */         String lastMessageTrace = null;
/* 351 */         for (; (doNext) && (handlerIndex >= 0); handlerIndex--)
/*     */         {
/* 353 */           HandlerEntry handlerEntry = (HandlerEntry)this.handlers.get(handlerIndex);
/* 354 */           if ((type != UnifiedHandlerMetaData.HandlerType.ALL) && (type != handlerEntry.getType()))
/*     */             continue;
/* 356 */           currHandler = handlerEntry.getHandler();
/*     */ 
/* 358 */           if (log.isTraceEnabled())
/*     */           {
/* 360 */             SOAPPart soapPart = jaxrpcContext.getSOAPMessage().getSOAPPart();
/* 361 */             lastMessageTrace = traceSOAPPart("BEFORE handleResponse - " + currHandler, soapPart, lastMessageTrace);
/*     */           }
/*     */ 
/* 364 */           doNext = currHandler.handleResponse(msgContext);
/*     */ 
/* 366 */           if (!log.isTraceEnabled())
/*     */             continue;
/* 368 */           SOAPPart soapPart = jaxrpcContext.getSOAPMessage().getSOAPPart();
/* 369 */           lastMessageTrace = traceSOAPPart("AFTER handleResponse - " + currHandler, soapPart, lastMessageTrace);
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (RuntimeException rte)
/*     */       {
/* 376 */         log.error("RuntimeException in response handler", rte);
/* 377 */         doNext = false;
/* 378 */         throw rte;
/*     */       }
/*     */       finally
/*     */       {
/* 383 */         if (!doNext) {
/* 384 */           this.falseIndex = (handlerIndex - 1);
/*     */         }
/* 386 */         jaxrpcContext.removeProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
/* 387 */         log.debug("Exit: handleResponse with status: " + doNext);
/*     */       }
/*     */     }
/*     */ 
/* 391 */     return doNext;
/*     */   }
/*     */ 
/*     */   public boolean handleFault(MessageContext msgContext)
/*     */   {
/* 406 */     return handleFaultInternal(msgContext, UnifiedHandlerMetaData.HandlerType.ALL);
/*     */   }
/*     */ 
/*     */   public boolean handleFault(MessageContext msgContext, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 411 */     return handleFaultInternal(msgContext, type);
/*     */   }
/*     */ 
/*     */   private boolean handleFaultInternal(MessageContext msgContext, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 416 */     boolean doNext = true;
/*     */ 
/* 418 */     if (this.handlers.size() > 0)
/*     */     {
/* 420 */       log.debug("Enter: handleFault");
/*     */ 
/* 422 */       SOAPMessageContextJAXRPC jaxrpcContext = (SOAPMessageContextJAXRPC)msgContext;
/* 423 */       jaxrpcContext.setProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
/*     */       try
/*     */       {
/* 427 */         int handlerIndex = this.handlers.size() - 1;
/* 428 */         if (this.falseIndex != -1) {
/* 429 */           handlerIndex = this.falseIndex;
/*     */         }
/* 431 */         Handler currHandler = null;
/* 432 */         for (; (doNext) && (handlerIndex >= 0); handlerIndex--)
/*     */         {
/* 434 */           HandlerEntry handlerEntry = (HandlerEntry)this.handlers.get(handlerIndex);
/* 435 */           if ((type != UnifiedHandlerMetaData.HandlerType.ALL) && (type != handlerEntry.getType()))
/*     */             continue;
/* 437 */           currHandler = handlerEntry.getHandler();
/*     */ 
/* 439 */           log.debug("Handle fault: " + currHandler);
/* 440 */           doNext = currHandler.handleFault(msgContext);
/*     */         }
/*     */ 
/*     */       }
/*     */       finally
/*     */       {
/* 446 */         jaxrpcContext.removeProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
/* 447 */         log.debug("Exit: handleFault with status: " + doNext);
/*     */       }
/*     */     }
/*     */ 
/* 451 */     return doNext;
/*     */   }
/*     */ 
/*     */   protected String traceSOAPPart(String logMsg, SOAPPart soapPart, String lastMessageTrace)
/*     */   {
/*     */     try
/*     */     {
/* 460 */       SOAPEnvelopeImpl soapEnv = (SOAPEnvelopeImpl)soapPart.getEnvelope();
/* 461 */       String envStr = SOAPElementWriter.writeElement(soapEnv, true);
/* 462 */       if (envStr.equals(lastMessageTrace))
/*     */       {
/* 464 */         log.trace(logMsg + ": unchanged");
/*     */       }
/*     */       else
/*     */       {
/* 468 */         log.trace(logMsg + "\n" + envStr);
/* 469 */         lastMessageTrace = envStr;
/*     */       }
/* 471 */       return lastMessageTrace;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 475 */       log.error("Cannot trace SOAP message", ex);
/* 476 */     }return null;
/*     */   }
/*     */ 
/*     */   protected void replaceDirtyHandlers()
/*     */   {
/* 485 */     for (int i = 0; i < this.handlers.size(); i++)
/*     */     {
/* 487 */       HandlerEntry entry = (HandlerEntry)this.handlers.get(i);
/* 488 */       if (entry.handler.getState() != 0)
/*     */         continue;
/* 490 */       log.debug("Replacing dirty handler: " + entry.handler);
/*     */       try
/*     */       {
/* 493 */         HandlerWrapper handler = new HandlerWrapper((Handler)entry.info.getHandlerClass().newInstance());
/* 494 */         HandlerEntry.access$102(entry, handler);
/* 495 */         handler.init(entry.info);
/*     */       }
/*     */       catch (RuntimeException rte)
/*     */       {
/* 499 */         throw rte;
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 503 */         log.error("Cannot create handler instance for: " + entry.info, ex);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Handler getHandlerAt(int pos)
/*     */   {
/* 514 */     if ((pos < 0) || (this.handlers.size() <= pos)) {
/* 515 */       throw new IllegalArgumentException("No handler at position: " + pos);
/*     */     }
/* 517 */     HandlerEntry entry = (HandlerEntry)this.handlers.get(pos);
/* 518 */     return entry.handler;
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/* 566 */     return this.handlers.remove(o);
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection c)
/*     */   {
/* 571 */     return this.handlers.containsAll(c);
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection c)
/*     */   {
/* 576 */     return this.handlers.removeAll(c);
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection c)
/*     */   {
/* 581 */     return this.handlers.retainAll(c);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 586 */     return this.handlers.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 591 */     return this.handlers.equals(o);
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/* 596 */     return this.handlers.iterator();
/*     */   }
/*     */ 
/*     */   public List subList(int fromIndex, int toIndex)
/*     */   {
/* 601 */     return this.handlers.subList(fromIndex, toIndex);
/*     */   }
/*     */ 
/*     */   public ListIterator listIterator()
/*     */   {
/* 606 */     return this.handlers.listIterator();
/*     */   }
/*     */ 
/*     */   public ListIterator listIterator(int index)
/*     */   {
/* 611 */     return this.handlers.listIterator(index);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 616 */     return this.handlers.size();
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 621 */     this.handlers.clear();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 626 */     return this.handlers.isEmpty();
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 631 */     return this.handlers.toArray();
/*     */   }
/*     */ 
/*     */   public Object get(int index)
/*     */   {
/* 636 */     return this.handlers.get(index);
/*     */   }
/*     */ 
/*     */   public Object remove(int index)
/*     */   {
/* 641 */     return this.handlers.remove(index);
/*     */   }
/*     */ 
/*     */   public void add(int index, Object element)
/*     */   {
/* 646 */     this.handlers.add(index, (HandlerEntry)element);
/*     */   }
/*     */ 
/*     */   public int indexOf(Object elem)
/*     */   {
/* 651 */     return this.handlers.indexOf(elem);
/*     */   }
/*     */ 
/*     */   public int lastIndexOf(Object elem)
/*     */   {
/* 656 */     return this.handlers.lastIndexOf(elem);
/*     */   }
/*     */ 
/*     */   public boolean add(Object o)
/*     */   {
/* 661 */     return this.handlers.add((HandlerEntry)o);
/*     */   }
/*     */ 
/*     */   public boolean contains(Object elem)
/*     */   {
/* 666 */     return this.handlers.contains(elem);
/*     */   }
/*     */ 
/*     */   public boolean addAll(int index, Collection c)
/*     */   {
/* 671 */     return this.handlers.addAll(index, c);
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection c)
/*     */   {
/* 676 */     return this.handlers.addAll(c);
/*     */   }
/*     */ 
/*     */   public Object set(int index, Object element)
/*     */   {
/* 681 */     return this.handlers.set(index, (HandlerEntry)element);
/*     */   }
/*     */ 
/*     */   public Object[] toArray(Object[] a)
/*     */   {
/* 686 */     return this.handlers.toArray(a);
/*     */   }
/*     */ 
/*     */   private class HandlerEntry
/*     */   {
/*     */     private HandlerWrapper handler;
/*     */     private HandlerInfo info;
/*     */     private UnifiedHandlerMetaData.HandlerType type;
/*     */ 
/*     */     public HandlerEntry(HandlerWrapper handler, HandlerInfo info, UnifiedHandlerMetaData.HandlerType type)
/*     */     {
/* 532 */       if ((handler == null) || (info == null)) {
/* 533 */         throw new IllegalStateException("Invalid handler entry");
/*     */       }
/* 535 */       if (type == null)
/*     */       {
/* 537 */         HandlerChainBaseImpl.log.debug("Using handler type default: " + UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/* 538 */         type = UnifiedHandlerMetaData.HandlerType.ENDPOINT;
/*     */       }
/*     */ 
/* 541 */       this.handler = handler;
/* 542 */       this.info = info;
/* 543 */       this.type = type;
/*     */     }
/*     */ 
/*     */     public Handler getHandler()
/*     */     {
/* 548 */       return this.handler;
/*     */     }
/*     */ 
/*     */     public HandlerInfo getInfo()
/*     */     {
/* 553 */       return this.info;
/*     */     }
/*     */ 
/*     */     public UnifiedHandlerMetaData.HandlerType getType()
/*     */     {
/* 558 */       return this.type;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.handler.HandlerChainBaseImpl
 * JD-Core Version:    0.6.0
 */