/*     */ package org.jboss.ws.core.jaxrpc.client;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.net.URL;
/*     */ import javax.naming.BinaryRefAddr;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.Referenceable;
/*     */ import javax.naming.StringRefAddr;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityOMFactory;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.management.ServerConfig;
/*     */ import org.jboss.wsf.spi.management.ServerConfigFactory;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*     */ 
/*     */ public class ServiceReferenceable
/*     */   implements Referenceable
/*     */ {
/*  62 */   private static Logger log = Logger.getLogger(ServiceReferenceable.class);
/*     */   public static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";
/*     */   public static final String SECURITY_CONFIG = "SECURITY_CONFIG";
/*     */   public static final String PORT_COMPONENT_LINK = "PORT_COMPONENT_LINK";
/*     */   public static final String PORT_COMPONENT_LINK_SERVLET = "PORT_COMPONENT_LINK_SERVLET";
/*     */   private UnifiedServiceRefMetaData refMetaData;
/*     */   private UnifiedVirtualFile vfsRoot;
/*     */ 
/*     */   public ServiceReferenceable(UnifiedServiceRefMetaData refMetaData)
/*     */   {
/*  77 */     this.refMetaData = refMetaData;
/*  78 */     this.vfsRoot = refMetaData.getVfsRoot();
/*     */   }
/*     */ 
/*     */   public Reference getReference()
/*     */     throws NamingException
/*     */   {
/*  89 */     Reference myRef = new Reference(ServiceReferenceable.class.getName(), ServiceObjectFactoryJAXRPC.class.getName(), null);
/*     */ 
/*  92 */     myRef.add(new BinaryRefAddr("SERVICE_REF_META_DATA", marshallServiceRef()));
/*     */ 
/*  95 */     if (getSecurityConfig() != null) {
/*  96 */       myRef.add(new BinaryRefAddr("SECURITY_CONFIG", marshallSecurityConfig()));
/*     */     }
/*     */ 
/*  99 */     for (UnifiedPortComponentRefMetaData pcr : this.refMetaData.getPortComponentRefs())
/*     */     {
/* 101 */       String pcLink = pcr.getPortComponentLink();
/* 102 */       if (pcLink != null)
/*     */       {
/* 104 */         myRef.add(new StringRefAddr("PORT_COMPONENT_LINK", pcLink));
/*     */         try
/*     */         {
/* 107 */           SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 108 */           ServerConfig config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
/*     */ 
/* 110 */           String host = config.getWebServiceHost();
/* 111 */           int port = config.getWebServicePort();
/*     */ 
/* 113 */           String servletURL = "http://" + host + ":" + port + "/jbossws/pclink";
/* 114 */           myRef.add(new StringRefAddr("PORT_COMPONENT_LINK_SERVLET", servletURL));
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 118 */           throw new NamingException("Cannot obtain path to PortComponentLinkServlet: " + ex);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 123 */     return myRef;
/*     */   }
/*     */ 
/*     */   private byte[] marshallServiceRef()
/*     */     throws NamingException
/*     */   {
/* 130 */     ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
/*     */     try
/*     */     {
/* 133 */       ObjectOutputStream oos = new ObjectOutputStream(baos);
/* 134 */       oos.writeObject(this.refMetaData);
/* 135 */       oos.close();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 139 */       throw new NamingException("Cannot marshall service ref meta data, cause: " + e.toString());
/*     */     }
/* 141 */     return baos.toByteArray();
/*     */   }
/*     */ 
/*     */   private byte[] marshallSecurityConfig()
/*     */     throws NamingException
/*     */   {
/* 148 */     ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
/*     */     try
/*     */     {
/* 151 */       ObjectOutputStream oos = new ObjectOutputStream(baos);
/* 152 */       WSSecurityOMFactory factory = WSSecurityOMFactory.newInstance();
/* 153 */       WSSecurityConfiguration securityConfig = factory.parse(getSecurityConfig());
/* 154 */       oos.writeObject(securityConfig);
/* 155 */       oos.close();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 159 */       throw new NamingException("Cannot marshall security config, cause: " + e.toString());
/*     */     }
/* 161 */     return baos.toByteArray();
/*     */   }
/*     */ 
/*     */   private URL getSecurityConfig()
/*     */   {
/* 166 */     URL securityConfigURL = null;
/*     */     try
/*     */     {
/* 169 */       UnifiedVirtualFile vfConfig = this.vfsRoot.findChild("WEB-INF/" + WSSecurityOMFactory.CLIENT_RESOURCE_NAME);
/* 170 */       securityConfigURL = vfConfig.toURL();
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 178 */       UnifiedVirtualFile vfConfig = this.vfsRoot.findChild("META-INF/" + WSSecurityOMFactory.CLIENT_RESOURCE_NAME);
/* 179 */       securityConfigURL = vfConfig.toURL();
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/*     */     }
/*     */ 
/* 185 */     return securityConfigURL;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.client.ServiceReferenceable
 * JD-Core Version:    0.6.0
 */