/*     */ package org.jboss.ws.core.jaxrpc.client;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.Remote;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.List;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import javax.xml.rpc.Service;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ServiceProxy
/*     */   implements InvocationHandler
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(ServiceProxy.class);
/*     */   private ServiceImpl jaxrpcService;
/*  57 */   private List objectMethods = new ArrayList();
/*     */ 
/*  59 */   private List jaxrpcServiceMethods = new ArrayList();
/*     */ 
/*  61 */   private List serviceInterfaceMethods = new ArrayList();
/*     */   private Method getPortMethod;
/*     */ 
/*     */   public ServiceProxy(ServiceImpl service, Class siClass)
/*     */   {
/*  76 */     this.jaxrpcService = service;
/*     */ 
/*  79 */     this.objectMethods.addAll(Arrays.asList(Object.class.getMethods()));
/*     */ 
/*  82 */     this.jaxrpcServiceMethods.addAll(Arrays.asList(ServiceExt.class.getMethods()));
/*     */ 
/*  85 */     if (!siClass.getName().equals("javax.xml.rpc.Service")) {
/*  86 */       this.serviceInterfaceMethods.addAll(Arrays.asList(siClass.getDeclaredMethods()));
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  91 */       this.getPortMethod = Service.class.getMethod("getPort", new Class[] { Class.class });
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*  95 */       throw new JAXRPCException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 105 */     String methodName = method.getName();
/*     */     try
/*     */     {
/* 109 */       Object retObj = null;
/* 110 */       if (this.jaxrpcServiceMethods.contains(method))
/*     */       {
/* 112 */         if (log.isDebugEnabled()) log.debug("Invoke on jaxrpc service: " + methodName);
/*     */ 
/* 114 */         if (method.getName().equals("getPort"))
/*     */         {
/* 116 */           Remote port = (Remote)method.invoke(this.jaxrpcService, args);
/* 117 */           return port;
/*     */         }
/*     */ 
/* 121 */         retObj = method.invoke(this.jaxrpcService, args);
/* 122 */         return retObj;
/*     */       }
/*     */ 
/* 125 */       if (this.serviceInterfaceMethods.contains(method))
/*     */       {
/* 127 */         if (log.isDebugEnabled()) log.debug("Invoke on service interface: " + methodName);
/*     */ 
/* 129 */         Class seiClass = method.getReturnType();
/* 130 */         retObj = this.getPortMethod.invoke(this.jaxrpcService, new Object[] { seiClass });
/* 131 */         return retObj;
/*     */       }
/* 133 */       if (this.objectMethods.contains(method))
/*     */       {
/* 135 */         if (log.isDebugEnabled()) log.debug("Invoke on object: " + methodName);
/*     */ 
/* 137 */         retObj = method.invoke(this.jaxrpcService, args);
/* 138 */         return retObj;
/*     */       }
/*     */ 
/* 141 */       throw new JAXRPCException("Don't know how to invoke: " + method);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 145 */       handleException(e);
/* 146 */     }return null;
/*     */   }
/*     */ 
/*     */   private void handleException(Exception ex)
/*     */     throws Throwable
/*     */   {
/* 155 */     Throwable th = ex;
/* 156 */     if ((ex instanceof InvocationTargetException)) {
/* 157 */       th = ((InvocationTargetException)ex).getTargetException();
/*     */     }
/* 159 */     log.error("Service error", th);
/* 160 */     throw th;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.client.ServiceProxy
 * JD-Core Version:    0.6.0
 */