/*    */ package org.jboss.ws.core.jaxrpc.binding.jbossxb;
/*    */ 
/*    */ import java.util.Map;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.ws.core.CommonMessageContext;
/*    */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*    */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*    */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*    */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*    */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*    */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*    */ import org.jboss.xb.binding.MarshallingContext;
/*    */ import org.jboss.xb.binding.ObjectLocalMarshaller;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*    */ import org.jboss.xb.util.Dom2Sax;
/*    */ import org.w3c.dom.Element;
/*    */ import org.xml.sax.ContentHandler;
/*    */ import org.xml.sax.SAXException;
/*    */ 
/*    */ public class JBossXBSupport
/*    */ {
/*    */   public static SchemaBinding getOrCreateSchemaBinding(Map properties)
/*    */   {
/* 42 */     SchemaBinding schemaBinding = null;
/* 43 */     SchemaBindingBuilder bindingBuilder = new SchemaBindingBuilder();
/*    */ 
/* 45 */     QName xmlName = (QName)properties.get("org.jboss.xb.root.qname");
/* 46 */     QName xmlType = (QName)properties.get("org.jboss.xb.type.qname");
/*    */ 
/* 49 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 50 */     if (msgContext != null)
/*    */     {
/* 52 */       OperationMetaData opMetaData = msgContext.getOperationMetaData();
/* 53 */       EndpointMetaData epMetaData = opMetaData.getEndpointMetaData();
/* 54 */       ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
/* 55 */       schemaBinding = serviceMetaData.getSchemaBinding();
/*    */     }
/*    */ 
/* 59 */     if (schemaBinding == null)
/*    */     {
/* 61 */       JBossXSModel xsModel = (JBossXSModel)properties.get("org.jboss.xb.xsd.xsmodel");
/* 62 */       JavaWsdlMapping wsdlMapping = (JavaWsdlMapping)properties.get("org.jboss.xb.java.mapping");
/* 63 */       schemaBinding = bindingBuilder.buildSchemaBinding(xsModel, wsdlMapping);
/*    */     }
/*    */ 
/* 70 */     bindingBuilder.bindParameterToElement(schemaBinding, xmlName, xmlType);
/*    */ 
/* 72 */     return schemaBinding;
/*    */   }
/*    */ 
/*    */   public static ObjectLocalMarshaller getWildcardMarshaller()
/*    */   {
/* 85 */     return new ObjectLocalMarshaller()
/*    */     {
/*    */       public void marshal(MarshallingContext ctx, Object o) {
/* 88 */         if (o == null)
/*    */         {
/* 90 */           return;
/*    */         }
/*    */ 
/* 93 */         Element e = (Element)o;
/* 94 */         ContentHandler ch = ctx.getContentHandler();
/*    */         try
/*    */         {
/* 97 */           Dom2Sax.dom2sax(e, ch);
/*    */         }
/*    */         catch (SAXException e1)
/*    */         {
/* 101 */           throw new IllegalStateException("Failed to marshal DOM element " + new QName(e.getNamespaceURI(), e.getLocalName()) + ": " + e1.getMessage());
/*    */         }
/*    */       }
/*    */     };
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBSupport
 * JD-Core Version:    0.6.0
 */