/*     */ package org.jboss.ws.core.jaxrpc.binding.jbossxb;
/*     */ 
/*     */ import java.io.OutputStream;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.Writer;
/*     */ import java.util.HashMap;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.extensions.xop.jaxrpc.XOPMarshallerImpl;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.jboss.xb.binding.sunday.marshalling.MarshallerImpl;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.w3c.dom.Node;
/*     */ import org.xml.sax.ContentHandler;
/*     */ 
/*     */ public class JBossXBMarshallerImpl
/*     */   implements JBossXBMarshaller
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(JBossXBMarshallerImpl.class);
/*     */ 
/*  60 */   private HashMap properties = new HashMap();
/*     */   private MarshallerImpl delegate;
/*     */ 
/*     */   public JBossXBMarshallerImpl()
/*     */   {
/*  69 */     this.delegate = new MarshallerImpl();
/*  70 */     this.delegate.setProperty("org.jboss.xml.binding.marshalling.version", "false");
/*  71 */     this.delegate.setProperty("org.jboss.xml.binding.marshalling.indent", "false");
/*  72 */     this.delegate.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
/*  73 */     this.delegate.setSupportNil(true);
/*     */   }
/*     */ 
/*     */   public void marshal(Object obj, Writer writer)
/*     */     throws MarshalException
/*     */   {
/*  81 */     assertRequiredProperties();
/*     */     try
/*     */     {
/*  85 */       QName xmlName = (QName)getProperty("org.jboss.xb.root.qname");
/*  86 */       this.delegate.addRootElement(xmlName);
/*     */ 
/*  88 */       QName xmlType = (QName)getProperty("org.jboss.xb.type.qname");
/*  89 */       boolean isAnonymousType = (xmlType != null) && (xmlType.getLocalPart().startsWith(">"));
/*  90 */       if ((xmlType != null) && (!isAnonymousType))
/*     */       {
/*  92 */         this.delegate.setRootTypeQName(xmlType);
/*     */       }
/*     */ 
/*  95 */       if (xmlName.getNamespaceURI().length() > 0)
/*     */       {
/*  97 */         String prefix = xmlName.getPrefix();
/*  98 */         String nsURI = xmlName.getNamespaceURI();
/*  99 */         this.delegate.declareNamespace(prefix, nsURI);
/*     */       }
/*     */ 
/* 104 */       JavaWsdlMapping wsdlMapping = (JavaWsdlMapping)getProperty("org.jboss.xb.java.mapping");
/* 105 */       if (wsdlMapping != null)
/*     */       {
/* 107 */         JavaXmlTypeMapping[] javaXmlMappings = wsdlMapping.getJavaXmlTypeMappings();
/* 108 */         if (javaXmlMappings != null)
/*     */         {
/* 110 */           for (int i = 0; i < javaXmlMappings.length; i++)
/*     */           {
/* 112 */             JavaXmlTypeMapping javaXmlMapping = javaXmlMappings[i];
/* 113 */             VariableMapping[] variableMappings = javaXmlMapping.getVariableMappings();
/*     */ 
/* 115 */             if (variableMappings == null)
/*     */               continue;
/* 117 */             String clsName = javaXmlMapping.getJavaType();
/* 118 */             Class cls = JavaUtils.loadJavaType(clsName, Thread.currentThread().getContextClassLoader());
/* 119 */             QName clsQName = javaXmlMapping.getRootTypeQName();
/*     */ 
/* 121 */             if (clsQName != null)
/*     */             {
/* 124 */               if ("complexType".equalsIgnoreCase(javaXmlMapping.getQnameScope()))
/*     */               {
/* 126 */                 this.delegate.mapClassToXsiType(cls, clsQName.getNamespaceURI(), clsQName.getLocalPart());
/*     */               }
/*     */             }
/*     */ 
/* 130 */             for (int j = 0; j < variableMappings.length; j++)
/*     */             {
/* 132 */               VariableMapping variableMapping = variableMappings[j];
/* 133 */               if (!variableMapping.getXmlWildcard())
/*     */                 continue;
/* 135 */               this.delegate.mapFieldToWildcard(cls, "_any", JBossXBSupport.getWildcardMarshaller());
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 144 */       SchemaBinding schemaBinding = JBossXBSupport.getOrCreateSchemaBinding(this.properties);
/* 145 */       schemaBinding.setXopMarshaller(new XOPMarshallerImpl());
/* 146 */       this.delegate.marshal(schemaBinding, null, obj, writer);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 150 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 154 */       throw new MarshalException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void marshal(Object obj, ContentHandler handler)
/*     */   {
/* 163 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void marshal(Object obj, Node node)
/*     */   {
/* 171 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void marshal(Object obj, OutputStream os)
/*     */     throws MarshalException
/*     */   {
/* 179 */     marshal(obj, new OutputStreamWriter(os));
/*     */   }
/*     */ 
/*     */   public Object getProperty(String name)
/*     */   {
/* 188 */     if (name == null) {
/* 189 */       throw new IllegalArgumentException("name parameter is null");
/*     */     }
/* 191 */     return this.properties.get(name);
/*     */   }
/*     */ 
/*     */   public void setProperty(String name, Object value)
/*     */   {
/* 201 */     if (name == null) {
/* 202 */       throw new IllegalArgumentException("name parameter is null");
/*     */     }
/* 204 */     this.properties.put(name, value);
/*     */   }
/*     */ 
/*     */   public Node getNode(Object contentTree)
/*     */   {
/* 212 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   private void assertRequiredProperties()
/*     */   {
/* 220 */     if ((getProperty("org.jboss.xb.xsd.reader") == null) && (getProperty("org.jboss.xb.xsd.xsmodel") == null)) {
/* 221 */       throw new WSException("Cannot find required property: org.jboss.xb.xsd.xsmodel");
/*     */     }
/* 223 */     if (getProperty("org.jboss.xb.java.mapping") == null) {
/* 224 */       throw new WSException("Cannot find required property: org.jboss.xb.java.mapping");
/*     */     }
/* 226 */     QName xmlName = (QName)getProperty("org.jboss.xb.root.qname");
/* 227 */     if (xmlName == null) {
/* 228 */       throw new WSException("Cannot find required property: org.jboss.xb.root.qname");
/*     */     }
/* 230 */     if ((xmlName.getNamespaceURI().length() > 0) && (xmlName.getPrefix().length() == 0))
/* 231 */       throw new IllegalArgumentException("The given root element name must be prefix qualified: " + xmlName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBMarshallerImpl
 * JD-Core Version:    0.6.0
 */