/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Result;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.util.NotImplementedException;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.ws.core.binding.SerializerSupport;
/*    */ import org.jboss.xb.binding.NamespaceRegistry;
/*    */ import org.jboss.xb.binding.SimpleTypeBindings;
/*    */ import org.w3c.dom.NamedNodeMap;
/*    */ 
/*    */ public class SimpleSerializer extends SerializerSupport
/*    */ {
/* 48 */   private static final Logger log = Logger.getLogger(SimpleSerializer.class);
/*    */ 
/*    */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes)
/*    */     throws BindingException
/*    */   {
/* 58 */     if (log.isDebugEnabled()) log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*    */ 
/* 61 */     String typeName = xmlType.getLocalPart();
/* 62 */     NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
/*    */ 
/* 64 */     if ("base64Binary".equals(typeName))
/*    */     {
/* 66 */       throw new NotImplementedException();
/*    */     }
/*    */ 
/* 70 */     String valueStr = SimpleTypeBindings.marshal(xmlType.getLocalPart(), value, nsRegistry);
/*    */ 
/* 73 */     String xmlFragment = wrapValueStr(xmlName, valueStr, nsRegistry, null, attributes, true);
/* 74 */     return new BufferedStreamResult(xmlFragment);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.SimpleSerializer
 * JD-Core Version:    0.6.0
 */