/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import java.util.HashSet;
/*    */ import java.util.Set;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Result;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.ws.core.binding.SerializerSupport;
/*    */ import org.jboss.xb.binding.NamespaceRegistry;
/*    */ import org.jboss.xb.binding.SimpleTypeBindings;
/*    */ import org.w3c.dom.NamedNodeMap;
/*    */ 
/*    */ public class QNameSerializer extends SerializerSupport
/*    */ {
/* 50 */   private static final Logger log = Logger.getLogger(QNameSerializer.class);
/*    */ 
/*    */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException
/*    */   {
/* 54 */     log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*    */ 
/* 56 */     QName qnameValue = (QName)value;
/* 57 */     String nsURI = qnameValue.getNamespaceURI();
/*    */ 
/* 59 */     NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
/* 60 */     Set nsExtras = new HashSet();
/*    */ 
/* 63 */     if (nsURI.length() > 0)
/*    */     {
/* 65 */       qnameValue = new QName(nsURI, qnameValue.getLocalPart());
/* 66 */       qnameValue = nsRegistry.registerQName(qnameValue);
/* 67 */       if (!nsURI.equals(xmlName.getNamespaceURI())) {
/* 68 */         nsExtras.add(nsURI);
/*    */       }
/*    */     }
/* 71 */     String valueStr = SimpleTypeBindings.marshalQName(qnameValue, nsRegistry);
/* 72 */     String xmlFragment = wrapValueStr(xmlName, valueStr, nsRegistry, nsExtras, attributes, true);
/* 73 */     return new BufferedStreamResult(xmlFragment);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.QNameSerializer
 * JD-Core Version:    0.6.0
 */