/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import java.util.Calendar;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Result;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.Constants;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.ws.core.binding.SerializerSupport;
/*    */ import org.jboss.xb.binding.NamespaceRegistry;
/*    */ import org.jboss.xb.binding.SimpleTypeBindings;
/*    */ import org.w3c.dom.NamedNodeMap;
/*    */ 
/*    */ public class CalendarSerializer extends SerializerSupport
/*    */ {
/* 49 */   private static final Logger log = Logger.getLogger(CalendarSerializer.class);
/*    */ 
/*    */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException
/*    */   {
/* 53 */     if (log.isDebugEnabled())
/* 54 */       log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*    */     String valueStr;
/* 57 */     if (Constants.TYPE_LITERAL_DATE.equals(xmlType)) {
/* 58 */       valueStr = SimpleTypeBindings.marshalDate((Calendar)value);
/*    */     }
/*    */     else
/*    */     {
/*    */       String valueStr;
/* 59 */       if (Constants.TYPE_LITERAL_TIME.equals(xmlType)) {
/* 60 */         valueStr = SimpleTypeBindings.marshalTime((Calendar)value);
/*    */       }
/*    */       else
/*    */       {
/*    */         String valueStr;
/* 61 */         if (Constants.TYPE_LITERAL_DATETIME.equals(xmlType))
/* 62 */           valueStr = SimpleTypeBindings.marshalDateTime((Calendar)value);
/*    */         else
/* 64 */           throw new IllegalArgumentException("Invalid xmlType: " + xmlType);
/*    */       }
/*    */     }
/*    */     String valueStr;
/* 66 */     NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
/* 67 */     String xmlFragment = wrapValueStr(xmlName, valueStr, nsRegistry, null, attributes, true);
/* 68 */     return new BufferedStreamResult(xmlFragment);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.CalendarSerializer
 * JD-Core Version:    0.6.0
 */