/*     */ package org.jboss.ws.core.jaxrpc.binding;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.CharArrayReader;
/*     */ import java.io.CharArrayWriter;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.IOUtils;
/*     */ 
/*     */ public class BufferedStreamSource extends StreamSource
/*     */ {
/*     */   private byte[] bytes;
/*     */   private char[] chars;
/*     */ 
/*     */   public BufferedStreamSource(StreamSource source)
/*     */   {
/*     */     try
/*     */     {
/*  54 */       InputStream ins = source.getInputStream();
/*  55 */       if (ins != null)
/*     */       {
/*  57 */         ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
/*  58 */         IOUtils.copyStream(baos, ins);
/*  59 */         this.bytes = baos.toByteArray();
/*     */       }
/*     */ 
/*  62 */       Reader rd = source.getReader();
/*  63 */       if ((ins == null) && (rd != null))
/*     */       {
/*  65 */         char[] auxbuf = new char[1024];
/*  66 */         CharArrayWriter wr = new CharArrayWriter(auxbuf.length);
/*  67 */         int r = rd.read(auxbuf);
/*  68 */         while (r > 0)
/*     */         {
/*  70 */           wr.write(auxbuf, 0, r);
/*  71 */           r = rd.read(auxbuf);
/*     */         }
/*  73 */         this.chars = wr.toCharArray();
/*     */       }
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/*  78 */       WSException.rethrow(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public BufferedStreamSource(byte[] bytes)
/*     */   {
/*  84 */     this.bytes = bytes;
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */   {
/*  90 */     return this.bytes != null ? new ByteArrayInputStream(this.bytes) : null;
/*     */   }
/*     */ 
/*     */   public Reader getReader()
/*     */   {
/*  96 */     return this.chars != null ? new CharArrayReader(this.chars) : null;
/*     */   }
/*     */ 
/*     */   public void setInputStream(InputStream inputStream)
/*     */   {
/* 102 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void setReader(Reader reader)
/*     */   {
/* 108 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 113 */     String retStr = null;
/* 114 */     if (this.bytes != null)
/* 115 */       retStr = new String(this.bytes);
/* 116 */     else if (this.chars != null)
/* 117 */       retStr = new String(this.chars);
/* 118 */     return "" + retStr;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.BufferedStreamSource
 * JD-Core Version:    0.6.0
 */