/*     */ package org.jboss.ws.core.jaxrpc;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import javax.servlet.ServletContext;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*     */ import javax.servlet.http.HttpSession;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import javax.xml.rpc.server.ServletEndpointContext;
/*     */ import org.jboss.ws.core.server.ServletRequestContext;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ 
/*     */ public class ServletEndpointContextImpl
/*     */   implements ServletEndpointContext
/*     */ {
/*     */   private ServletContext context;
/*     */   private HttpServletRequest request;
/*     */   private HttpServletResponse response;
/*     */ 
/*     */   public ServletEndpointContextImpl(ServletRequestContext context)
/*     */   {
/*  51 */     this.context = context.getServletContext();
/*  52 */     this.request = context.getHttpServletRequest();
/*  53 */     this.response = context.getHttpServletResponse();
/*     */   }
/*     */ 
/*     */   public HttpSession getHttpSession()
/*     */   {
/*  71 */     return this.request.getSession(false);
/*     */   }
/*     */ 
/*     */   public MessageContext getMessageContext()
/*     */   {
/*  76 */     return (MessageContext)MessageContextAssociation.peekMessageContext();
/*     */   }
/*     */ 
/*     */   public ServletContext getServletContext()
/*     */   {
/*  81 */     return this.context;
/*     */   }
/*     */ 
/*     */   public Principal getUserPrincipal()
/*     */   {
/*  86 */     return this.request.getUserPrincipal();
/*     */   }
/*     */ 
/*     */   public boolean isUserInRole(String role)
/*     */   {
/*  91 */     return this.request.isUserInRole(role);
/*     */   }
/*     */ 
/*     */   public HttpServletRequest getHttpServletRequest()
/*     */   {
/*  98 */     return this.request;
/*     */   }
/*     */ 
/*     */   public HttpServletResponse getHttpServletResponse()
/*     */   {
/* 103 */     return this.response;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.ServletEndpointContextImpl
 * JD-Core Version:    0.6.0
 */