/*     */ package org.jboss.ws.core.jaxrpc;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypesMetaData;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class SerializationContextJAXRPC extends SerializationContext
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(SerializationContextJAXRPC.class);
/*     */   private JavaWsdlMapping jaxrpcMapping;
/*     */ 
/*     */   public JavaWsdlMapping getJavaWsdlMapping()
/*     */   {
/*  59 */     if (this.jaxrpcMapping == null)
/*     */     {
/*  61 */       log.debug("Generate jaxrpcMapping from typeMapping");
/*     */ 
/*  63 */       this.jaxrpcMapping = new JavaWsdlMapping();
/*  64 */       for (QName xmlType : getTypeMapping().getRegisteredXmlTypes())
/*     */       {
/*  66 */         String nsURI = xmlType.getNamespaceURI();
/*  67 */         if ((!"http://www.w3.org/2001/XMLSchema".equals(nsURI)) && (!"http://www.jboss.org/jbossws/attachment/mimetype".equals(nsURI)))
/*     */         {
/*  69 */           Class javaType = getTypeMapping().getJavaType(xmlType);
/*  70 */           String javaTypeName = javaType.getName();
/*     */ 
/*  72 */           Class componentType = javaType;
/*  73 */           while (componentType.isArray()) {
/*  74 */             componentType = componentType.getComponentType();
/*     */           }
/*  76 */           if (JavaUtils.isPrimitive(componentType)) {
/*  77 */             componentType = JavaUtils.getWrapperType(componentType);
/*     */           }
/*  79 */           Package packageObject = componentType.getPackage();
/*  80 */           String packageName = packageObject != null ? packageObject.getName() : "";
/*  81 */           String packageType = this.jaxrpcMapping.getPackageNameForNamespaceURI(nsURI);
/*  82 */           if (!packageName.equals(packageType))
/*     */           {
/*  84 */             PackageMapping packageMapping = new PackageMapping(this.jaxrpcMapping);
/*  85 */             packageMapping.setNamespaceURI(nsURI);
/*  86 */             packageMapping.setPackageType(packageName);
/*  87 */             this.jaxrpcMapping.addPackageMapping(packageMapping);
/*  88 */             if (log.isDebugEnabled()) {
/*  89 */               log.debug("Add package mapping: " + packageMapping);
/*     */             }
/*     */           }
/*     */ 
/*  93 */           if (javaType.isArray()) {
/*     */             continue;
/*     */           }
/*  96 */           JavaXmlTypeMapping xmlTypeMapping = this.jaxrpcMapping.getTypeMappingForQName(xmlType);
/*  97 */           if (xmlTypeMapping == null)
/*     */           {
/*  99 */             xmlTypeMapping = new JavaXmlTypeMapping(this.jaxrpcMapping);
/* 100 */             xmlTypeMapping.setQNameScope("complexType");
/* 101 */             xmlTypeMapping.setJavaType(javaTypeName);
/* 102 */             xmlTypeMapping.setRootTypeQName(xmlType);
/* 103 */             this.jaxrpcMapping.addJavaXmlTypeMappings(xmlTypeMapping);
/* 104 */             if (log.isDebugEnabled())
/* 105 */               log.debug("Add type mapping: " + xmlTypeMapping);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 110 */     return this.jaxrpcMapping;
/*     */   }
/*     */ 
/*     */   public void setJavaWsdlMapping(JavaWsdlMapping jaxrpcMapping)
/*     */   {
/* 115 */     this.jaxrpcMapping = jaxrpcMapping;
/*     */   }
/*     */ 
/*     */   public XSModel getXsModel()
/*     */   {
/* 120 */     SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
/* 121 */     if (msgContext == null) {
/* 122 */       throw new WSException("MessageContext not available");
/*     */     }
/* 124 */     OperationMetaData opMetaData = msgContext.getOperationMetaData();
/* 125 */     ServiceMetaData serviceMetaData = opMetaData.getEndpointMetaData().getServiceMetaData();
/* 126 */     TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
/* 127 */     return typesMetaData.getSchemaModel();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.SerializationContextJAXRPC
 * JD-Core Version:    0.6.0
 */