/*    */ package org.jboss.ws.core.jaxrpc;
/*    */ 
/*    */ import javax.xml.soap.MimeHeaders;
/*    */ import javax.xml.soap.SOAPMessage;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.jaxrpc.handler.MessageContextJAXRPC;
/*    */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*    */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*    */ 
/*    */ class SOAPBindingJAXRPC
/*    */ {
/* 45 */   private static Logger log = Logger.getLogger(SOAPBindingJAXRPC.class);
/*    */ 
/*    */   public void setSOAPActionHeader(OperationMetaData opMetaData, SOAPMessage reqMessage)
/*    */   {
/* 49 */     MessageContextJAXRPC msgContext = (MessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
/* 50 */     MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
/* 51 */     String soapAction = opMetaData.getSOAPAction();
/*    */ 
/* 62 */     if (msgContext.getProperty("javax.xml.rpc.soap.http.soapaction.use") != null) {
/* 63 */       log.info("Ignore Call.SOAPACTION_USE_PROPERTY because of BP-1.0 R2745, R2745");
/*    */     }
/* 65 */     String soapActionProperty = (String)msgContext.getProperty("javax.xml.rpc.soap.http.soapaction.uri");
/* 66 */     if (soapActionProperty != null) {
/* 67 */       soapAction = soapActionProperty;
/*    */     }
/* 69 */     mimeHeaders.addHeader("SOAPAction", soapAction != null ? soapAction : "");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.SOAPBindingJAXRPC
 * JD-Core Version:    0.6.0
 */