/*     */ package org.jboss.ws.core.binding;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.encoding.Serializer;
/*     */ import javax.xml.transform.Result;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.core.soap.SOAPContentElement;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public abstract class SerializerSupport
/*     */   implements Serializer
/*     */ {
/*     */   public Result serialize(SOAPContentElement soapElement, SerializationContext serContext)
/*     */     throws BindingException
/*     */   {
/*  53 */     QName xmlName = soapElement.getElementQName();
/*  54 */     QName xmlType = soapElement.getXmlType();
/*  55 */     NamedNodeMap attributes = soapElement.getAttributes();
/*  56 */     Object objectValue = soapElement.getObjectValue();
/*  57 */     return serialize(xmlName, xmlType, objectValue, serContext, attributes);
/*     */   }
/*     */ 
/*     */   public abstract Result serialize(QName paramQName1, QName paramQName2, Object paramObject, SerializationContext paramSerializationContext, NamedNodeMap paramNamedNodeMap)
/*     */     throws BindingException;
/*     */ 
/*     */   protected String wrapValueStr(QName xmlName, String valueStr, NamespaceRegistry nsRegistry, Set<String> nsExtras, NamedNodeMap attributes, boolean normalize)
/*     */   {
/*  74 */     String xmlNameURI = xmlName.getNamespaceURI();
/*  75 */     String localPart = xmlName.getLocalPart();
/*     */ 
/*  77 */     Map namespaces = new HashMap();
/*     */ 
/*  79 */     StringBuilder nsAttr = new StringBuilder("");
/*  80 */     if (attributes != null)
/*     */     {
/*  82 */       for (int i = 0; i < attributes.getLength(); i++)
/*     */       {
/*  84 */         Node attr = attributes.item(i);
/*  85 */         String attrName = attr.getNodeName();
/*  86 */         String attrValue = attr.getNodeValue();
/*  87 */         nsAttr.append(" " + attrName + "='" + attrValue + "'");
/*     */ 
/*  89 */         if (!attrName.startsWith("xmlns:"))
/*     */           continue;
/*  91 */         String prefix = attrName.substring(6);
/*  92 */         namespaces.put(attrValue, prefix);
/*     */       }
/*     */     }
/*     */     String elName;
/*  98 */     if (xmlNameURI.length() > 0)
/*     */     {
/* 100 */       xmlName = nsRegistry.registerQName(xmlName);
/* 101 */       String prefix = xmlName.getPrefix();
/* 102 */       String elName = prefix + ":" + localPart;
/* 103 */       if ((namespaces.get(xmlNameURI) == null) || (!prefix.equals(namespaces.get(xmlNameURI))))
/*     */       {
/* 105 */         nsAttr.append(" xmlns:" + prefix + "='" + xmlNameURI + "'");
/* 106 */         namespaces.put(xmlNameURI, prefix);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 111 */       elName = localPart;
/*     */     }
/*     */ 
/* 114 */     if (nsExtras != null)
/*     */     {
/* 116 */       for (String nsURI : nsExtras)
/*     */       {
/* 118 */         String prefix = nsRegistry.getPrefix(nsURI);
/* 119 */         if ((namespaces.get(nsURI) == null) || (!prefix.equals(namespaces.get(nsURI))))
/*     */         {
/* 121 */           nsAttr.append(" xmlns:" + prefix + "='" + nsURI + "'");
/* 122 */           namespaces.put(nsURI, prefix);
/*     */         }
/*     */       }
/*     */     }
/*     */     String xmlFragment;
/*     */     String xmlFragment;
/* 128 */     if (valueStr == null)
/*     */     {
/* 130 */       String xsins = "";
/* 131 */       if ((namespaces.get("http://www.w3.org/2001/XMLSchema-instance") == null) || (!"xsi".equals(namespaces.get(xmlNameURI))))
/*     */       {
/* 133 */         xsins = " xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'";
/* 134 */         namespaces.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
/*     */       }
/*     */ 
/* 137 */       xmlFragment = "<" + elName + nsAttr + " " + "xsi" + ":nil='1'" + xsins + "/>";
/*     */     }
/*     */     else
/*     */     {
/* 141 */       if (normalize) {
/* 142 */         valueStr = normalize(valueStr);
/*     */       }
/* 144 */       xmlFragment = "<" + elName + nsAttr + ">" + valueStr + "</" + elName + ">";
/*     */     }
/*     */ 
/* 147 */     return xmlFragment;
/*     */   }
/*     */ 
/*     */   public String getMechanismType()
/*     */   {
/* 152 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   private String normalize(String valueStr)
/*     */   {
/* 159 */     boolean found = false;
/* 160 */     int i = 0;
/*     */ 
/* 162 */     for (; i < valueStr.length(); i++)
/*     */     {
/* 164 */       switch (valueStr.charAt(i))
/*     */       {
/*     */       case '"':
/*     */       case '&':
/*     */       case '<':
/*     */       case '>':
/* 170 */         found = true;
/* 171 */         break label71;
/*     */       }
/*     */     }
/*     */ 
/* 175 */     label71: if (!found) {
/* 176 */       return valueStr;
/*     */     }
/*     */ 
/* 179 */     StringBuilder builder = new StringBuilder();
/* 180 */     builder.append(valueStr.substring(0, i));
/* 181 */     for (; i < valueStr.length(); i++)
/*     */     {
/* 183 */       char c = valueStr.charAt(i);
/* 184 */       switch (c)
/*     */       {
/*     */       case '<':
/* 187 */         builder.append("&lt;");
/* 188 */         break;
/*     */       case '>':
/* 190 */         builder.append("&gt;");
/* 191 */         break;
/*     */       case '&':
/* 193 */         builder.append("&amp;");
/* 194 */         break;
/*     */       case '"':
/* 196 */         builder.append("&quot;");
/* 197 */         break;
/*     */       default:
/* 199 */         builder.append(c);
/*     */       }
/*     */     }
/*     */ 
/* 203 */     return builder.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.binding.SerializerSupport
 * JD-Core Version:    0.6.0
 */