/*    */ package org.jboss.ws.core;
/*    */ 
/*    */ import java.util.Set;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.soap.SOAPEnvelope;
/*    */ import javax.xml.soap.SOAPException;
/*    */ import javax.xml.soap.SOAPHeaderElement;
/*    */ import javax.xml.soap.SOAPPart;
/*    */ import org.jboss.ws.Constants;
/*    */ import org.jboss.ws.core.soap.MessageFactoryImpl;
/*    */ import org.jboss.ws.core.soap.SOAPFaultImpl;
/*    */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*    */ import org.jboss.ws.core.soap.Use;
/*    */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*    */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*    */ 
/*    */ public abstract class CommonSOAP11Binding extends CommonSOAPBinding
/*    */ {
/*    */   private MessageFactoryImpl msgFactory;
/*    */ 
/*    */   public CommonSOAP11Binding()
/*    */   {
/* 52 */     this.msgFactory = new MessageFactoryImpl();
/* 53 */     this.msgFactory.setEnvNamespace("http://schemas.xmlsoap.org/soap/envelope/");
/*    */   }
/*    */ 
/*    */   protected MessageAbstraction createMessage(OperationMetaData opMetaData)
/*    */     throws SOAPException
/*    */   {
/* 59 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)this.msgFactory.createMessage();
/*    */ 
/* 61 */     Use encStyle = opMetaData.getEndpointMetaData().getEncodingStyle();
/* 62 */     if (Use.ENCODED.equals(encStyle))
/*    */     {
/* 64 */       SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
/* 65 */       soapEnvelope.addNamespaceDeclaration("soap11-enc", "http://schemas.xmlsoap.org/soap/encoding/");
/*    */     }
/*    */ 
/* 68 */     return soapMessage;
/*    */   }
/*    */ 
/*    */   public abstract Set<String> getRoles();
/*    */ 
/*    */   protected void verifyUnderstoodHeader(SOAPHeaderElement element) throws Exception
/*    */   {
/* 76 */     QName name = new QName(element.getNamespaceURI(), element.getLocalName());
/* 77 */     String actor = element.getActor();
/* 78 */     Set roles = getRoles();
/*    */ 
/* 80 */     boolean isActor = (actor == null) || (actor.length() == 0) || ("http://schemas.xmlsoap.org/soap/actor/next".equals(actor)) || (roles.contains(actor));
/* 81 */     if ((isActor) && (!this.headerSource.getHeaders().contains(name)))
/*    */     {
/* 83 */       QName faultCode = Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND;
/* 84 */       String faultString = "Unprocessed 'mustUnderstand' header element: " + element.getElementName();
/* 85 */       SOAPFaultImpl fault = new SOAPFaultImpl();
/* 86 */       fault.setFaultCode(faultCode);
/* 87 */       fault.setFaultString(faultString);
/* 88 */       throwFaultException(fault);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.CommonSOAP11Binding
 * JD-Core Version:    0.6.0
 */