/*     */ package org.jboss.web.deployers;
/*     */ 
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ import org.jboss.web.WebApplication;
/*     */ 
/*     */ public class WebModule
/*     */   implements WebModuleMBean
/*     */ {
/*  48 */   private static Logger log = Logger.getLogger(WebModule.class);
/*     */   private VFSDeploymentUnit di;
/*     */   private AbstractWarDeployer container;
/*     */   private AbstractWarDeployment deployment;
/*     */ 
/*     */   public WebModule(VFSDeploymentUnit di, AbstractWarDeployer container, AbstractWarDeployment deployment)
/*     */   {
/*  56 */     this.di = di;
/*  57 */     this.container = container;
/*  58 */     this.deployment = deployment;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  67 */     startModule();
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/*  72 */     stopModule();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  77 */     this.di = null;
/*  78 */     this.container = null;
/*  79 */     this.deployment = null;
/*     */   }
/*     */ 
/*     */   public synchronized void startModule()
/*     */     throws Exception
/*     */   {
/*  88 */     JBossWebMetaData metaData = (JBossWebMetaData)this.di.getAttachment(JBossWebMetaData.class);
/*  89 */     WebApplication webApp = this.deployment.start(this.di, metaData);
/*  90 */     String warURL = this.di.getName();
/*  91 */     this.container.addDeployedApp(warURL, webApp);
/*     */   }
/*     */ 
/*     */   public synchronized void stopModule()
/*     */     throws DeploymentException
/*     */   {
/*  99 */     String warURL = this.di.getName();
/*     */     try
/*     */     {
/* 102 */       WebApplication webApp = this.container.removeDeployedApp(warURL);
/* 103 */       if ((this.deployment != null) && (webApp != null))
/*     */       {
/* 105 */         this.deployment.stop(this.di, webApp);
/*     */       }
/*     */       else
/*     */       {
/* 109 */         log.debug("Failed to find deployer/deployment for war: " + warURL);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 114 */       throw new DeploymentException("Error during stop", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.web.deployers.WebModule
 * JD-Core Version:    0.6.0
 */