/*     */ package org.jboss.web;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.BufferedReader;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.BindException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.URL;
/*     */ import java.util.Properties;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.threadpool.BasicThreadPool;
/*     */ import org.jboss.util.threadpool.BasicThreadPoolMBean;
/*     */ import org.jboss.util.threadpool.ThreadPool;
/*     */ 
/*     */ public class WebServer
/*     */   implements Runnable
/*     */ {
/*  66 */   private static Logger log = Logger.getLogger(WebServer.class);
/*     */ 
/*  71 */   private int port = 8083;
/*     */   private InetAddress bindAddress;
/*  82 */   private int backlog = 50;
/*     */ 
/*  87 */   private final ConcurrentReaderHashMap loaderMap = new ConcurrentReaderHashMap();
/*     */ 
/*  92 */   private ServerSocket server = null;
/*     */ 
/*  99 */   private boolean downloadServerClasses = true;
/*     */ 
/* 105 */   private boolean downloadResources = false;
/*     */ 
/* 111 */   private static final Properties mimeTypes = new Properties();
/*     */   private BasicThreadPoolMBean threadPool;
/*     */ 
/*     */   public void setPort(int port)
/*     */   {
/* 125 */     this.port = port;
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/* 134 */     return this.port;
/*     */   }
/*     */ 
/*     */   public void setBindAddress(InetAddress bindAddress)
/*     */   {
/* 143 */     this.bindAddress = bindAddress;
/*     */   }
/*     */ 
/*     */   public InetAddress getBindAddress()
/*     */   {
/* 153 */     return this.bindAddress;
/*     */   }
/*     */ 
/*     */   public int getBacklog()
/*     */   {
/* 162 */     return this.backlog;
/*     */   }
/*     */ 
/*     */   public void setBacklog(int backlog)
/*     */   {
/* 170 */     if (backlog <= 0) {
/* 171 */       backlog = 50;
/*     */     }
/* 173 */     this.backlog = backlog;
/*     */   }
/*     */ 
/*     */   public boolean getDownloadServerClasses()
/*     */   {
/* 178 */     return this.downloadServerClasses;
/*     */   }
/*     */ 
/*     */   public void setDownloadServerClasses(boolean flag)
/*     */   {
/* 183 */     this.downloadServerClasses = flag;
/*     */   }
/*     */ 
/*     */   public boolean getDownloadResources()
/*     */   {
/* 188 */     return this.downloadResources;
/*     */   }
/*     */ 
/*     */   public void setDownloadResources(boolean flag)
/*     */   {
/* 193 */     this.downloadResources = flag;
/*     */   }
/*     */ 
/*     */   public BasicThreadPoolMBean getThreadPool()
/*     */   {
/* 198 */     return this.threadPool;
/*     */   }
/*     */ 
/*     */   public void setThreadPool(BasicThreadPoolMBean threadPool)
/*     */   {
/* 203 */     this.threadPool = threadPool;
/*     */   }
/*     */ 
/*     */   public void addMimeType(String extension, String type)
/*     */   {
/* 213 */     mimeTypes.put(extension, type);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 221 */     if (this.threadPool == null) {
/* 222 */       this.threadPool = new BasicThreadPool("ClassLoadingPool");
/*     */     }
/*     */     try
/*     */     {
/* 226 */       this.server = new ServerSocket(this.port, this.backlog, this.bindAddress);
/* 227 */       log.debug("Started server: " + this.server);
/*     */ 
/* 229 */       listen();
/*     */     }
/*     */     catch (BindException be)
/*     */     {
/* 233 */       throw new Exception("Port " + this.port + " already in use.", be);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 237 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */     try
/*     */     {
/* 248 */       ServerSocket srv = this.server;
/* 249 */       this.server = null;
/* 250 */       srv.close();
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public URL addClassLoader(ClassLoader cl)
/*     */   {
/* 269 */     String key = (cl instanceof WebClassLoader) ? ((WebClassLoader)cl).getKey() : getClassLoaderKey(cl);
/*     */ 
/* 272 */     this.loaderMap.put(key, cl);
/* 273 */     URL loaderURL = null;
/* 274 */     String codebase = System.getProperty("java.rmi.server.codebase");
/* 275 */     if (codebase != null)
/*     */     {
/* 277 */       if (!codebase.endsWith("/"))
/* 278 */         codebase = codebase + '/';
/* 279 */       codebase = codebase + key;
/* 280 */       codebase = codebase + '/';
/*     */       try
/*     */       {
/* 283 */         loaderURL = new URL(codebase);
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 287 */         log.error("invalid url", e);
/*     */       }
/*     */     }
/* 290 */     log.trace("Added ClassLoader: " + cl + " URL: " + loaderURL);
/* 291 */     return loaderURL;
/*     */   }
/*     */ 
/*     */   public void removeClassLoader(ClassLoader cl)
/*     */   {
/* 300 */     String key = getClassLoaderKey(cl);
/* 301 */     this.loaderMap.remove(key); } 
/*     */   // ERROR //
/*     */   public void run() { // Byte code:
/*     */     //   0: aload_0
/*     */     //   1: getfield 7	org/jboss/web/WebServer:server	Ljava/net/ServerSocket;
/*     */     //   4: ifnonnull +4 -> 8
/*     */     //   7: return
/*     */     //   8: aconst_null
/*     */     //   9: astore_1
/*     */     //   10: aload_0
/*     */     //   11: getfield 7	org/jboss/web/WebServer:server	Ljava/net/ServerSocket;
/*     */     //   14: invokevirtual 54	java/net/ServerSocket:accept	()Ljava/net/Socket;
/*     */     //   17: astore_1
/*     */     //   18: goto +21 -> 39
/*     */     //   21: astore_2
/*     */     //   22: aload_0
/*     */     //   23: getfield 7	org/jboss/web/WebServer:server	Ljava/net/ServerSocket;
/*     */     //   26: ifnull +12 -> 38
/*     */     //   29: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   32: ldc 55
/*     */     //   34: aload_2
/*     */     //   35: invokevirtual 49	org/jboss/logging/Logger:error	(Ljava/lang/Object;Ljava/lang/Throwable;)V
/*     */     //   38: return
/*     */     //   39: aload_0
/*     */     //   40: invokevirtual 27	org/jboss/web/WebServer:listen	()V
/*     */     //   43: new 56	java/io/DataOutputStream
/*     */     //   46: dup
/*     */     //   47: aload_1
/*     */     //   48: invokevirtual 57	java/net/Socket:getOutputStream	()Ljava/io/OutputStream;
/*     */     //   51: invokespecial 58	java/io/DataOutputStream:<init>	(Ljava/io/OutputStream;)V
/*     */     //   54: astore_2
/*     */     //   55: ldc 59
/*     */     //   57: astore_3
/*     */     //   58: new 60	java/io/BufferedReader
/*     */     //   61: dup
/*     */     //   62: new 61	java/io/InputStreamReader
/*     */     //   65: dup
/*     */     //   66: aload_1
/*     */     //   67: invokevirtual 62	java/net/Socket:getInputStream	()Ljava/io/InputStream;
/*     */     //   70: invokespecial 63	java/io/InputStreamReader:<init>	(Ljava/io/InputStream;)V
/*     */     //   73: invokespecial 64	java/io/BufferedReader:<init>	(Ljava/io/Reader;)V
/*     */     //   76: astore 4
/*     */     //   78: aload_0
/*     */     //   79: aload 4
/*     */     //   81: invokevirtual 65	org/jboss/web/WebServer:getPath	(Ljava/io/BufferedReader;)Ljava/lang/String;
/*     */     //   84: astore 5
/*     */     //   86: aload 5
/*     */     //   88: bipush 93
/*     */     //   90: invokevirtual 66	java/lang/String:indexOf	(I)I
/*     */     //   93: istore 6
/*     */     //   95: aload 5
/*     */     //   97: iload 6
/*     */     //   99: iconst_2
/*     */     //   100: iadd
/*     */     //   101: invokevirtual 67	java/lang/String:substring	(I)Ljava/lang/String;
/*     */     //   104: astore 7
/*     */     //   106: aload 5
/*     */     //   108: iconst_0
/*     */     //   109: iload 6
/*     */     //   111: iconst_1
/*     */     //   112: iadd
/*     */     //   113: invokevirtual 68	java/lang/String:substring	(II)Ljava/lang/String;
/*     */     //   116: astore 8
/*     */     //   118: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   121: new 20	java/lang/StringBuilder
/*     */     //   124: dup
/*     */     //   125: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   128: ldc 69
/*     */     //   130: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   133: aload 8
/*     */     //   135: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   138: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   141: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   144: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   147: new 20	java/lang/StringBuilder
/*     */     //   150: dup
/*     */     //   151: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   154: ldc 70
/*     */     //   156: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   159: aload 7
/*     */     //   161: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   164: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   167: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   170: aload_0
/*     */     //   171: getfield 6	org/jboss/web/WebServer:loaderMap	LEDU/oswego/cs/dl/util/concurrent/ConcurrentReaderHashMap;
/*     */     //   174: aload 8
/*     */     //   176: invokevirtual 71	EDU/oswego/cs/dl/util/concurrent/ConcurrentReaderHashMap:get	(Ljava/lang/Object;)Ljava/lang/Object;
/*     */     //   179: checkcast 72	java/lang/ClassLoader
/*     */     //   182: astore 9
/*     */     //   184: aload 9
/*     */     //   186: ifnonnull +58 -> 244
/*     */     //   189: aload 5
/*     */     //   191: bipush 91
/*     */     //   193: invokevirtual 66	java/lang/String:indexOf	(I)I
/*     */     //   196: ifge +48 -> 244
/*     */     //   199: aload_0
/*     */     //   200: getfield 8	org/jboss/web/WebServer:downloadServerClasses	Z
/*     */     //   203: ifeq +41 -> 244
/*     */     //   206: aload 5
/*     */     //   208: astore 7
/*     */     //   210: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   213: new 20	java/lang/StringBuilder
/*     */     //   216: dup
/*     */     //   217: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   220: ldc 73
/*     */     //   222: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   225: aload 7
/*     */     //   227: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   230: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   233: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   236: invokestatic 74	java/lang/Thread:currentThread	()Ljava/lang/Thread;
/*     */     //   239: invokevirtual 75	java/lang/Thread:getContextClassLoader	()Ljava/lang/ClassLoader;
/*     */     //   242: astore 9
/*     */     //   244: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   247: new 20	java/lang/StringBuilder
/*     */     //   250: dup
/*     */     //   251: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   254: ldc 76
/*     */     //   256: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   259: aload 9
/*     */     //   261: invokevirtual 24	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   264: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   267: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   270: iconst_0
/*     */     //   271: newarray byte
/*     */     //   273: astore 10
/*     */     //   275: aload 9
/*     */     //   277: ifnull +281 -> 558
/*     */     //   280: aload 7
/*     */     //   282: ldc 77
/*     */     //   284: invokevirtual 43	java/lang/String:endsWith	(Ljava/lang/String;)Z
/*     */     //   287: ifeq +271 -> 558
/*     */     //   290: aload 7
/*     */     //   292: iconst_0
/*     */     //   293: aload 7
/*     */     //   295: invokevirtual 78	java/lang/String:length	()I
/*     */     //   298: bipush 6
/*     */     //   300: isub
/*     */     //   301: invokevirtual 68	java/lang/String:substring	(II)Ljava/lang/String;
/*     */     //   304: bipush 47
/*     */     //   306: bipush 46
/*     */     //   308: invokevirtual 79	java/lang/String:replace	(CC)Ljava/lang/String;
/*     */     //   311: astore 11
/*     */     //   313: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   316: new 20	java/lang/StringBuilder
/*     */     //   319: dup
/*     */     //   320: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   323: ldc 80
/*     */     //   325: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   328: aload 11
/*     */     //   330: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   333: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   336: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   339: aload 9
/*     */     //   341: aload 11
/*     */     //   343: invokevirtual 81	java/lang/ClassLoader:loadClass	(Ljava/lang/String;)Ljava/lang/Class;
/*     */     //   346: astore 12
/*     */     //   348: aload 12
/*     */     //   350: invokevirtual 82	java/lang/Class:getProtectionDomain	()Ljava/security/ProtectionDomain;
/*     */     //   353: invokevirtual 83	java/security/ProtectionDomain:getCodeSource	()Ljava/security/CodeSource;
/*     */     //   356: invokevirtual 84	java/security/CodeSource:getLocation	()Ljava/net/URL;
/*     */     //   359: astore 13
/*     */     //   361: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   364: new 20	java/lang/StringBuilder
/*     */     //   367: dup
/*     */     //   368: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   371: ldc 85
/*     */     //   373: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   376: aload 13
/*     */     //   378: invokevirtual 24	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   381: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   384: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   387: aload 13
/*     */     //   389: ifnonnull +51 -> 440
/*     */     //   392: aload 12
/*     */     //   394: invokevirtual 86	java/lang/Class:getClassLoader	()Ljava/lang/ClassLoader;
/*     */     //   397: checkcast 36	org/jboss/web/WebClassLoader
/*     */     //   400: aload 12
/*     */     //   402: invokevirtual 87	org/jboss/web/WebClassLoader:getBytes	(Ljava/lang/Class;)[B
/*     */     //   405: astore 10
/*     */     //   407: aload 10
/*     */     //   409: ifnonnull +146 -> 555
/*     */     //   412: new 29	java/lang/Exception
/*     */     //   415: dup
/*     */     //   416: new 20	java/lang/StringBuilder
/*     */     //   419: dup
/*     */     //   420: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   423: ldc 88
/*     */     //   425: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   428: aload 11
/*     */     //   430: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   433: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   436: invokespecial 89	java/lang/Exception:<init>	(Ljava/lang/String;)V
/*     */     //   439: athrow
/*     */     //   440: aload 13
/*     */     //   442: invokevirtual 90	java/net/URL:getFile	()Ljava/lang/String;
/*     */     //   445: ldc 42
/*     */     //   447: invokevirtual 43	java/lang/String:endsWith	(Ljava/lang/String;)Z
/*     */     //   450: ifne +45 -> 495
/*     */     //   453: new 45	java/net/URL
/*     */     //   456: dup
/*     */     //   457: new 20	java/lang/StringBuilder
/*     */     //   460: dup
/*     */     //   461: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   464: ldc 91
/*     */     //   466: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   469: aload 13
/*     */     //   471: invokevirtual 24	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   474: ldc 92
/*     */     //   476: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   479: aload 7
/*     */     //   481: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   484: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   487: invokespecial 46	java/net/URL:<init>	(Ljava/lang/String;)V
/*     */     //   490: astore 13
/*     */     //   492: goto +29 -> 521
/*     */     //   495: aload 13
/*     */     //   497: invokevirtual 90	java/net/URL:getFile	()Ljava/lang/String;
/*     */     //   500: ldc 93
/*     */     //   502: invokevirtual 94	java/lang/String:indexOf	(Ljava/lang/String;)I
/*     */     //   505: ifge +16 -> 521
/*     */     //   508: new 45	java/net/URL
/*     */     //   511: dup
/*     */     //   512: aload 13
/*     */     //   514: aload 7
/*     */     //   516: invokespecial 95	java/net/URL:<init>	(Ljava/net/URL;Ljava/lang/String;)V
/*     */     //   519: astore 13
/*     */     //   521: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   524: new 20	java/lang/StringBuilder
/*     */     //   527: dup
/*     */     //   528: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   531: ldc 96
/*     */     //   533: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   536: aload 13
/*     */     //   538: invokevirtual 24	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   541: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   544: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   547: aload_0
/*     */     //   548: aload 13
/*     */     //   550: invokevirtual 97	org/jboss/web/WebServer:getBytes	(Ljava/net/URL;)[B
/*     */     //   553: astore 10
/*     */     //   555: goto +134 -> 689
/*     */     //   558: aload 9
/*     */     //   560: ifnull +126 -> 686
/*     */     //   563: aload 7
/*     */     //   565: invokevirtual 78	java/lang/String:length	()I
/*     */     //   568: ifle +118 -> 686
/*     */     //   571: aload_0
/*     */     //   572: getfield 8	org/jboss/web/WebServer:downloadServerClasses	Z
/*     */     //   575: ifeq +111 -> 686
/*     */     //   578: aload_0
/*     */     //   579: getfield 9	org/jboss/web/WebServer:downloadResources	Z
/*     */     //   582: ifeq +104 -> 686
/*     */     //   585: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   588: new 20	java/lang/StringBuilder
/*     */     //   591: dup
/*     */     //   592: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   595: ldc 98
/*     */     //   597: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   600: aload 7
/*     */     //   602: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   605: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   608: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   611: aload 9
/*     */     //   613: aload 7
/*     */     //   615: invokevirtual 99	java/lang/ClassLoader:getResource	(Ljava/lang/String;)Ljava/net/URL;
/*     */     //   618: astore 11
/*     */     //   620: aload 11
/*     */     //   622: ifnonnull +27 -> 649
/*     */     //   625: new 20	java/lang/StringBuilder
/*     */     //   628: dup
/*     */     //   629: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   632: ldc 100
/*     */     //   634: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   637: aload 7
/*     */     //   639: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   642: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   645: astore_3
/*     */     //   646: goto +37 -> 683
/*     */     //   649: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   652: new 20	java/lang/StringBuilder
/*     */     //   655: dup
/*     */     //   656: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   659: ldc 101
/*     */     //   661: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   664: aload 11
/*     */     //   666: invokevirtual 24	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   669: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   672: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   675: aload_0
/*     */     //   676: aload 11
/*     */     //   678: invokevirtual 97	org/jboss/web/WebServer:getBytes	(Ljava/net/URL;)[B
/*     */     //   681: astore 10
/*     */     //   683: goto +6 -> 689
/*     */     //   686: ldc 102
/*     */     //   688: astore_3
/*     */     //   689: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   692: new 20	java/lang/StringBuilder
/*     */     //   695: dup
/*     */     //   696: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   699: ldc 103
/*     */     //   701: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   704: aload_3
/*     */     //   705: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   708: ldc 104
/*     */     //   710: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   713: aload 10
/*     */     //   715: arraylength
/*     */     //   716: invokevirtual 31	java/lang/StringBuilder:append	(I)Ljava/lang/StringBuilder;
/*     */     //   719: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   722: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   725: aload_2
/*     */     //   726: new 20	java/lang/StringBuilder
/*     */     //   729: dup
/*     */     //   730: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   733: ldc 105
/*     */     //   735: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   738: aload_3
/*     */     //   739: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   742: ldc 106
/*     */     //   744: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   747: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   750: invokevirtual 107	java/io/DataOutputStream:writeBytes	(Ljava/lang/String;)V
/*     */     //   753: aload_2
/*     */     //   754: new 20	java/lang/StringBuilder
/*     */     //   757: dup
/*     */     //   758: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   761: ldc 108
/*     */     //   763: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   766: aload 10
/*     */     //   768: arraylength
/*     */     //   769: invokevirtual 31	java/lang/StringBuilder:append	(I)Ljava/lang/StringBuilder;
/*     */     //   772: ldc 106
/*     */     //   774: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   777: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   780: invokevirtual 107	java/io/DataOutputStream:writeBytes	(Ljava/lang/String;)V
/*     */     //   783: aload_2
/*     */     //   784: new 20	java/lang/StringBuilder
/*     */     //   787: dup
/*     */     //   788: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   791: ldc 109
/*     */     //   793: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   796: aload_0
/*     */     //   797: aload 7
/*     */     //   799: invokevirtual 110	org/jboss/web/WebServer:getMimeType	(Ljava/lang/String;)Ljava/lang/String;
/*     */     //   802: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   805: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   808: invokevirtual 107	java/io/DataOutputStream:writeBytes	(Ljava/lang/String;)V
/*     */     //   811: aload_2
/*     */     //   812: ldc 111
/*     */     //   814: invokevirtual 107	java/io/DataOutputStream:writeBytes	(Ljava/lang/String;)V
/*     */     //   817: aload_2
/*     */     //   818: aload 10
/*     */     //   820: invokevirtual 112	java/io/DataOutputStream:write	([B)V
/*     */     //   823: aload_2
/*     */     //   824: invokevirtual 113	java/io/DataOutputStream:flush	()V
/*     */     //   827: goto +9 -> 836
/*     */     //   830: astore 11
/*     */     //   832: jsr +87 -> 919
/*     */     //   835: return
/*     */     //   836: goto +53 -> 889
/*     */     //   839: astore_3
/*     */     //   840: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   843: new 20	java/lang/StringBuilder
/*     */     //   846: dup
/*     */     //   847: invokespecial 21	java/lang/StringBuilder:<init>	()V
/*     */     //   850: ldc 115
/*     */     //   852: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   855: aload_3
/*     */     //   856: invokevirtual 116	java/lang/Throwable:getMessage	()Ljava/lang/String;
/*     */     //   859: invokevirtual 23	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   862: invokevirtual 25	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   865: invokevirtual 52	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   868: aload_2
/*     */     //   869: ldc 117
/*     */     //   871: invokevirtual 107	java/io/DataOutputStream:writeBytes	(Ljava/lang/String;)V
/*     */     //   874: aload_2
/*     */     //   875: ldc 118
/*     */     //   877: invokevirtual 107	java/io/DataOutputStream:writeBytes	(Ljava/lang/String;)V
/*     */     //   880: aload_2
/*     */     //   881: invokevirtual 113	java/io/DataOutputStream:flush	()V
/*     */     //   884: goto +5 -> 889
/*     */     //   887: astore 4
/*     */     //   889: jsr +30 -> 919
/*     */     //   892: goto +40 -> 932
/*     */     //   895: astore_2
/*     */     //   896: getstatic 19	org/jboss/web/WebServer:log	Lorg/jboss/logging/Logger;
/*     */     //   899: ldc 119
/*     */     //   901: aload_2
/*     */     //   902: invokevirtual 49	org/jboss/logging/Logger:error	(Ljava/lang/Object;Ljava/lang/Throwable;)V
/*     */     //   905: jsr +14 -> 919
/*     */     //   908: goto +24 -> 932
/*     */     //   911: astore 14
/*     */     //   913: jsr +6 -> 919
/*     */     //   916: aload 14
/*     */     //   918: athrow
/*     */     //   919: astore 15
/*     */     //   921: aload_1
/*     */     //   922: invokevirtual 120	java/net/Socket:close	()V
/*     */     //   925: goto +5 -> 930
/*     */     //   928: astore 16
/*     */     //   930: ret 15
/*     */     //   932: return
/*     */     //
/*     */     // Exception table:
/*     */     //   from	to	target	type
/*     */     //   10	18	21	java/io/IOException
/*     */     //   689	827	830	java/io/IOException
/*     */     //   55	832	839	java/lang/Throwable
/*     */     //   840	884	887	java/io/IOException
/*     */     //   43	835	895	java/io/IOException
/*     */     //   836	889	895	java/io/IOException
/*     */     //   43	835	911	finally
/*     */     //   836	892	911	finally
/*     */     //   895	908	911	finally
/*     */     //   911	916	911	finally
/*     */     //   921	925	928	java/io/IOException } 
/* 485 */   protected String getClassLoaderKey(ClassLoader cl) { String className = cl.getClass().getName();
/* 486 */     int dot = className.lastIndexOf('.');
/* 487 */     if (dot >= 0)
/* 488 */       className = className.substring(dot + 1);
/* 489 */     String key = className + '[' + cl.hashCode() + ']';
/* 490 */     return key;
/*     */   }
/*     */ 
/*     */   protected void listen()
/*     */   {
/* 495 */     this.threadPool.getInstance().run(this);
/*     */   }
/*     */ 
/*     */   protected String getPath(BufferedReader in)
/*     */     throws IOException
/*     */   {
/* 503 */     String line = in.readLine();
/* 504 */     log.trace("raw request=" + line);
/*     */ 
/* 506 */     int start = line.indexOf(' ') + 1;
/* 507 */     int end = line.indexOf(' ', start + 1);
/*     */ 
/* 509 */     String filePath = line.substring(start + 1, end);
/* 510 */     return filePath;
/*     */   }
/*     */ 
/*     */   protected byte[] getBytes(URL url)
/*     */     throws IOException
/*     */   {
/* 518 */     InputStream in = new BufferedInputStream(url.openStream());
/* 519 */     log.debug("Retrieving " + url);
/* 520 */     ByteArrayOutputStream out = new ByteArrayOutputStream();
/* 521 */     byte[] tmp = new byte[1024];
/*     */     int bytes;
/* 523 */     while ((bytes = in.read(tmp)) != -1)
/*     */     {
/* 525 */       out.write(tmp, 0, bytes);
/*     */     }
/* 527 */     in.close();
/* 528 */     return out.toByteArray();
/*     */   }
/*     */ 
/*     */   protected String getMimeType(String path)
/*     */   {
/* 537 */     int dot = path.lastIndexOf(".");
/* 538 */     String type = "text/html";
/* 539 */     if (dot >= 0)
/*     */     {
/* 542 */       String suffix = path.substring(dot + 1);
/* 543 */       String mimeType = mimeTypes.getProperty(suffix);
/* 544 */       if (mimeType != null)
/* 545 */         type = mimeType;
/*     */     }
/* 547 */     return type;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.web.WebServer
 * JD-Core Version:    0.6.0
 */