package org.jboss.virtual.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.jboss.virtual.VirtualFile;

public abstract interface VirtualFileHandler extends Serializable
{
  public abstract String getName();

  public abstract String getPathName();

  public abstract URL toVfsUrl()
    throws MalformedURLException, URISyntaxException;

  public abstract URI toURI()
    throws URISyntaxException;

  public abstract URL toURL()
    throws MalformedURLException, URISyntaxException;

  public abstract long getLastModified()
    throws IOException;

  public abstract boolean hasBeenModified()
    throws IOException;

  public abstract long getSize()
    throws IOException;

  public abstract boolean exists()
    throws IOException;

  public abstract boolean isLeaf()
    throws IOException;

  public abstract boolean isHidden()
    throws IOException;

  public abstract InputStream openStream()
    throws IOException;

  public abstract VirtualFileHandler getParent()
    throws IOException;

  public abstract List<VirtualFileHandler> getChildren(boolean paramBoolean)
    throws IOException;

  public abstract VirtualFileHandler findChild(String paramString)
    throws IOException;

  public abstract VFSContext getVFSContext();

  public abstract VirtualFile getVirtualFile();

  public abstract void close();
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.spi.VirtualFileHandler
 * JD-Core Version:    0.6.0
 */