/*     */ package org.jboss.virtual.spi;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.net.URI;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.file.ArchiveBrowser;
/*     */ import org.jboss.virtual.plugins.context.VfsArchiveBrowserFactory;
/*     */ import org.jboss.virtual.plugins.context.file.FileSystemContextFactory;
/*     */ import org.jboss.virtual.plugins.context.jar.JarContextFactory;
/*     */ import org.jboss.virtual.plugins.context.memory.MemoryContextFactory;
/*     */ 
/*     */ public class VFSContextFactoryLocator
/*     */ {
/*  56 */   private static final Logger log = Logger.getLogger(VFSContextFactoryLocator.class);
/*     */ 
/*  59 */   private static final Map<String, VFSContextFactory> factoryByProtocol = new ConcurrentHashMap();
/*     */ 
/*  62 */   public static final String DEFAULT_FACTORY_PROPERTY = VFSContextFactory.class.getName();
/*     */ 
/*  65 */   public static final String SERVICES_PATH = "META-INF/services/" + VFSContextFactory.class.getName();
/*     */   private static boolean initialized;
/*     */ 
/*     */   public static synchronized void registerFactory(VFSContextFactory factory)
/*     */   {
/*  98 */     if (factory == null) {
/*  99 */       throw new IllegalArgumentException("Null VFSContextFactory");
/*     */     }
/* 101 */     String[] protocols = factory.getProtocols();
/* 102 */     if ((protocols == null) || (protocols.length == 0)) {
/* 103 */       throw new IllegalArgumentException("VFSContextFactory trying to register null or no protocols: " + factory);
/*     */     }
/* 105 */     for (String protocol : protocols)
/*     */     {
/* 107 */       if (protocol == null)
/* 108 */         throw new IllegalArgumentException("VFSContextFactory try to register a null protocol: " + factory + " protocols=" + Arrays.asList(protocols));
/* 109 */       VFSContextFactory other = (VFSContextFactory)factoryByProtocol.get(protocol);
/* 110 */       if (other != null) {
/* 111 */         throw new IllegalStateException("VFSContextFactory: " + other + " already registered for protocol: " + protocol);
/*     */       }
/*     */     }
/* 114 */     boolean trace = log.isTraceEnabled();
/* 115 */     for (String protocol : protocols)
/*     */     {
/* 117 */       factoryByProtocol.put(protocol, factory);
/* 118 */       if (trace)
/* 119 */         log.trace("Registered " + factory + " for protocol: " + protocol);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static synchronized boolean unregisterFactory(VFSContextFactory factory)
/*     */   {
/* 132 */     if (factory == null) {
/* 133 */       throw new IllegalArgumentException("Null VFSContextFactory");
/*     */     }
/* 135 */     ArrayList protocols = new ArrayList();
/* 136 */     for (Map.Entry entry : factoryByProtocol.entrySet())
/*     */     {
/* 138 */       if (factory == entry.getValue()) {
/* 139 */         protocols.add(entry.getKey());
/*     */       }
/*     */     }
/* 142 */     boolean trace = log.isTraceEnabled();
/* 143 */     for (String protocol : protocols)
/*     */     {
/* 145 */       factoryByProtocol.remove(protocol);
/* 146 */       if (trace) {
/* 147 */         log.trace("Unregistered " + factory + " for protocol: " + protocol);
/*     */       }
/*     */     }
/* 150 */     return !protocols.isEmpty();
/*     */   }
/*     */ 
/*     */   public static VFSContextFactory getFactory(URL rootURL)
/*     */   {
/* 163 */     if (rootURL == null) {
/* 164 */       throw new IllegalArgumentException("Null rootURL");
/*     */     }
/* 166 */     init();
/* 167 */     String protocol = rootURL.getProtocol();
/* 168 */     return (VFSContextFactory)factoryByProtocol.get(protocol);
/*     */   }
/*     */ 
/*     */   public static VFSContextFactory getFactory(URI rootURI)
/*     */   {
/* 180 */     if (rootURI == null) {
/* 181 */       throw new IllegalArgumentException("Null rootURI");
/*     */     }
/* 183 */     init();
/* 184 */     String scheme = rootURI.getScheme();
/* 185 */     return (VFSContextFactory)factoryByProtocol.get(scheme);
/*     */   }
/*     */ 
/*     */   private static synchronized void init()
/*     */   {
/* 201 */     if (initialized) {
/* 202 */       return;
/*     */     }
/*     */ 
/* 205 */     ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new GetContextClassLoader(null));
/* 206 */     Enumeration urls = (Enumeration)AccessController.doPrivileged(new EnumerateServices(null));
/* 207 */     if (urls != null)
/*     */     {
/* 209 */       while (urls.hasMoreElements())
/*     */       {
/* 211 */         URL url = (URL)urls.nextElement();
/*     */ 
/* 213 */         VFSContextFactory[] factories = loadFactories(url, loader);
/* 214 */         for (VFSContextFactory factory : factories)
/*     */         {
/*     */           try
/*     */           {
/* 218 */             registerFactory(factory);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 222 */             log.warn("Error registering factory from " + url, e);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 228 */     String defaultFactoryNames = (String)AccessController.doPrivileged(new GetDefaultFactories(null));
/* 229 */     if (defaultFactoryNames != null)
/*     */     {
/* 231 */       StringTokenizer tokenizer = new StringTokenizer(defaultFactoryNames, ",");
/* 232 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 234 */         String factoryName = tokenizer.nextToken();
/* 235 */         VFSContextFactory factory = createVFSContextFactory(loader, factoryName, " from system property.");
/* 236 */         if (factory != null) {
/* 237 */           registerFactory(factory);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 242 */     if (!factoryByProtocol.containsKey("file")) {
/* 243 */       registerFactory(new FileSystemContextFactory());
/*     */     }
/*     */ 
/* 246 */     if (!factoryByProtocol.containsKey("jar")) {
/* 247 */       registerFactory(new JarContextFactory());
/*     */     }
/* 249 */     if (!factoryByProtocol.containsKey("vfsmemory")) {
/* 250 */       registerFactory(MemoryContextFactory.getInstance());
/*     */     }
/* 252 */     initialized = true;
/*     */   }
/*     */ 
/*     */   private static VFSContextFactory[] loadFactories(URL serviceURL, ClassLoader loader)
/*     */   {
/* 265 */     ArrayList temp = new ArrayList();
/*     */     try
/*     */     {
/* 268 */       InputStream is = serviceURL.openStream();
/*     */       try
/*     */       {
/* 271 */         BufferedReader br = new BufferedReader(new InputStreamReader(is));
/*     */         String line;
/* 273 */         while ((line = br.readLine()) != null)
/*     */         {
/* 275 */           if (line.startsWith("#") == true)
/*     */             continue;
/* 277 */           String[] classes = line.split("\\s+|#.*");
/* 278 */           for (int n = 0; n < classes.length; n++)
/*     */           {
/* 280 */             String name = classes[n];
/* 281 */             if (name.length() == 0)
/*     */               continue;
/* 283 */             VFSContextFactory factory = createVFSContextFactory(loader, name, " defined in " + serviceURL);
/* 284 */             if (factory != null)
/* 285 */               temp.add(factory);
/*     */           }
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 291 */         is.close();
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 296 */       log.warn("Error parsing " + serviceURL, e);
/*     */     }
/*     */ 
/* 299 */     VFSContextFactory[] factories = new VFSContextFactory[temp.size()];
/* 300 */     return (VFSContextFactory[])temp.toArray(factories);
/*     */   }
/*     */ 
/*     */   private static VFSContextFactory createVFSContextFactory(ClassLoader cl, String className, String context)
/*     */   {
/*     */     try
/*     */     {
/* 314 */       Class factoryClass = cl.loadClass(className);
/* 315 */       return (VFSContextFactory)factoryClass.newInstance();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 319 */       log.warn("Error creating VFSContextFactory " + className + " " + context, e);
/* 320 */     }return null;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  72 */     String pkgs = System.getProperty("java.protocol.handler.pkgs");
/*  73 */     if ((pkgs == null) || (pkgs.trim().length() == 0))
/*     */     {
/*  75 */       pkgs = "org.jboss.virtual.protocol";
/*  76 */       System.setProperty("java.protocol.handler.pkgs", pkgs);
/*     */     }
/*  78 */     else if (!pkgs.contains("org.jboss.virtual.protocol"))
/*     */     {
/*  80 */       pkgs = pkgs + "|org.jboss.virtual.protocol";
/*  81 */       System.setProperty("java.protocol.handler.pkgs", pkgs);
/*     */     }
/*     */ 
/*  84 */     ArchiveBrowser.factoryFinder.put("vfsfile", new VfsArchiveBrowserFactory());
/*     */   }
/*     */ 
/*     */   private static class EnumerateServices
/*     */     implements PrivilegedAction<Enumeration<URL>>
/*     */   {
/*     */     public Enumeration<URL> run()
/*     */     {
/* 353 */       ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*     */       try
/*     */       {
/* 356 */         return cl.getResources(VFSContextFactoryLocator.SERVICES_PATH);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 360 */         VFSContextFactoryLocator.log.warn("Error retrieving " + VFSContextFactoryLocator.SERVICES_PATH, e);
/* 361 */       }return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetDefaultFactories
/*     */     implements PrivilegedAction<String>
/*     */   {
/*     */     public String run()
/*     */     {
/* 342 */       return System.getProperty(VFSContextFactoryLocator.DEFAULT_FACTORY_PROPERTY);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetContextClassLoader
/*     */     implements PrivilegedAction<ClassLoader>
/*     */   {
/*     */     public ClassLoader run()
/*     */     {
/* 331 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.spi.VFSContextFactoryLocator
 * JD-Core Version:    0.6.0
 */