/*     */ package org.jboss.virtual.plugins.context.vfs;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ @Assembled
/*     */ public class AssembledFileHandler extends AbstractVirtualFileHandler
/*     */ {
/*     */   private VirtualFileHandler delegate;
/*     */ 
/*     */   public AssembledFileHandler(AssembledContext context, AssembledDirectoryHandler parent, String name, VirtualFileHandler delegate)
/*     */     throws IOException
/*     */   {
/*  48 */     super(context, parent, name);
/*  49 */     this.delegate = delegate;
/*  50 */     this.vfsUrl = new URL("vfs", context.getName(), -1, getPathName(), new AssembledUrlStreamHandler(context));
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors)
/*     */     throws IOException
/*     */   {
/*  56 */     throw new IOException("File cannot have children: " + this);
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path) throws IOException
/*     */   {
/*  61 */     throw new IOException("File cannot have children: " + this);
/*     */   }
/*     */ 
/*     */   public URL toURL()
/*     */     throws MalformedURLException, URISyntaxException
/*     */   {
/*  67 */     return this.delegate.toURL();
/*     */   }
/*     */ 
/*     */   public long getLastModified()
/*     */     throws IOException
/*     */   {
/*  73 */     return this.delegate.getLastModified();
/*     */   }
/*     */ 
/*     */   public boolean hasBeenModified()
/*     */     throws IOException
/*     */   {
/*  79 */     return this.delegate.hasBeenModified();
/*     */   }
/*     */ 
/*     */   public long getSize()
/*     */     throws IOException
/*     */   {
/*  85 */     return this.delegate.getSize();
/*     */   }
/*     */ 
/*     */   public boolean exists()
/*     */     throws IOException
/*     */   {
/*  91 */     return this.delegate.exists();
/*     */   }
/*     */ 
/*     */   public boolean isLeaf()
/*     */     throws IOException
/*     */   {
/*  97 */     return this.delegate.isLeaf();
/*     */   }
/*     */ 
/*     */   public boolean isHidden()
/*     */     throws IOException
/*     */   {
/* 103 */     return this.delegate.isHidden();
/*     */   }
/*     */ 
/*     */   public InputStream openStream()
/*     */     throws IOException
/*     */   {
/* 109 */     return this.delegate.openStream();
/*     */   }
/*     */ 
/*     */   public URI toURI()
/*     */     throws URISyntaxException
/*     */   {
/* 115 */     return this.delegate.toURI();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.vfs.AssembledFileHandler
 * JD-Core Version:    0.6.0
 */