/*     */ package org.jboss.virtual.plugins.context.memory;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.plugins.context.AbstractVFSContext;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class MemoryContext extends AbstractVFSContext
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private final MemoryContextHandler root;
/*     */   private final VirtualFile rootFile;
/*     */ 
/*     */   protected MemoryContext(URL url)
/*     */     throws URISyntaxException
/*     */   {
/*  54 */     super(url);
/*  55 */     this.root = new MemoryContextHandler(this, null, url, url.getFile());
/*  56 */     this.rootFile = this.root.getVirtualFile();
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler getRoot() throws IOException
/*     */   {
/*  61 */     return this.root;
/*     */   }
/*     */ 
/*     */   VirtualFileHandler createDirectory(URL url)
/*     */   {
/*  66 */     return putFile(url, null);
/*     */   }
/*     */ 
/*     */   VirtualFileHandler putFile(URL url, byte[] contents)
/*     */   {
/*     */     try
/*     */     {
/*  73 */       String[] tokens = PathTokenizer.getTokens(url.getPath());
/*  74 */       if ((tokens == null) || (tokens.length == 0))
/*     */       {
/*  76 */         return null;
/*     */       }
/*     */ 
/*  79 */       boolean definitelyNew = false;
/*  80 */       String protocolAndHost = url.getProtocol() + "://" + url.getHost();
/*  81 */       StringBuffer path = new StringBuffer(protocolAndHost);
/*  82 */       MemoryContextHandler current = this.root;
/*  83 */       for (int i = 0; i < tokens.length; i++)
/*     */       {
/*  85 */         path.append("/");
/*  86 */         path.append(tokens[i]);
/*     */ 
/*  88 */         if (!definitelyNew)
/*     */         {
/*     */           try
/*     */           {
/*  92 */             MemoryContextHandler child = current.getDirectChild(tokens[i]);
/*  93 */             if (child != null)
/*     */             {
/*  95 */               current = child;
/*  96 */               continue;
/*     */             }
/*     */           }
/*     */           catch (Exception ignore)
/*     */           {
/*     */           }
/* 102 */           definitelyNew = true;
/*     */         }
/*     */         else {
/* 105 */           URL localUrl = new URL(path.toString());
/* 106 */           if (current.getContents() != null)
/*     */           {
/* 108 */             throw new IllegalStateException("Cannot add a child to " + current + " it already has contents");
/*     */           }
/* 110 */           current = new MemoryContextHandler(this, current, localUrl, tokens[i]);
/*     */         }
/*     */       }
/* 113 */       current.setContents(contents);
/* 114 */       return current;
/*     */     }
/*     */     catch (MalformedURLException e) {
/*     */     }
/* 118 */     throw new RuntimeException(e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.memory.MemoryContext
 * JD-Core Version:    0.6.0
 */