/*     */ package org.jboss.virtual.plugins.context.jar;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.zip.ZipEntry;
/*     */ import java.util.zip.ZipInputStream;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class NestedJarFromStream extends AbstractVirtualFileHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private ZipInputStream zis;
/*  41 */   private HashMap<String, JarEntryContents> entries = new HashMap();
/*     */   private URL jarURL;
/*     */   private URL entryURL;
/*     */   private String vfsPath;
/*     */   private String name;
/*     */   private long lastModified;
/*     */   private long size;
/*     */   private boolean inited;
/*     */ 
/*     */   public NestedJarFromStream(VFSContext context, VirtualFileHandler parent, ZipInputStream zis, URL jarURL, ZipEntry entry)
/*     */   {
/*  61 */     super(context, parent, entry.getName());
/*  62 */     this.jarURL = jarURL;
/*  63 */     this.name = entry.getName();
/*  64 */     this.lastModified = entry.getTime();
/*  65 */     this.size = entry.getSize();
/*  66 */     this.zis = zis;
/*     */     try
/*     */     {
/*  69 */       if (parent != null)
/*     */       {
/*  71 */         String vfsParentUrl = parent.toVfsUrl().toString();
/*  72 */         if (vfsParentUrl.endsWith("/")) this.vfsUrl = new URL(vfsParentUrl + this.name); else
/*  73 */           this.vfsUrl = new URL(vfsParentUrl + "/" + this.name);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  78 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path)
/*     */     throws IOException
/*     */   {
/*  85 */     if (!this.inited)
/*  86 */       init();
/*  87 */     return (VirtualFileHandler)this.entries.get(this.name);
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */   {
/*  92 */     if (!this.inited)
/*  93 */       init();
/*  94 */     List children = new ArrayList();
/*  95 */     children.addAll(this.entries.values());
/*  96 */     return children;
/*     */   }
/*     */ 
/*     */   public boolean exists()
/*     */     throws IOException
/*     */   {
/* 105 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isLeaf() throws IOException
/*     */   {
/* 110 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isHidden()
/*     */   {
/* 115 */     return false;
/*     */   }
/*     */ 
/*     */   public long getSize()
/*     */   {
/* 120 */     return this.size;
/*     */   }
/*     */ 
/*     */   public long getLastModified() throws IOException
/*     */   {
/* 125 */     return this.lastModified;
/*     */   }
/*     */ 
/*     */   public Iterator<JarEntryContents> getEntries()
/*     */     throws IOException
/*     */   {
/* 132 */     if (!this.inited)
/* 133 */       init();
/* 134 */     return this.entries.values().iterator();
/*     */   }
/*     */ 
/*     */   public JarEntryContents getEntry(String name)
/*     */     throws IOException
/*     */   {
/* 140 */     if (!this.inited)
/* 141 */       init();
/* 142 */     return (JarEntryContents)this.entries.get(name);
/*     */   }
/*     */ 
/*     */   public ZipEntry getJarEntry(String name)
/*     */     throws IOException
/*     */   {
/* 148 */     if (!this.inited)
/* 149 */       init();
/* 150 */     JarEntryContents jec = (JarEntryContents)this.entries.get(name);
/* 151 */     return jec != null ? jec.getEntry() : null;
/*     */   }
/*     */ 
/*     */   public byte[] getContents(String name)
/*     */     throws IOException
/*     */   {
/* 157 */     if (!this.inited)
/* 158 */       init();
/* 159 */     JarEntryContents jec = (JarEntryContents)this.entries.get(name);
/* 160 */     return jec != null ? jec.getContents() : null;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 165 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getPathName()
/*     */   {
/* 170 */     return this.vfsPath;
/*     */   }
/*     */ 
/*     */   public InputStream openStream()
/*     */     throws IOException
/*     */   {
/* 176 */     return this.zis;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */   {
/* 181 */     this.entries.clear();
/* 182 */     if (this.zis != null)
/*     */     {
/*     */       try
/*     */       {
/* 186 */         this.zis.close();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 190 */         log.error("close error", e);
/*     */       }
/* 192 */       this.zis = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public URI toURI() throws URISyntaxException
/*     */   {
/*     */     try
/*     */     {
/* 200 */       if (this.entryURL == null)
/* 201 */         this.entryURL = new URL(this.jarURL, getName());
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 205 */       throw new URISyntaxException("Failed to create relative jarURL", e.getMessage());
/*     */     }
/* 207 */     return this.entryURL.toURI();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 212 */     StringBuffer tmp = new StringBuffer(super.toString());
/* 213 */     tmp.append('[');
/* 214 */     tmp.append("name=");
/* 215 */     tmp.append(getName());
/* 216 */     tmp.append(",size=");
/* 217 */     tmp.append(getSize());
/* 218 */     tmp.append(",lastModified=");
/* 219 */     tmp.append(this.lastModified);
/* 220 */     tmp.append(",URI=");
/*     */     try
/*     */     {
/* 223 */       tmp.append(toURI());
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/*     */     }
/* 228 */     tmp.append(']');
/* 229 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   protected void init()
/*     */     throws IOException
/*     */   {
/* 235 */     this.inited = true;
/* 236 */     ZipEntry entry = this.zis.getNextEntry();
/* 237 */     while (entry != null)
/*     */     {
/*     */       try
/*     */       {
/* 241 */         String url = toURI().toASCIIString() + "!/" + entry.getName();
/* 242 */         URL jecURL = new URL(url);
/* 243 */         JarEntryContents jec = new JarEntryContents(getVFSContext(), this, entry, jecURL, this.zis, getPathName());
/* 244 */         this.entries.put(entry.getName(), jec);
/* 245 */         entry = this.zis.getNextEntry();
/*     */       }
/*     */       catch (URISyntaxException e)
/*     */       {
/* 249 */         e.printStackTrace();
/*     */       }
/*     */     }
/* 252 */     this.zis.close();
/* 253 */     this.zis = null;
/*     */   }
/*     */ 
/*     */   public static class JarEntryContents extends AbstractVirtualFileHandler {
/*     */     private static final long serialVersionUID = 1L;
/*     */     private ZipEntry entry;
/*     */     private URL entryURL;
/*     */     private String vfsPath;
/*     */     private byte[] contents;
/*     */     private boolean isJar;
/*     */     private NestedJarFromStream njar;
/*     */     private InputStream openStream;
/*     */ 
/*     */     JarEntryContents(VFSContext context, VirtualFileHandler parent, ZipEntry entry, URL entryURL, InputStream zis, String parentVfsPath) throws IOException {
/* 275 */       super(parent, entry.getName());
/* 276 */       this.entry = entry;
/* 277 */       this.entryURL = entryURL;
/* 278 */       this.vfsPath = (parentVfsPath + "/" + entry.getName());
/* 279 */       this.isJar = JarUtils.isArchive(entry.getName());
/* 280 */       int size = (int)entry.getSize();
/* 281 */       if (size <= 0) {
/* 282 */         return;
/*     */       }
/* 284 */       ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
/* 285 */       byte[] tmp = new byte[1024];
/* 286 */       while (zis.available() > 0)
/*     */       {
/* 288 */         int length = zis.read(tmp);
/* 289 */         if (length > 0)
/* 290 */           baos.write(tmp, 0, length);
/*     */       }
/* 292 */       this.contents = baos.toByteArray();
/*     */     }
/*     */ 
/*     */     public boolean exists()
/*     */       throws IOException
/*     */     {
/* 301 */       return true;
/*     */     }
/*     */ 
/*     */     public boolean isHidden() throws IOException
/*     */     {
/* 306 */       return false;
/*     */     }
/*     */ 
/*     */     public ZipEntry getEntry()
/*     */     {
/* 311 */       return this.entry;
/*     */     }
/*     */ 
/*     */     public byte[] getContents()
/*     */     {
/* 316 */       return this.contents;
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/* 321 */       return this.entry.getName();
/*     */     }
/*     */ 
/*     */     public String getPathName()
/*     */     {
/* 326 */       return this.vfsPath;
/*     */     }
/*     */ 
/*     */     public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */     {
/* 331 */       List children = null;
/* 332 */       if (this.isJar)
/*     */       {
/* 334 */         initNestedJar();
/* 335 */         children = this.njar.getChildren(ignoreErrors);
/*     */       }
/* 337 */       return children;
/*     */     }
/*     */ 
/*     */     public VirtualFileHandler findChild(String path)
/*     */       throws IOException
/*     */     {
/*     */       VirtualFileHandler child;
/* 343 */       if (this.isJar)
/*     */       {
/* 345 */         initNestedJar();
/* 346 */         child = this.njar.findChild(path);
/*     */       }
/*     */       else
/*     */       {
/* 350 */         throw new FileNotFoundException("JarEntryContents(" + this.entry.getName() + ") has no children");
/*     */       }
/*     */       VirtualFileHandler child;
/* 352 */       return child;
/*     */     }
/*     */ 
/*     */     public long getLastModified()
/*     */     {
/* 358 */       return this.entry.getTime();
/*     */     }
/*     */ 
/*     */     public long getSize()
/*     */     {
/* 363 */       return this.entry.getSize();
/*     */     }
/*     */ 
/*     */     public boolean isLeaf()
/*     */     {
/* 368 */       if (this.isJar)
/* 369 */         return false;
/* 370 */       return !this.entry.isDirectory();
/*     */     }
/*     */ 
/*     */     public synchronized InputStream openStream()
/*     */       throws IOException
/*     */     {
/* 377 */       initNestedJar();
/* 378 */       if (this.njar != null)
/* 379 */         this.openStream = this.njar.openStream();
/*     */       else
/* 381 */         this.openStream = new ByteArrayInputStream(this.contents);
/* 382 */       return this.openStream;
/*     */     }
/*     */ 
/*     */     public synchronized void close()
/*     */     {
/* 387 */       if (this.openStream != null)
/*     */       {
/*     */         try
/*     */         {
/* 391 */           this.openStream.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 395 */           log.error("close error", e);
/*     */         }
/* 397 */         this.openStream = null;
/*     */       }
/*     */     }
/*     */ 
/*     */     public URI toURI() throws URISyntaxException
/*     */     {
/* 403 */       return this.entryURL.toURI();
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 408 */       StringBuffer tmp = new StringBuffer(super.toString());
/* 409 */       tmp.append('[');
/* 410 */       tmp.append("name=");
/* 411 */       tmp.append(this.entry.getName());
/* 412 */       tmp.append(",size=");
/* 413 */       tmp.append(this.entry.getSize());
/* 414 */       tmp.append(",time=");
/* 415 */       tmp.append(this.entry.getTime());
/* 416 */       tmp.append(",URI=");
/*     */       try
/*     */       {
/* 419 */         tmp.append(toURI());
/*     */       }
/*     */       catch (URISyntaxException e)
/*     */       {
/*     */       }
/* 424 */       tmp.append(']');
/* 425 */       return tmp.toString();
/*     */     }
/*     */ 
/*     */     private synchronized void initNestedJar()
/*     */       throws IOException
/*     */     {
/* 431 */       if ((this.isJar) && (this.njar == null))
/*     */       {
/* 433 */         ByteArrayInputStream bais = new ByteArrayInputStream(this.contents);
/* 434 */         ZipInputStream zis = new ZipInputStream(bais);
/* 435 */         this.njar = new NestedJarFromStream(getVFSContext(), this, zis, this.entryURL, this.entry);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.jar.NestedJarFromStream
 * JD-Core Version:    0.6.0
 */