/*     */ package org.jboss.virtual.plugins.context.jar;
/*     */ 
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarFile;
/*     */ import org.jboss.virtual.plugins.context.AbstractURLHandler;
/*     */ import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class JarEntryHandler extends AbstractURLHandler
/*     */   implements StructuredVirtualFileHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private final transient JarFile jar;
/*     */   private final transient JarEntry entry;
/*     */   private transient List<VirtualFileHandler> entryChildren;
/*     */   private transient Map<String, VirtualFileHandler> entryMap;
/*     */ 
/*     */   public JarEntryHandler(VFSContext context, VirtualFileHandler parent, JarFile jar, JarEntry entry, String entryName, URL url)
/*     */     throws IOException
/*     */   {
/*  79 */     super(context, parent, url, entryName);
/*     */     try
/*     */     {
/*  82 */       URL parentVfsUrl = parent.toVfsUrl();
/*  83 */       String vfsParentUrl = parentVfsUrl.toString();
/*  84 */       String vfsUrlString = null;
/*  85 */       if (vfsParentUrl.endsWith("/")) vfsUrlString = vfsParentUrl + entryName; else
/*  86 */         vfsUrlString = vfsParentUrl + "/" + entryName;
/*  87 */       if (entry.isDirectory()) vfsUrlString = vfsUrlString + "/";
/*  88 */       this.vfsUrl = new URL(vfsUrlString);
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/*  92 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/*  95 */     if (jar == null) {
/*  96 */       throw new IllegalArgumentException("Null jar");
/*     */     }
/*  98 */     this.jar = jar;
/*  99 */     this.entry = entry;
/*     */   }
/*     */ 
/*     */   protected void initCacheLastModified()
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean hasBeenModified()
/*     */     throws IOException
/*     */   {
/* 112 */     return false;
/*     */   }
/*     */ 
/*     */   public void addChild(VirtualFileHandler child)
/*     */   {
/* 121 */     if (this.entryChildren == null)
/* 122 */       this.entryChildren = new ArrayList();
/* 123 */     this.entryChildren.add(child);
/*     */   }
/*     */ 
/*     */   protected JarEntry getEntry()
/*     */   {
/* 133 */     checkClosed();
/* 134 */     return this.entry;
/*     */   }
/*     */ 
/*     */   public long getLastModified()
/*     */   {
/* 140 */     return getEntry().getTime();
/*     */   }
/*     */ 
/*     */   public long getSize()
/*     */   {
/* 146 */     return getEntry().getSize();
/*     */   }
/*     */ 
/*     */   public boolean isLeaf()
/*     */   {
/* 151 */     return !getEntry().isDirectory();
/*     */   }
/*     */ 
/*     */   public boolean isHidden()
/*     */   {
/* 156 */     checkClosed();
/* 157 */     return false;
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */   {
/* 162 */     checkClosed();
/* 163 */     List children = this.entryChildren;
/* 164 */     if (this.entryChildren == null)
/* 165 */       children = Collections.emptyList();
/* 166 */     return children;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path) throws IOException
/*     */   {
/* 171 */     return structuredFindChild(path);
/*     */   }
/*     */ 
/*     */   public InputStream openStream()
/*     */     throws IOException
/*     */   {
/* 177 */     return this.jar.getInputStream(getEntry());
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler createChildHandler(String name)
/*     */     throws IOException
/*     */   {
/* 187 */     if (this.entryChildren == null)
/* 188 */       throw new FileNotFoundException(this + " has no children");
/* 189 */     if (this.entryMap == null)
/*     */     {
/* 191 */       this.entryMap = new HashMap();
/* 192 */       for (VirtualFileHandler child : this.entryChildren)
/* 193 */         this.entryMap.put(child.getName(), child);
/*     */     }
/* 195 */     VirtualFileHandler child = (VirtualFileHandler)this.entryMap.get(name);
/* 196 */     if (child == null)
/* 197 */       throw new FileNotFoundException(this + " has no child: " + name);
/* 198 */     return child;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.jar.JarEntryHandler
 * JD-Core Version:    0.6.0
 */