/*     */ package org.jboss.virtual.plugins.context;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ import org.jboss.virtual.spi.VirtualFileHandlerVisitor;
/*     */ 
/*     */ public abstract class AbstractVFSContext
/*     */   implements VFSContext
/*     */ {
/*  51 */   protected final Logger log = Logger.getLogger(getClass());
/*     */   private VFS vfs;
/*     */   private final URI rootURI;
/*     */   private Map<String, String> rootOptions;
/*     */ 
/*     */   protected AbstractVFSContext(URI rootURI)
/*     */   {
/*  69 */     if (rootURI == null)
/*  70 */       throw new IllegalArgumentException("Null rootURI");
/*  71 */     this.rootURI = rootURI;
/*  72 */     String query = rootURI.getQuery();
/*  73 */     this.rootOptions = VFSUtils.parseURLQuery(query);
/*     */   }
/*     */ 
/*     */   protected AbstractVFSContext(URL rootURL)
/*     */     throws URISyntaxException
/*     */   {
/*  85 */     this(rootURL.toURI());
/*     */   }
/*     */ 
/*     */   public VFS getVFS()
/*     */   {
/*  90 */     if (this.vfs == null)
/*  91 */       this.vfs = new VFS(this);
/*  92 */     return this.vfs;
/*     */   }
/*     */ 
/*     */   public URI getRootURI()
/*     */   {
/*  97 */     return this.rootURI;
/*     */   }
/*     */ 
/*     */   public Map<String, String> getOptions()
/*     */   {
/* 102 */     return this.rootOptions;
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(VirtualFileHandler parent, boolean ignoreErrors) throws IOException
/*     */   {
/* 107 */     if (parent == null)
/* 108 */       throw new IllegalArgumentException("Null parent");
/* 109 */     return parent.getChildren(ignoreErrors);
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(VirtualFileHandler parent, String path) throws IOException
/*     */   {
/* 114 */     if (parent == null)
/* 115 */       throw new IllegalArgumentException("Null parent");
/* 116 */     if (path == null)
/* 117 */       throw new IllegalArgumentException("Null path");
/* 118 */     return parent.findChild(path);
/*     */   }
/*     */ 
/*     */   public void visit(VirtualFileHandler handler, VirtualFileHandlerVisitor visitor) throws IOException
/*     */   {
/* 123 */     if (handler == null)
/* 124 */       throw new IllegalArgumentException("Null handler");
/* 125 */     if (visitor == null) {
/* 126 */       throw new IllegalArgumentException("Null visitor");
/*     */     }
/* 128 */     VisitorAttributes attributes = visitor.getAttributes();
/* 129 */     boolean includeRoot = attributes.isIncludeRoot();
/* 130 */     boolean leavesOnly = attributes.isLeavesOnly();
/* 131 */     boolean ignoreErrors = attributes.isIgnoreErrors();
/* 132 */     boolean includeHidden = attributes.isIncludeHidden();
/* 133 */     VirtualFileFilter recurseFilter = attributes.getRecurseFilter();
/* 134 */     visit(handler, visitor, includeRoot, leavesOnly, ignoreErrors, includeHidden, recurseFilter);
/*     */   }
/*     */ 
/*     */   protected void visit(VirtualFileHandler handler, VirtualFileHandlerVisitor visitor, boolean includeRoot, boolean leavesOnly, boolean ignoreErrors, boolean includeHidden, VirtualFileFilter recurseFilter)
/*     */     throws IOException
/*     */   {
/* 157 */     if (includeRoot) {
/* 158 */       visitor.visit(handler);
/* 161 */     }
/*     */ boolean trace = this.log.isTraceEnabled();
/*     */     List children;
/*     */     try {
/* 165 */       children = getChildren(handler, ignoreErrors);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 169 */       if (!ignoreErrors)
/* 170 */         throw e;
/* 171 */       if (trace)
/* 172 */         this.log.trace("Ignored: " + e);
/* 173 */       return;
/*     */     }
/*     */ 
/* 177 */     for (VirtualFileHandler child : children)
/*     */     {
/* 180 */       if ((!includeHidden) && (child.isHidden()))
/*     */       {
/* 182 */         if (trace) {
/* 183 */           this.log.trace("Ignoring hidden file: " + child); continue;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 188 */       boolean isLeaf = child.isLeaf();
/* 189 */       if ((!leavesOnly) || (isLeaf))
/* 190 */         visitor.visit(child);
/* 191 */       else if (trace)
/*     */       {
/* 193 */         this.log.trace("Skipping non-leaf file: " + child);
/*     */       }
/*     */ 
/* 197 */       VirtualFile file = child.getVirtualFile();
/* 198 */       if ((!isLeaf) && (recurseFilter != null) && (recurseFilter.accepts(file)))
/*     */       {
/*     */         try
/*     */         {
/* 202 */           visit(child, visitor, false, leavesOnly, ignoreErrors, includeHidden, recurseFilter);
/*     */         }
/*     */         catch (StackOverflowError e)
/*     */         {
/* 206 */           this.log.debug("Original: " + child, e);
/* 207 */           throw new IOException("Stack overflow, the file system is too complicated? " + child);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 216 */     StringBuilder buffer = new StringBuilder();
/* 217 */     buffer.append(getClass().getSimpleName());
/* 218 */     buffer.append('@');
/* 219 */     buffer.append(System.identityHashCode(this));
/* 220 */     buffer.append('[');
/* 221 */     buffer.append(this.rootURI);
/* 222 */     buffer.append(']');
/* 223 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 229 */     return this.rootURI.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 235 */     if (this == obj)
/* 236 */       return true;
/* 237 */     if ((obj == null) || (!(obj instanceof VFSContext)))
/* 238 */       return false;
/* 239 */     VFSContext other = (VFSContext)obj;
/* 240 */     return this.rootURI.equals(other.getRootURI());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.AbstractVFSContext
 * JD-Core Version:    0.6.0
 */