/*     */ package org.jboss.virtual.plugins.context;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public abstract class AbstractURLHandler extends AbstractVirtualFileHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private final URL url;
/*     */ 
/*     */   public AbstractURLHandler(VFSContext context, VirtualFileHandler parent, URL url, String name)
/*     */   {
/*  61 */     super(context, parent, name);
/*  62 */     if (url == null)
/*  63 */       throw new IllegalArgumentException("Null url");
/*  64 */     this.url = url;
/*  65 */     initCacheLastModified();
/*     */   }
/*     */ 
/*     */   protected void initCacheLastModified()
/*     */   {
/*     */     try
/*     */     {
/*  72 */       this.cachedLastModified = this.url.openConnection().getLastModified();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  76 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public URL getURL()
/*     */   {
/*  87 */     return this.url;
/*     */   }
/*     */ 
/*     */   public URL toURL() throws MalformedURLException, URISyntaxException
/*     */   {
/*  92 */     return getURL();
/*     */   }
/*     */ 
/*     */   public long getLastModified() throws IOException
/*     */   {
/*  97 */     checkClosed();
/*  98 */     URLConnection c = this.url.openConnection();
/*  99 */     return c.getLastModified();
/*     */   }
/*     */ 
/*     */   public long getSize() throws IOException
/*     */   {
/* 104 */     checkClosed();
/* 105 */     URLConnection c = this.url.openConnection();
/* 106 */     return c.getContentLength();
/*     */   }
/*     */ 
/*     */   public boolean exists()
/*     */     throws IOException
/*     */   {
/* 118 */     URLConnection c = this.url.openConnection();
/* 119 */     return c.getLastModified() != 0L;
/*     */   }
/*     */ 
/*     */   public boolean isHidden() throws IOException
/*     */   {
/* 124 */     checkClosed();
/* 125 */     return false;
/*     */   }
/*     */ 
/*     */   public InputStream openStream() throws IOException
/*     */   {
/* 130 */     checkClosed();
/* 131 */     return this.url.openStream();
/*     */   }
/*     */ 
/*     */   public URI toURI() throws URISyntaxException
/*     */   {
/* 136 */     return VFSUtils.toURI(this.url);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.AbstractURLHandler
 * JD-Core Version:    0.6.0
 */