/*      */ package org.jboss.verifier.strategy;
/*      */ 
/*      */ import java.lang.reflect.Field;
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.Arrays;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import org.jboss.metadata.EntityMetaData;
/*      */ import org.jboss.metadata.SessionMetaData;
/*      */ import org.jboss.verifier.Section;
/*      */ 
/*      */ public class EJBVerifier11 extends AbstractVerifier
/*      */ {
/*      */   public EJBVerifier11(VerificationContext context)
/*      */   {
/*   64 */     super(context);
/*      */   }
/*      */ 
/*      */   public String getMessageBundle()
/*      */   {
/*   69 */     return "EJB11Messages.properties";
/*      */   }
/*      */ 
/*      */   public void checkSession(SessionMetaData session)
/*      */   {
/*   86 */     boolean beanVerified = false;
/*   87 */     boolean homeVerified = false;
/*   88 */     boolean remoteVerified = false;
/*      */ 
/*   90 */     beanVerified = verifySessionBean(session);
/*   91 */     homeVerified = verifySessionHome(session);
/*   92 */     remoteVerified = verifySessionRemote(session);
/*      */ 
/*   94 */     if ((beanVerified) && (homeVerified) && (remoteVerified))
/*      */     {
/*  100 */       fireBeanVerifiedEvent(session);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void checkEntity(EntityMetaData entity)
/*      */   {
/*  112 */     boolean pkVerified = false;
/*  113 */     boolean beanVerified = false;
/*  114 */     boolean homeVerified = false;
/*  115 */     boolean remoteVerified = false;
/*      */ 
/*  117 */     beanVerified = verifyEntityBean(entity);
/*  118 */     homeVerified = verifyEntityHome(entity);
/*  119 */     remoteVerified = verifyEntityRemote(entity);
/*  120 */     pkVerified = verifyPrimaryKey(entity);
/*      */ 
/*  122 */     if ((beanVerified) && (homeVerified) && (remoteVerified) && (pkVerified))
/*      */     {
/*  128 */       fireBeanVerifiedEvent(entity);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isCreateMethod(Method m)
/*      */   {
/*  134 */     return m.getName().equals("create");
/*      */   }
/*      */ 
/*      */   public boolean isEjbCreateMethod(Method m)
/*      */   {
/*  139 */     return m.getName().equals("ejbCreate");
/*      */   }
/*      */ 
/*      */   private boolean verifySessionHome(SessionMetaData session)
/*      */   {
/*  163 */     boolean status = true;
/*      */ 
/*  165 */     String name = session.getHome();
/*  166 */     if (name == null) {
/*  167 */       return false;
/*      */     }
/*      */     try
/*      */     {
/*  171 */       Class home = this.classloader.loadClass(name);
/*      */ 
/*  184 */       if (session.isStateless())
/*      */       {
/*  186 */         if (!hasDefaultCreateMethod(home))
/*      */         {
/*  188 */           fireSpecViolationEvent(session, new Section("6.8.a"));
/*  189 */           status = false;
/*      */         }
/*      */         else
/*      */         {
/*  193 */           Method create = getDefaultCreateMethod(home);
/*      */ 
/*  195 */           if (!hasRemoteReturnType(session, create))
/*      */           {
/*  197 */             fireSpecViolationEvent(session, create, new Section("6.8.b"));
/*      */ 
/*  199 */             status = false;
/*      */           }
/*      */ 
/*  202 */           if (hasMoreThanOneCreateMethods(home))
/*      */           {
/*  204 */             fireSpecViolationEvent(session, new Section("6.8.c"));
/*  205 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  216 */       if (!hasEJBHomeInterface(home))
/*      */       {
/*  218 */         fireSpecViolationEvent(session, new Section("6.10.6.a"));
/*  219 */         status = false;
/*      */       }
/*      */ 
/*  234 */       Iterator it = Arrays.asList(home.getMethods()).iterator();
/*  235 */       while (it.hasNext())
/*      */       {
/*  237 */         Method method = (Method)it.next();
/*      */ 
/*  239 */         if (!hasLegalRMIIIOPArguments(method))
/*      */         {
/*  241 */           fireSpecViolationEvent(session, method, new Section("6.10.6.b"));
/*  242 */           status = false;
/*      */         }
/*      */ 
/*  245 */         if (!hasLegalRMIIIOPReturnType(method))
/*      */         {
/*  247 */           fireSpecViolationEvent(session, method, new Section("6.10.6.c"));
/*  248 */           status = false;
/*      */         }
/*      */ 
/*  251 */         if (!throwsRemoteException(method))
/*      */         {
/*  253 */           fireSpecViolationEvent(session, method, new Section("6.10.6.d"));
/*  254 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  264 */       if (!hasCreateMethod(home))
/*      */       {
/*  266 */         fireSpecViolationEvent(session, new Section("6.10.6.e"));
/*  267 */         status = false;
/*      */       }
/*      */ 
/*  290 */       Iterator createMethods = getCreateMethods(home);
/*      */       try
/*      */       {
/*  293 */         String beanClass = session.getEjbClass();
/*  294 */         Class bean = this.classloader.loadClass(beanClass);
/*      */ 
/*  296 */         while (createMethods.hasNext())
/*      */         {
/*  298 */           Method create = (Method)createMethods.next();
/*      */ 
/*  300 */           if (!hasMatchingEJBCreate(bean, create))
/*      */           {
/*  302 */             fireSpecViolationEvent(session, create, new Section("6.10.6.f"));
/*  303 */             status = false;
/*      */           }
/*      */ 
/*  306 */           if (!hasRemoteReturnType(session, create))
/*      */           {
/*  308 */             fireSpecViolationEvent(session, create, new Section("6.10.6.g"));
/*  309 */             status = false;
/*      */           }
/*      */ 
/*  312 */           if (hasMatchingEJBCreate(bean, create))
/*      */           {
/*  314 */             Method ejbCreate = getMatchingEJBCreate(bean, create);
/*      */ 
/*  316 */             if (!hasMatchingExceptions(ejbCreate, create))
/*      */             {
/*  318 */               fireSpecViolationEvent(session, create, new Section("6.10.6.h"));
/*  319 */               status = false;
/*      */             }
/*      */           }
/*      */ 
/*  323 */           if (!throwsCreateException(create))
/*      */           {
/*  325 */             fireSpecViolationEvent(session, create, new Section("6.10.6.i"));
/*  326 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (ClassNotFoundException ignored)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  342 */       fireSpecViolationEvent(session, new Section("16.2.c"));
/*  343 */       status = false;
/*      */     }
/*      */ 
/*  346 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifySessionRemote(SessionMetaData session)
/*      */   {
/*  362 */     boolean status = true;
/*      */ 
/*  364 */     String name = session.getRemote();
/*  365 */     if (name == null) {
/*  366 */       return false;
/*      */     }
/*      */     try
/*      */     {
/*  370 */       Class remote = this.classloader.loadClass(name);
/*      */ 
/*  378 */       if (!hasEJBObjectInterface(remote))
/*      */       {
/*  380 */         fireSpecViolationEvent(session, new Section("6.10.5.a"));
/*  381 */         status = false;
/*      */       }
/*      */ 
/*  396 */       Iterator it = Arrays.asList(remote.getMethods()).iterator();
/*  397 */       while (it.hasNext())
/*      */       {
/*  399 */         Method method = (Method)it.next();
/*      */ 
/*  401 */         if (!hasLegalRMIIIOPArguments(method))
/*      */         {
/*  403 */           fireSpecViolationEvent(session, method, new Section("6.10.5.b"));
/*  404 */           status = false;
/*      */         }
/*      */ 
/*  407 */         if (!hasLegalRMIIIOPReturnType(method))
/*      */         {
/*  409 */           fireSpecViolationEvent(session, method, new Section("6.10.5.c"));
/*  410 */           status = false;
/*      */         }
/*      */ 
/*  413 */         if (!throwsRemoteException(method))
/*      */         {
/*  415 */           fireSpecViolationEvent(session, method, new Section("6.10.5.d"));
/*  416 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  434 */       String beanName = session.getEjbClass();
/*  435 */       Class bean = this.classloader.loadClass(beanName);
/*      */ 
/*  437 */       Iterator iterator = Arrays.asList(remote.getDeclaredMethods()).iterator();
/*  438 */       while (iterator.hasNext())
/*      */       {
/*  440 */         Method remoteMethod = (Method)iterator.next();
/*      */ 
/*  442 */         if (!hasMatchingMethod(bean, remoteMethod))
/*      */         {
/*  444 */           fireSpecViolationEvent(session, remoteMethod, new Section("6.10.5.e"));
/*  445 */           status = false;
/*      */         }
/*      */ 
/*  448 */         if (hasMatchingMethod(bean, remoteMethod))
/*      */         {
/*      */           try
/*      */           {
/*  452 */             Method beanMethod = bean.getMethod(remoteMethod.getName(), remoteMethod.getParameterTypes());
/*      */ 
/*  454 */             if (!hasMatchingReturnType(remoteMethod, beanMethod))
/*      */             {
/*  456 */               fireSpecViolationEvent(session, remoteMethod, new Section("6.10.5.f"));
/*  457 */               status = false;
/*      */             }
/*      */ 
/*  460 */             if (!hasMatchingExceptions(beanMethod, remoteMethod))
/*      */             {
/*  462 */               fireSpecViolationEvent(session, remoteMethod, new Section("6.10.5.g"));
/*  463 */               status = false;
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (NoSuchMethodException ignored)
/*      */           {
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  480 */       fireSpecViolationEvent(session, new Section("16.2.d"));
/*  481 */       status = false;
/*      */     }
/*      */ 
/*  484 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifySessionBean(SessionMetaData session)
/*      */   {
/*  496 */     boolean status = true;
/*      */ 
/*  498 */     String name = session.getEjbClass();
/*      */     try
/*      */     {
/*  502 */       Class bean = this.classloader.loadClass(name);
/*      */ 
/*  511 */       if (!hasSessionBeanInterface(bean))
/*      */       {
/*  513 */         fireSpecViolationEvent(session, new Section("6.5.1"));
/*  514 */         status = false;
/*      */       }
/*      */ 
/*  526 */       if (hasSessionSynchronizationInterface(bean))
/*      */       {
/*  528 */         if (session.isStateless())
/*      */         {
/*  530 */           fireSpecViolationEvent(session, new Section("6.5.3.a"));
/*  531 */           status = false;
/*      */         }
/*      */ 
/*  534 */         if (session.isBeanManagedTx())
/*      */         {
/*  536 */           fireSpecViolationEvent(session, new Section("6.5.3.b"));
/*  537 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  546 */       if (!hasEJBCreateMethod(bean, true))
/*      */       {
/*  548 */         fireSpecViolationEvent(session, new Section("6.5.5"));
/*  549 */         status = false;
/*      */       }
/*      */ 
/*  558 */       if ((hasSessionSynchronizationInterface(bean)) && (session.isBeanManagedTx()))
/*      */       {
/*  561 */         fireSpecViolationEvent(session, new Section("6.6.1"));
/*  562 */         status = false;
/*      */       }
/*      */ 
/*  570 */       if (!isPublic(bean))
/*      */       {
/*  572 */         fireSpecViolationEvent(session, new Section("6.10.2.a"));
/*  573 */         status = false;
/*      */       }
/*      */ 
/*  581 */       if (isFinal(bean))
/*      */       {
/*  583 */         fireSpecViolationEvent(session, new Section("6.10.2.b"));
/*  584 */         status = false;
/*      */       }
/*      */ 
/*  592 */       if (isAbstract(bean))
/*      */       {
/*  594 */         fireSpecViolationEvent(session, new Section("6.10.2.c"));
/*  595 */         status = false;
/*      */       }
/*      */ 
/*  604 */       if (!hasDefaultConstructor(bean))
/*      */       {
/*  606 */         fireSpecViolationEvent(session, new Section("6.10.2.d"));
/*  607 */         status = false;
/*      */       }
/*      */ 
/*  615 */       if (hasFinalizer(bean))
/*      */       {
/*  617 */         fireSpecViolationEvent(session, new Section("6.10.2.e"));
/*  618 */         status = false;
/*      */       }
/*      */ 
/*  631 */       if (hasEJBCreateMethod(bean, true))
/*      */       {
/*  633 */         Iterator it = getEJBCreateMethods(bean);
/*  634 */         while (it.hasNext())
/*      */         {
/*  636 */           Method ejbCreate = (Method)it.next();
/*      */ 
/*  638 */           if (!isPublic(ejbCreate))
/*      */           {
/*  640 */             fireSpecViolationEvent(session, ejbCreate, new Section("6.10.3.a"));
/*  641 */             status = false;
/*      */           }
/*      */ 
/*  644 */           if ((isFinal(ejbCreate)) || (isStatic(ejbCreate)))
/*      */           {
/*  646 */             fireSpecViolationEvent(session, ejbCreate, new Section("6.10.3.b"));
/*  647 */             status = false;
/*      */           }
/*      */ 
/*  650 */           if (!hasVoidReturnType(ejbCreate))
/*      */           {
/*  652 */             fireSpecViolationEvent(session, ejbCreate, new Section("6.10.3.c"));
/*  653 */             status = false;
/*      */           }
/*      */ 
/*  656 */           if (!hasLegalRMIIIOPArguments(ejbCreate))
/*      */           {
/*  658 */             fireSpecViolationEvent(session, ejbCreate, new Section("6.10.3.d"));
/*  659 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  673 */       fireSpecViolationEvent(session, new Section("16.2.b"));
/*  674 */       status = false;
/*      */     }
/*      */ 
/*  677 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityHome(EntityMetaData entity)
/*      */   {
/*  691 */     boolean status = true;
/*      */ 
/*  693 */     String name = entity.getHome();
/*  694 */     if (name == null) {
/*  695 */       return false;
/*      */     }
/*      */     try
/*      */     {
/*  699 */       Class home = this.classloader.loadClass(name);
/*      */ 
/*  707 */       if (!hasEJBHomeInterface(home))
/*      */       {
/*  709 */         fireSpecViolationEvent(entity, new Section("9.2.8.a"));
/*  710 */         status = false;
/*      */       }
/*      */ 
/*  725 */       Iterator homeMethods = Arrays.asList(home.getMethods()).iterator();
/*  726 */       while (homeMethods.hasNext())
/*      */       {
/*  728 */         Method method = (Method)homeMethods.next();
/*      */ 
/*  730 */         if (!hasLegalRMIIIOPArguments(method))
/*      */         {
/*  732 */           fireSpecViolationEvent(entity, method, new Section("9.2.8.b"));
/*      */ 
/*  734 */           status = false;
/*      */         }
/*      */ 
/*  737 */         if (!hasLegalRMIIIOPReturnType(method))
/*      */         {
/*  739 */           fireSpecViolationEvent(entity, method, new Section("9.2.8.c"));
/*  740 */           status = false;
/*      */         }
/*      */ 
/*  743 */         if (!throwsRemoteException(method))
/*      */         {
/*  745 */           fireSpecViolationEvent(entity, method, new Section("9.2.8.d"));
/*  746 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  759 */       homeMethods = Arrays.asList(home.getMethods()).iterator();
/*  760 */       while (homeMethods.hasNext())
/*      */       {
/*  762 */         Method method = (Method)homeMethods.next();
/*      */ 
/*  765 */         if (method.getDeclaringClass().getName().equals("javax.ejb.EJBHome")) {
/*      */           continue;
/*      */         }
/*  768 */         if ((!isCreateMethod(method)) && (!isFinderMethod(method)))
/*      */         {
/*  770 */           fireSpecViolationEvent(entity, method, new Section("9.2.8.e"));
/*  771 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  799 */         String beanClass = entity.getEjbClass();
/*  800 */         Class bean = this.classloader.loadClass(beanClass);
/*      */ 
/*  802 */         Iterator createMethods = getCreateMethods(home);
/*  803 */         while (createMethods.hasNext())
/*      */         {
/*  805 */           Method create = (Method)createMethods.next();
/*      */ 
/*  807 */           if (!hasMatchingEJBCreate(bean, create))
/*      */           {
/*  809 */             fireSpecViolationEvent(entity, create, new Section("9.2.8.f"));
/*  810 */             status = false;
/*      */           }
/*      */ 
/*  813 */           if (!hasRemoteReturnType(entity, create))
/*      */           {
/*  815 */             fireSpecViolationEvent(entity, create, new Section("9.2.8.g"));
/*  816 */             status = false;
/*      */           }
/*      */ 
/*  819 */           if ((hasMatchingEJBCreate(bean, create)) && (hasMatchingEJBPostCreate(bean, create)))
/*      */           {
/*  822 */             Method ejbCreate = getMatchingEJBCreate(bean, create);
/*  823 */             Method ejbPostCreate = getMatchingEJBPostCreate(bean, create);
/*      */ 
/*  825 */             if ((!hasMatchingExceptions(ejbCreate, create)) || (!hasMatchingExceptions(ejbPostCreate, create)))
/*      */             {
/*  828 */               fireSpecViolationEvent(entity, create, new Section("9.2.8.h"));
/*  829 */               status = false;
/*      */             }
/*      */           }
/*      */ 
/*  833 */           if (!throwsCreateException(create))
/*      */           {
/*  835 */             fireSpecViolationEvent(entity, create, new Section("9.2.8.i"));
/*  836 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (ClassNotFoundException ignored)
/*      */       {
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  866 */         String beanClass = entity.getEjbClass();
/*  867 */         Class bean = this.classloader.loadClass(beanClass);
/*      */ 
/*  869 */         Iterator finderMethods = getFinderMethods(home);
/*  870 */         while (finderMethods.hasNext())
/*      */         {
/*  872 */           Method finder = (Method)finderMethods.next();
/*      */ 
/*  874 */           if ((entity.isBMP()) && (!hasMatchingEJBFind(bean, finder)))
/*      */           {
/*  876 */             fireSpecViolationEvent(entity, finder, new Section("9.2.8.j"));
/*  877 */             status = false;
/*      */           }
/*      */ 
/*  880 */           if ((!hasRemoteReturnType(entity, finder)) && (!isMultiObjectFinder(finder)))
/*      */           {
/*  883 */             fireSpecViolationEvent(entity, finder, new Section("9.2.8.k"));
/*  884 */             status = false;
/*      */           }
/*      */ 
/*  887 */           if ((entity.isBMP()) && (hasMatchingEJBFind(bean, finder)))
/*      */           {
/*  889 */             Method ejbFind = getMatchingEJBFind(bean, finder);
/*  890 */             if (!hasMatchingExceptions(ejbFind, finder))
/*      */             {
/*  892 */               fireSpecViolationEvent(entity, finder, new Section("9.2.8.l"));
/*  893 */               status = false;
/*      */             }
/*      */           }
/*      */ 
/*  897 */           if (!throwsFinderException(finder))
/*      */           {
/*  899 */             fireSpecViolationEvent(entity, finder, new Section("9.2.8.m"));
/*  900 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (ClassNotFoundException ignored)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  916 */       fireSpecViolationEvent(entity, new Section("16.2.c"));
/*  917 */       status = false;
/*      */     }
/*      */ 
/*  920 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityRemote(EntityMetaData entity)
/*      */   {
/*  934 */     boolean status = true;
/*      */ 
/*  936 */     String name = entity.getRemote();
/*  937 */     if (name == null) {
/*  938 */       return false;
/*      */     }
/*      */     try
/*      */     {
/*  942 */       Class remote = this.classloader.loadClass(name);
/*      */ 
/*  950 */       if (!hasEJBObjectInterface(remote))
/*      */       {
/*  952 */         fireSpecViolationEvent(entity, new Section("9.2.7.a"));
/*  953 */         status = false;
/*      */       }
/*      */ 
/*  968 */       Iterator remoteMethods = Arrays.asList(remote.getMethods()).iterator();
/*  969 */       while (remoteMethods.hasNext())
/*      */       {
/*  971 */         Method method = (Method)remoteMethods.next();
/*      */ 
/*  973 */         if (!hasLegalRMIIIOPArguments(method))
/*      */         {
/*  975 */           fireSpecViolationEvent(entity, method, new Section("9.2.7.b"));
/*  976 */           status = false;
/*      */         }
/*      */ 
/*  979 */         if (!hasLegalRMIIIOPReturnType(method))
/*      */         {
/*  981 */           fireSpecViolationEvent(entity, method, new Section("9.2.7.c"));
/*  982 */           status = false;
/*      */         }
/*      */ 
/*  985 */         if (!hasLegalRMIIIOPExceptionTypes(method))
/*      */         {
/*  987 */           fireSpecViolationEvent(entity, method, new Section("9.2.7.h"));
/*  988 */           status = false;
/*      */         }
/*      */ 
/*  991 */         if (!throwsRemoteException(method))
/*      */         {
/*  993 */           fireSpecViolationEvent(entity, method, new Section("9.2.7.d"));
/*  994 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1016 */         String beanClass = entity.getEjbClass();
/* 1017 */         Class bean = this.classloader.loadClass(beanClass);
/*      */ 
/* 1019 */         remoteMethods = Arrays.asList(remote.getMethods()).iterator();
/* 1020 */         while (remoteMethods.hasNext())
/*      */         {
/* 1022 */           Method method = (Method)remoteMethods.next();
/*      */ 
/* 1025 */           if (method.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) {
/*      */             continue;
/*      */           }
/* 1028 */           if (!hasMatchingMethod(bean, method))
/*      */           {
/* 1030 */             fireSpecViolationEvent(entity, method, new Section("9.2.7.e"));
/* 1031 */             status = false;
/*      */           }
/*      */ 
/* 1034 */           if (hasMatchingMethod(bean, method))
/*      */           {
/*      */             try
/*      */             {
/* 1038 */               Method beanMethod = bean.getMethod(method.getName(), method.getParameterTypes());
/*      */ 
/* 1040 */               if (!hasMatchingReturnType(beanMethod, method))
/*      */               {
/* 1042 */                 fireSpecViolationEvent(entity, method, new Section("9.2.7.f"));
/* 1043 */                 status = false;
/*      */               }
/*      */ 
/* 1046 */               if (!hasMatchingExceptions(beanMethod, method))
/*      */               {
/* 1048 */                 fireSpecViolationEvent(entity, method, new Section("9.2.7.g"));
/* 1049 */                 status = false;
/*      */               }
/*      */ 
/*      */             }
/*      */             catch (NoSuchMethodException ignored)
/*      */             {
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (ClassNotFoundException ignored)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/* 1070 */       fireSpecViolationEvent(entity, new Section("16.2.d"));
/* 1071 */       status = false;
/*      */     }
/*      */ 
/* 1074 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityBean(EntityMetaData entity)
/*      */   {
/* 1087 */     boolean status = true;
/*      */ 
/* 1089 */     String name = entity.getEjbClass();
/*      */     try
/*      */     {
/* 1093 */       Class bean = this.classloader.loadClass(name);
/*      */ 
/* 1101 */       if (!hasEntityBeanInterface(bean))
/*      */       {
/* 1103 */         fireSpecViolationEvent(entity, new Section("9.2.2.a"));
/* 1104 */         status = false;
/*      */       }
/*      */ 
/* 1112 */       if (!isPublic(bean))
/*      */       {
/* 1114 */         fireSpecViolationEvent(entity, new Section("9.2.2.b"));
/* 1115 */         status = false;
/*      */       }
/*      */ 
/* 1123 */       if (isAbstract(bean))
/*      */       {
/* 1125 */         fireSpecViolationEvent(entity, new Section("9.2.2.c"));
/* 1126 */         status = false;
/*      */       }
/*      */ 
/* 1134 */       if (isFinal(bean))
/*      */       {
/* 1136 */         fireSpecViolationEvent(entity, new Section("9.2.2.d"));
/* 1137 */         status = false;
/*      */       }
/*      */ 
/* 1146 */       if (!hasDefaultConstructor(bean))
/*      */       {
/* 1148 */         fireSpecViolationEvent(entity, new Section("9.2.2.e"));
/* 1149 */         status = false;
/*      */       }
/*      */ 
/* 1157 */       if (hasFinalizer(bean))
/*      */       {
/* 1159 */         fireSpecViolationEvent(entity, new Section("9.2.2.f"));
/* 1160 */         status = false;
/*      */       }
/*      */ 
/* 1174 */       if (hasEJBCreateMethod(bean, false))
/*      */       {
/* 1176 */         Iterator it = getEJBCreateMethods(bean);
/* 1177 */         while (it.hasNext())
/*      */         {
/* 1179 */           Method ejbCreate = (Method)it.next();
/*      */ 
/* 1181 */           if (!isPublic(ejbCreate))
/*      */           {
/* 1183 */             fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.3.a"));
/* 1184 */             status = false;
/*      */           }
/*      */ 
/* 1187 */           if ((isFinal(ejbCreate)) || (isStatic(ejbCreate)))
/*      */           {
/* 1189 */             fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.3.b"));
/* 1190 */             status = false;
/*      */           }
/*      */ 
/* 1193 */           if (!hasPrimaryKeyReturnType(entity, ejbCreate))
/*      */           {
/* 1195 */             fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.3.c"));
/* 1196 */             status = false;
/*      */           }
/*      */ 
/* 1199 */           if (!hasLegalRMIIIOPArguments(ejbCreate))
/*      */           {
/* 1201 */             fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.3.d"));
/* 1202 */             status = false;
/*      */           }
/*      */ 
/* 1205 */           if (!hasLegalRMIIIOPReturnType(ejbCreate))
/*      */           {
/* 1207 */             fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.3.e"));
/* 1208 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1227 */       if (hasEJBCreateMethod(bean, false))
/*      */       {
/* 1229 */         Iterator it = getEJBCreateMethods(bean);
/* 1230 */         while (it.hasNext())
/*      */         {
/* 1232 */           Method ejbCreate = (Method)it.next();
/*      */ 
/* 1234 */           if (!hasMatchingEJBPostCreate(bean, ejbCreate))
/*      */           {
/* 1236 */             fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.4.a"));
/* 1237 */             status = false;
/*      */           }
/*      */ 
/* 1240 */           if (hasMatchingEJBPostCreate(bean, ejbCreate))
/*      */           {
/* 1242 */             Method ejbPostCreate = getMatchingEJBPostCreate(bean, ejbCreate);
/*      */ 
/* 1244 */             if (!isPublic(ejbPostCreate))
/*      */             {
/* 1246 */               fireSpecViolationEvent(entity, ejbPostCreate, new Section("9.2.4.b"));
/* 1247 */               status = false;
/*      */             }
/*      */ 
/* 1250 */             if (isStatic(ejbPostCreate))
/*      */             {
/* 1252 */               fireSpecViolationEvent(entity, ejbPostCreate, new Section("9.2.4.c"));
/* 1253 */               status = false;
/*      */             }
/*      */ 
/* 1256 */             if (isFinal(ejbPostCreate))
/*      */             {
/* 1258 */               fireSpecViolationEvent(entity, ejbPostCreate, new Section("9.2.4.d"));
/* 1259 */               status = false;
/*      */             }
/*      */ 
/* 1262 */             if (!hasVoidReturnType(ejbPostCreate))
/*      */             {
/* 1264 */               fireSpecViolationEvent(entity, ejbPostCreate, new Section("9.2.4.e"));
/* 1265 */               status = false;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1281 */       if ((entity.isBMP()) && (!hasEJBFindByPrimaryKey(bean)))
/*      */       {
/* 1283 */         fireSpecViolationEvent(entity, new Section("9.2.5.a"));
/* 1284 */         status = false;
/*      */       }
/*      */ 
/* 1287 */       if (hasEJBFindByPrimaryKey(bean))
/*      */       {
/* 1289 */         Method ejbFindByPrimaryKey = getEJBFindByPrimaryKey(bean);
/*      */ 
/* 1291 */         if (!hasPrimaryKeyReturnType(entity, ejbFindByPrimaryKey))
/*      */         {
/* 1293 */           fireSpecViolationEvent(entity, ejbFindByPrimaryKey, new Section("9.2.5.b"));
/* 1294 */           status = false;
/*      */         }
/*      */ 
/* 1297 */         if (!isSingleObjectFinder(entity, ejbFindByPrimaryKey))
/*      */         {
/* 1299 */           fireSpecViolationEvent(entity, ejbFindByPrimaryKey, new Section("9.2.5.c"));
/* 1300 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1320 */       if (hasFinderMethod(bean))
/*      */       {
/* 1322 */         Iterator it = getEJBFindMethods(bean);
/* 1323 */         while (it.hasNext())
/*      */         {
/* 1325 */           Method finder = (Method)it.next();
/*      */ 
/* 1327 */           if (!isPublic(finder))
/*      */           {
/* 1329 */             fireSpecViolationEvent(entity, finder, new Section("9.2.5.d"));
/* 1330 */             status = false;
/*      */           }
/*      */ 
/* 1333 */           if (isFinal(finder))
/*      */           {
/* 1335 */             fireSpecViolationEvent(entity, finder, new Section("9.2.5.e"));
/* 1336 */             status = false;
/*      */           }
/*      */ 
/* 1339 */           if (isStatic(finder))
/*      */           {
/* 1341 */             fireSpecViolationEvent(entity, finder, new Section("9.2.5.f"));
/* 1342 */             status = false;
/*      */           }
/*      */ 
/* 1345 */           if (!hasLegalRMIIIOPArguments(finder))
/*      */           {
/* 1347 */             fireSpecViolationEvent(entity, finder, new Section("9.2.5.g"));
/* 1348 */             status = false;
/*      */           }
/*      */ 
/* 1351 */           if ((!isSingleObjectFinder(entity, finder)) && (!isMultiObjectFinder(finder)))
/*      */           {
/* 1354 */             fireSpecViolationEvent(entity, finder, new Section("9.2.5.h"));
/* 1355 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/* 1369 */       fireSpecViolationEvent(entity, new Section("16.2.b"));
/* 1370 */       status = false;
/*      */     }
/*      */ 
/* 1373 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyPrimaryKey(EntityMetaData entity)
/*      */   {
/* 1378 */     boolean status = true;
/*      */ 
/* 1380 */     if ((entity.getPrimaryKeyClass() == null) || (entity.getPrimaryKeyClass().length() == 0))
/*      */     {
/* 1383 */       fireSpecViolationEvent(entity, new Section("16.5.a"));
/* 1384 */       return false;
/*      */     }
/*      */ 
/* 1387 */     if ((entity.getPrimKeyField() == null) || (entity.getPrimKeyField().length() == 0))
/*      */     {
/* 1390 */       Class cls = null;
/*      */       try
/*      */       {
/* 1394 */         cls = this.classloader.loadClass(entity.getPrimaryKeyClass());
/*      */ 
/* 1396 */         if (entity.isCMP())
/*      */         {
/* 1398 */           if (!isPublic(cls))
/*      */           {
/* 1400 */             fireSpecViolationEvent(entity, new Section("9.4.7.2.a"));
/* 1401 */             status = false;
/*      */           }
/*      */ 
/* 1404 */           if (!isAllFieldsPublic(cls))
/*      */           {
/* 1406 */             fireSpecViolationEvent(entity, new Section("9.4.7.2.b"));
/* 1407 */             status = false;
/*      */           }
/*      */ 
/* 1410 */           if (!hasANonStaticField(cls))
/*      */           {
/* 1412 */             fireSpecViolationEvent(entity, new Section("9.4.7.2.c"));
/* 1413 */             status = false;
/*      */           }
/*      */         }
/*      */ 
/* 1417 */         if (!cls.getName().equals("java.lang.Object"))
/*      */         {
/*      */           try
/*      */           {
/* 1422 */             Object one = cls.newInstance();
/* 1423 */             Object two = cls.newInstance();
/*      */             try
/*      */             {
/* 1426 */               if (!one.equals(two))
/*      */               {
/* 1428 */                 fireSpecViolationEvent(entity, new Section("9.2.9.b"));
/* 1429 */                 status = false;
/*      */               }
/*      */             }
/*      */             catch (NullPointerException e)
/*      */             {
/*      */             }
/*      */             try
/*      */             {
/* 1437 */               if (one.hashCode() != two.hashCode())
/*      */               {
/* 1439 */                 fireSpecViolationEvent(entity, new Section("9.2.9.c"));
/* 1440 */                 status = false;
/*      */               }
/*      */ 
/*      */             }
/*      */             catch (NullPointerException e)
/*      */             {
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (IllegalAccessException e)
/*      */           {
/*      */           }
/*      */           catch (InstantiationException e)
/*      */           {
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/* 1466 */         fireSpecViolationEvent(entity, new Section("16.2.e"));
/* 1467 */         status = false;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1472 */       if (entity.isBMP())
/*      */       {
/* 1474 */         fireSpecViolationEvent(entity, new Section("9.4.7.1.a"));
/* 1475 */         status = false;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1480 */         Class fieldClass = this.classloader.loadClass(entity.getEjbClass());
/* 1481 */         Field field = null;
/*      */         try
/*      */         {
/* 1484 */           field = fieldClass.getField(entity.getPrimKeyField());
/* 1485 */           if (!entity.getPrimaryKeyClass().equals(field.getType().getName()))
/*      */           {
/* 1487 */             fireSpecViolationEvent(entity, new Section("9.4.7.1.c"));
/* 1488 */             status = false;
/*      */           }
/*      */ 
/* 1491 */           Iterator it = entity.getCMPFields();
/* 1492 */           boolean found = false;
/* 1493 */           while (it.hasNext())
/*      */           {
/* 1495 */             String fieldName = (String)it.next();
/* 1496 */             if (fieldName.equals(entity.getPrimKeyField()))
/*      */             {
/* 1498 */               found = true;
/* 1499 */               break;
/*      */             }
/*      */           }
/*      */ 
/* 1503 */           if (!found)
/*      */           {
/* 1505 */             fireSpecViolationEvent(entity, new Section("9.4.7.1.d"));
/* 1506 */             status = false;
/*      */           }
/*      */         }
/*      */         catch (NoSuchFieldException e)
/*      */         {
/* 1511 */           fireSpecViolationEvent(entity, new Section("9.4.7.1.b"));
/* 1512 */           status = false;
/*      */         }
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/*      */       }
/*      */     }
/*      */ 
/* 1520 */     return status;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.verifier.strategy.EJBVerifier11
 * JD-Core Version:    0.6.0
 */