/*      */ package org.jboss.verifier.strategy;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.lang.reflect.Constructor;
/*      */ import java.lang.reflect.Field;
/*      */ import java.lang.reflect.Member;
/*      */ import java.lang.reflect.Method;
/*      */ import java.lang.reflect.Modifier;
/*      */ import java.net.URL;
/*      */ import java.net.URLClassLoader;
/*      */ import java.rmi.Remote;
/*      */ import java.rmi.RemoteException;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedList;
/*      */ import java.util.List;
/*      */ import javax.jms.Message;
/*      */ import org.gjt.lindfors.pattern.StrategyContext;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.metadata.BeanMetaData;
/*      */ import org.jboss.metadata.EntityMetaData;
/*      */ import org.jboss.metadata.MessageDrivenMetaData;
/*      */ import org.jboss.util.Classes;
/*      */ import org.jboss.verifier.Section;
/*      */ import org.jboss.verifier.event.VerificationEvent;
/*      */ import org.jboss.verifier.factory.DefaultEventFactory;
/*      */ import org.jboss.verifier.factory.VerificationEventFactory;
/*      */ import org.omg.CORBA.portable.IDLEntity;
/*      */ 
/*      */ public abstract class AbstractVerifier
/*      */   implements VerificationStrategy
/*      */ {
/*   72 */   static final Logger log = Logger.getLogger(AbstractVerifier.class);
/*      */   protected static final String EJB_OBJECT_INTERFACE = "javax.ejb.EJBObject";
/*      */   protected static final String EJB_HOME_INTERFACE = "javax.ejb.EJBHome";
/*      */   protected static final String EJB_LOCAL_OBJECT_INTERFACE = "javax.ejb.EJBLocalObject";
/*      */   protected static final String EJB_LOCAL_HOME_INTERFACE = "javax.ejb.EJBLocalHome";
/*   94 */   protected ClassLoader classloader = null;
/*      */ 
/*  103 */   private VerificationEventFactory factory = null;
/*      */ 
/*  112 */   private VerificationContext context = null;
/*      */   public static final String BEAN_MANAGED_TX = "Bean";
/*      */   public static final String CONTAINER_MANAGED_TX = "Container";
/*      */   public static final String STATEFUL_SESSION = "Stateful";
/*      */   public static final String STATELESS_SESSION = "Stateless";
/*      */   private static final String EJB_FIND_BY_PRIMARY_KEY = "ejbFindByPrimaryKey";
/*      */   protected static final String EJB_CREATE_METHOD = "ejbCreate";
/*      */   protected static final String EJB_REMOVE_METHOD = "ejbRemove";
/*      */   private static final String EJB_POST_CREATE_METHOD = "ejbPostCreate";
/*      */   protected static final String CREATE_METHOD = "create";
/*      */   protected static final String EJB_HOME_METHOD = "ejbHome";
/*      */   protected static final String EJB_SELECT_METHOD = "ejbSelect";
/*      */   private static final String FINALIZE_METHOD = "finalize";
/*      */   private static final String REMOVE_METHOD = "remove";
/*      */   private static final String GET_HOME_HANDLE_METHOD = "getHomeHandle";
/*      */   private static final String GET_EJB_METADATA_METHOD = "getEJBMetaData";
/*      */ 
/*      */   public AbstractVerifier(VerificationContext context)
/*      */   {
/*  121 */     this.context = context;
/*  122 */     this.classloader = context.getClassLoader();
/*  123 */     this.factory = new DefaultEventFactory(getMessageBundle());
/*      */ 
/*  125 */     if (this.classloader == null)
/*      */     {
/*  127 */       URL[] list = { context.getJarLocation() };
/*      */ 
/*  129 */       ClassLoader parent = Thread.currentThread().getContextClassLoader();
/*  130 */       this.classloader = new URLClassLoader(list, parent);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isAssignableFrom(String className, Class assignableFromClass)
/*      */   {
/*      */     try
/*      */     {
/*  147 */       Class clazz = this.classloader.loadClass(className);
/*  148 */       return clazz.isAssignableFrom(assignableFromClass);
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  152 */       log.warn("Failed to find class: " + className, e);
/*      */     }
/*  154 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean isAssignableFrom(Class clazz, String assignableFromClassName)
/*      */   {
/*      */     try
/*      */     {
/*  161 */       Class assignableFromClass = this.classloader.loadClass(assignableFromClassName);
/*  162 */       return clazz.isAssignableFrom(assignableFromClass);
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  166 */       log.warn("Failed to find class: " + assignableFromClassName, e);
/*      */     }
/*  168 */     return false;
/*      */   }
/*      */   public abstract String getMessageBundle();
/*      */ 
/*      */   public abstract boolean isCreateMethod(Method paramMethod);
/*      */ 
/*      */   public abstract boolean isEjbCreateMethod(Method paramMethod);
/*      */ 
/*  179 */   public boolean hasLegalRMIIIOPArguments(Method method) { Class[] params = method.getParameterTypes();
/*      */ 
/*  181 */     for (int i = 0; i < params.length; i++)
/*      */     {
/*  183 */       if (!isRMIIIOPType(params[i])) {
/*  184 */         return false;
/*      */       }
/*      */     }
/*  187 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean hasLegalRMIIIOPReturnType(Method method)
/*      */   {
/*  192 */     return isRMIIIOPType(method.getReturnType());
/*      */   }
/*      */ 
/*      */   public boolean hasLegalRMIIIOPExceptionTypes(Method method)
/*      */   {
/*  205 */     Iterator it = Arrays.asList(method.getExceptionTypes()).iterator();
/*  206 */     while (it.hasNext())
/*      */     {
/*  208 */       Class exception = (Class)it.next();
/*      */ 
/*  210 */       if (!isRMIIDLExceptionType(exception)) {
/*  211 */         return false;
/*      */       }
/*      */     }
/*  214 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean throwsRemoteException(Method method)
/*      */   {
/*  225 */     Class[] exception = method.getExceptionTypes();
/*      */ 
/*  227 */     for (int i = 0; i < exception.length; i++)
/*      */     {
/*  231 */       if ((exception[i].equals(IOException.class)) || (exception[i].equals(Exception.class)))
/*      */       {
/*      */         continue;
/*      */       }
/*      */ 
/*  241 */       if (isAssignableFrom(exception[i], "java.rmi.RemoteException"))
/*      */       {
/*  243 */         return true;
/*      */       }
/*      */     }
/*      */ 
/*  247 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasSingleArgument(Method method, Class argClass)
/*      */   {
/*  255 */     Class[] params = method.getParameterTypes();
/*  256 */     if (params.length == 1)
/*      */     {
/*  258 */       if (params[0].equals(argClass)) {
/*  259 */         return true;
/*      */       }
/*      */     }
/*  262 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasNoArguments(Method method)
/*      */   {
/*  270 */     Class[] params = method.getParameterTypes();
/*  271 */     return params.length == 0;
/*      */   }
/*      */ 
/*      */   public boolean throwsNoException(Method method)
/*      */   {
/*  279 */     boolean hasCheckedException = false;
/*  280 */     Class[] exceptions = method.getExceptionTypes();
/*  281 */     for (int e = 0; e < exceptions.length; e++)
/*      */     {
/*  283 */       Class ex = exceptions[e];
/*  284 */       boolean isError = Error.class.isAssignableFrom(ex);
/*  285 */       boolean isRuntimeException = RuntimeException.class.isAssignableFrom(ex);
/*  286 */       boolean isRemoteException = RemoteException.class.isAssignableFrom(ex);
/*  287 */       if ((!isError) && (!isRuntimeException) && (!isRemoteException))
/*  288 */         hasCheckedException = true;
/*      */     }
/*  290 */     return !hasCheckedException;
/*      */   }
/*      */ 
/*      */   public boolean throwsCreateException(Method method)
/*      */   {
/*  299 */     Class[] exception = method.getExceptionTypes();
/*  300 */     for (int i = 0; i < exception.length; i++)
/*      */     {
/*  302 */       if (isAssignableFrom("javax.ejb.CreateException", exception[i])) {
/*  303 */         return true;
/*      */       }
/*      */     }
/*  306 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean throwsFinderException(Method method)
/*      */   {
/*  315 */     Class[] exception = method.getExceptionTypes();
/*      */ 
/*  317 */     for (int i = 0; i < exception.length; i++)
/*      */     {
/*  319 */       if (isAssignableFrom("javax.ejb.FinderException", exception[i])) {
/*  320 */         return true;
/*      */       }
/*      */     }
/*  323 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean isStatic(Member member)
/*      */   {
/*  332 */     return Modifier.isStatic(member.getModifiers());
/*      */   }
/*      */ 
/*      */   public boolean isStatic(Class c)
/*      */   {
/*  340 */     return Modifier.isStatic(c.getModifiers());
/*      */   }
/*      */ 
/*      */   public boolean isFinal(Member member)
/*      */   {
/*  349 */     return Modifier.isFinal(member.getModifiers());
/*      */   }
/*      */ 
/*      */   public boolean isFinal(Class c)
/*      */   {
/*  357 */     return Modifier.isFinal(c.getModifiers());
/*      */   }
/*      */ 
/*      */   public boolean isPublic(Member member)
/*      */   {
/*  366 */     return Modifier.isPublic(member.getModifiers());
/*      */   }
/*      */ 
/*      */   public boolean isPublic(Class c)
/*      */   {
/*  374 */     return Modifier.isPublic(c.getModifiers());
/*      */   }
/*      */ 
/*      */   public boolean isAllFieldsPublic(Class c)
/*      */   {
/*      */     try
/*      */     {
/*  384 */       Field[] list = c.getFields();
/*  385 */       for (int i = 0; i < list.length; i++)
/*      */       {
/*  387 */         if (!Modifier.isPublic(list[i].getModifiers()))
/*  388 */           return false;
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  393 */       return false;
/*      */     }
/*      */ 
/*  396 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean isAbstract(Class c)
/*      */   {
/*  404 */     return Modifier.isAbstract(c.getModifiers());
/*      */   }
/*      */ 
/*      */   public boolean isAbstract(Method m)
/*      */   {
/*  412 */     return Modifier.isAbstract(m.getModifiers());
/*      */   }
/*      */ 
/*      */   public boolean isSingleObjectFinder(EntityMetaData entity, Method finder)
/*      */   {
/*  421 */     return hasPrimaryKeyReturnType(entity, finder);
/*      */   }
/*      */ 
/*      */   public boolean isMultiObjectFinder(Method f)
/*      */   {
/*  429 */     return (Collection.class.isAssignableFrom(f.getReturnType())) || (Enumeration.class.isAssignableFrom(f.getReturnType()));
/*      */   }
/*      */ 
/*      */   public boolean hasRemoteReturnType(BeanMetaData bean, Method m)
/*      */   {
/*      */     try
/*      */     {
/*  440 */       Class clazz = this.classloader.loadClass(bean.getRemote());
/*  441 */       return m.getReturnType().isAssignableFrom(clazz);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*      */     }
/*  446 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasLocalReturnType(BeanMetaData bean, Method m)
/*      */   {
/*      */     try
/*      */     {
/*  457 */       Class clazz = this.classloader.loadClass(bean.getLocal());
/*  458 */       return m.getReturnType().isAssignableFrom(clazz);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*      */     }
/*  463 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasVoidReturnType(Method method)
/*      */   {
/*  472 */     return method.getReturnType() == Void.TYPE;
/*      */   }
/*      */ 
/*      */   public boolean hasMessageDrivenBeanInterface(Class c)
/*      */   {
/*  480 */     return isAssignableFrom("javax.ejb.MessageDrivenBean", c);
/*      */   }
/*      */ 
/*      */   public boolean hasMessageListenerInterface(Class c)
/*      */   {
/*  488 */     return isAssignableFrom("javax.jms.MessageListener", c);
/*      */   }
/*      */ 
/*      */   public boolean hasSessionBeanInterface(Class c)
/*      */   {
/*  496 */     return isAssignableFrom("javax.ejb.SessionBean", c);
/*      */   }
/*      */ 
/*      */   public boolean hasEntityBeanInterface(Class c)
/*      */   {
/*  504 */     return isAssignableFrom("javax.ejb.EntityBean", c);
/*      */   }
/*      */ 
/*      */   public boolean hasEJBObjectInterface(Class c)
/*      */   {
/*  512 */     return isAssignableFrom("javax.ejb.EJBObject", c);
/*      */   }
/*      */ 
/*      */   public boolean hasEJBLocalObjectInterface(Class c)
/*      */   {
/*  520 */     return isAssignableFrom("javax.ejb.EJBLocalObject", c);
/*      */   }
/*      */ 
/*      */   public boolean hasEJBHomeInterface(Class c)
/*      */   {
/*  529 */     return isAssignableFrom("javax.ejb.EJBHome", c);
/*      */   }
/*      */ 
/*      */   public boolean hasEJBLocalHomeInterface(Class c)
/*      */   {
/*  538 */     return isAssignableFrom("javax.ejb.EJBLocalHome", c);
/*      */   }
/*      */ 
/*      */   public boolean hasSessionSynchronizationInterface(Class c)
/*      */   {
/*  546 */     return isAssignableFrom("javax.ejb.SessionSynchronization", c);
/*      */   }
/*      */ 
/*      */   public boolean hasDefaultConstructor(Class c)
/*      */   {
/*      */     try
/*      */     {
/*  556 */       ctr = c.getConstructor(new Class[0]);
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/*      */       Constructor ctr;
/*  560 */       if (log.isTraceEnabled())
/*      */       {
/*  562 */         StringBuffer tmp = new StringBuffer("hasDefaultConstructor(");
/*  563 */         tmp.append(") failure, ");
/*  564 */         Classes.displayClassInfo(c, tmp);
/*  565 */         log.trace(tmp.toString(), e);
/*      */       }
/*  567 */       return false;
/*      */     }
/*      */ 
/*  570 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean hasFinalizer(Class c)
/*      */   {
/*      */     try
/*      */     {
/*  580 */       finalizer = c.getDeclaredMethod("finalize", new Class[0]);
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/*      */       Method finalizer;
/*  584 */       return false;
/*      */     }
/*      */ 
/*  587 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean hasFinderMethod(Class c)
/*      */   {
/*  595 */     Method[] method = c.getMethods();
/*  596 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  598 */       if (method[i].getName().startsWith("ejbFind")) {
/*  599 */         return true;
/*      */       }
/*      */     }
/*  602 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean isFinderMethod(Method m)
/*      */   {
/*  610 */     return m.getName().startsWith("find");
/*      */   }
/*      */ 
/*      */   public boolean isOnMessageMethod(Method m)
/*      */   {
/*  618 */     if ("onMessage".equals(m.getName()))
/*      */     {
/*  620 */       Class[] paramTypes = m.getParameterTypes();
/*  621 */       if (paramTypes.length == 1)
/*      */       {
/*  623 */         if (Message.class.equals(paramTypes[0]))
/*  624 */           return true;
/*      */       }
/*      */     }
/*  627 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasANonStaticField(Class c)
/*      */   {
/*      */     try
/*      */     {
/*  637 */       Field[] list = c.getFields();
/*  638 */       for (int i = 0; i < list.length; i++)
/*      */       {
/*  640 */         if (!Modifier.isStatic(list[i].getModifiers())) {
/*  641 */           return true;
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (Exception ignored)
/*      */     {
/*      */     }
/*  648 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasOnMessageMethod(Class c)
/*      */   {
/*  656 */     Method[] method = c.getMethods();
/*  657 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  659 */       if (isOnMessageMethod(method[i])) {
/*  660 */         return true;
/*      */       }
/*      */     }
/*  663 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasCreateMethod(Class c)
/*      */   {
/*  671 */     Method[] method = c.getMethods();
/*      */ 
/*  673 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  675 */       if (isCreateMethod(method[i])) {
/*  676 */         return true;
/*      */       }
/*      */     }
/*  679 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasEJBCreateMethod(Class c, boolean isSession)
/*      */   {
/*  687 */     Method[] method = c.getMethods();
/*  688 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  690 */       if (!isEjbCreateMethod(method[i]))
/*      */         continue;
/*  692 */       if ((!isStatic(method[i])) && (!isFinal(method[i])) && (((isSession) && (hasVoidReturnType(method[i]))) || (!isSession)))
/*      */       {
/*  697 */         return true;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  702 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasDefaultCreateMethod(Class home)
/*      */   {
/*  711 */     Method[] method = home.getMethods();
/*      */ 
/*  713 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  715 */       if (!isCreateMethod(method[i]))
/*      */         continue;
/*  717 */       Class[] params = method[i].getParameterTypes();
/*  718 */       if (params.length == 0) {
/*  719 */         return true;
/*      */       }
/*      */     }
/*      */ 
/*  723 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasEJBFindByPrimaryKey(Class c)
/*      */   {
/*  731 */     Method[] method = c.getMethods();
/*  732 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  734 */       if (method[i].getName().equals("ejbFindByPrimaryKey")) {
/*  735 */         return true;
/*      */       }
/*      */     }
/*  738 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasPrimaryKeyReturnType(EntityMetaData entity, Method m)
/*      */   {
/*      */     try
/*      */     {
/*  749 */       return m.getReturnType().isAssignableFrom(this.classloader.loadClass(entity.getPrimaryKeyClass()));
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*      */     }
/*      */ 
/*  755 */     return m.getReturnType().getName().equals(entity.getPrimaryKeyClass());
/*      */   }
/*      */ 
/*      */   public Method getDefaultCreateMethod(Class c)
/*      */   {
/*  766 */     Method method = null;
/*      */     try
/*      */     {
/*  770 */       method = c.getMethod("create", null);
/*      */     }
/*      */     catch (NoSuchMethodException ignored)
/*      */     {
/*      */     }
/*      */ 
/*  776 */     return method;
/*      */   }
/*      */ 
/*      */   public Method getEJBFindByPrimaryKey(Class c)
/*      */   {
/*  784 */     Method[] method = c.getMethods();
/*  785 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  787 */       if (method[i].getName().equals("ejbFindByPrimaryKey")) {
/*  788 */         return method[i];
/*      */       }
/*      */     }
/*  791 */     return null;
/*      */   }
/*      */ 
/*      */   public Iterator getEJBFindMethods(Class c)
/*      */   {
/*  799 */     List finders = new LinkedList();
/*  800 */     Method[] method = c.getMethods();
/*  801 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  803 */       if (method[i].getName().startsWith("ejbFind")) {
/*  804 */         finders.add(method[i]);
/*      */       }
/*      */     }
/*  807 */     return finders.iterator();
/*      */   }
/*      */ 
/*      */   public Iterator getFinderMethods(Class home)
/*      */   {
/*  816 */     List finders = new LinkedList();
/*  817 */     Method[] method = home.getMethods();
/*      */ 
/*  819 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  821 */       if (method[i].getName().startsWith("find")) {
/*  822 */         finders.add(method[i]);
/*      */       }
/*      */     }
/*  825 */     return finders.iterator();
/*      */   }
/*      */ 
/*      */   public Iterator getOnMessageMethods(Class c)
/*      */   {
/*  833 */     List onMessages = new LinkedList();
/*  834 */     Method[] method = c.getMethods();
/*      */ 
/*  836 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  838 */       if (isOnMessageMethod(method[i])) {
/*  839 */         onMessages.add(method[i]);
/*      */       }
/*      */     }
/*  842 */     return onMessages.iterator();
/*      */   }
/*      */ 
/*      */   public Iterator getEJBCreateMethods(Class c)
/*      */   {
/*  850 */     List ejbCreates = new LinkedList();
/*  851 */     Method[] method = c.getMethods();
/*      */ 
/*  853 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  855 */       if (isEjbCreateMethod(method[i])) {
/*  856 */         ejbCreates.add(method[i]);
/*      */       }
/*      */     }
/*  859 */     return ejbCreates.iterator();
/*      */   }
/*      */ 
/*      */   public Iterator getCreateMethods(Class c)
/*      */   {
/*  867 */     List creates = new LinkedList();
/*  868 */     Method[] method = c.getMethods();
/*      */ 
/*  870 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  872 */       if (isCreateMethod(method[i])) {
/*  873 */         creates.add(method[i]);
/*      */       }
/*      */     }
/*  876 */     return creates.iterator();
/*      */   }
/*      */ 
/*      */   public boolean hasMoreThanOneCreateMethods(Class c)
/*      */   {
/*  884 */     int count = 0;
/*  885 */     Method[] method = c.getMethods();
/*  886 */     for (int i = 0; i < method.length; i++)
/*      */     {
/*  888 */       if (!isCreateMethod(method[i]))
/*      */         continue;
/*  890 */       count++;
/*      */     }
/*      */ 
/*  894 */     return count > 1;
/*      */   }
/*      */ 
/*      */   public boolean hasMatchingExceptions(Method source, Method target)
/*      */   {
/*  903 */     Class[] a = source.getExceptionTypes();
/*  904 */     Class[] b = target.getExceptionTypes();
/*  905 */     Class rteClass = null;
/*  906 */     Class errorClass = null;
/*      */     try
/*      */     {
/*  910 */       rteClass = this.classloader.loadClass("java.lang.RuntimeException");
/*  911 */       errorClass = this.classloader.loadClass("java.lang.Error");
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*      */     }
/*      */ 
/*  918 */     for (int i = 0; i < a.length; i++)
/*      */     {
/*  920 */       if ((rteClass.isAssignableFrom(a[i])) || (errorClass.isAssignableFrom(a[i])))
/*      */       {
/*      */         continue;
/*      */       }
/*      */ 
/*  928 */       boolean found = false;
/*  929 */       for (int j = 0; j < b.length; j++)
/*      */       {
/*  931 */         if (!b[j].isAssignableFrom(a[i]))
/*      */           continue;
/*  933 */         found = true;
/*  934 */         break;
/*      */       }
/*      */ 
/*  938 */       if (!found)
/*      */       {
/*  940 */         return false;
/*      */       }
/*      */     }
/*      */ 
/*  944 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean hasMatchingMethod(Class bean, Method method)
/*      */   {
/*      */     try
/*      */     {
/*  954 */       bean.getMethod(method.getName(), method.getParameterTypes());
/*  955 */       return true;
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/*  959 */       if (log.isTraceEnabled())
/*      */       {
/*  961 */         StringBuffer tmp = new StringBuffer("hasMatchingMethod(");
/*  962 */         tmp.append(method.toString());
/*  963 */         tmp.append(") failure, ");
/*  964 */         Classes.displayClassInfo(bean, tmp);
/*  965 */         log.trace(tmp.toString(), e);
/*      */       }
/*      */     }
/*  967 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasMatchingReturnType(Method a, Method b)
/*      */   {
/*  976 */     return a.getReturnType() == b.getReturnType();
/*      */   }
/*      */ 
/*      */   public boolean hasMatchingEJBPostCreate(Class bean, Method create)
/*      */   {
/*      */     try
/*      */     {
/*  987 */       return bean.getMethod(getMatchingEJBPostCreateName(create.getName()), create.getParameterTypes()) != null;
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/*  992 */       if (log.isTraceEnabled())
/*      */       {
/*  994 */         StringBuffer tmp = new StringBuffer("hasMatchingEJBPostCreate(");
/*  995 */         tmp.append(create.toString());
/*  996 */         tmp.append(") failure, ");
/*  997 */         Classes.displayClassInfo(bean, tmp);
/*  998 */         log.trace(tmp.toString(), e);
/*      */       }
/*      */     }
/* 1000 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasMatchingEJBCreate(Class bean, Method create)
/*      */   {
/*      */     try
/*      */     {
/* 1008 */       return bean.getMethod(getMatchingEJBCreateName(create.getName()), create.getParameterTypes()) != null;
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/* 1012 */       if (log.isTraceEnabled())
/*      */       {
/* 1014 */         StringBuffer tmp = new StringBuffer("hasMatchingEJBCreate(");
/* 1015 */         tmp.append(create.toString());
/* 1016 */         tmp.append(") failure, ");
/* 1017 */         Classes.displayClassInfo(bean, tmp);
/* 1018 */         log.trace(tmp.toString(), e);
/*      */       }
/*      */     }
/* 1020 */     return false;
/*      */   }
/*      */ 
/*      */   public Method getMatchingEJBPostCreate(Class bean, Method create)
/*      */   {
/*      */     try
/*      */     {
/* 1028 */       return bean.getMethod(getMatchingEJBPostCreateName(create.getName()), create.getParameterTypes());
/*      */     }
/*      */     catch (NoSuchMethodException e) {
/*      */     }
/* 1032 */     return null;
/*      */   }
/*      */ 
/*      */   public Method getMatchingEJBCreate(Class bean, Method create)
/*      */   {
/*      */     try
/*      */     {
/* 1040 */       return bean.getMethod(getMatchingEJBCreateName(create.getName()), create.getParameterTypes());
/*      */     }
/*      */     catch (NoSuchMethodException e) {
/*      */     }
/* 1044 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean hasMatchingEJBFind(Class bean, Method finder)
/*      */   {
/*      */     try
/*      */     {
/* 1052 */       String methodName = "ejbF" + finder.getName().substring(1);
/* 1053 */       return bean.getMethod(methodName, finder.getParameterTypes()) != null;
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/* 1057 */       if (log.isTraceEnabled())
/*      */       {
/* 1059 */         StringBuffer tmp = new StringBuffer("hasMatchingEJBFind(");
/* 1060 */         tmp.append(finder.toString());
/* 1061 */         tmp.append(") failure, ");
/* 1062 */         Classes.displayClassInfo(bean, tmp);
/* 1063 */         log.trace(tmp.toString(), e);
/*      */       }
/*      */     }
/* 1065 */     return false;
/*      */   }
/*      */ 
/*      */   public Method getMatchingEJBFind(Class bean, Method finder)
/*      */   {
/*      */     try
/*      */     {
/* 1073 */       String methodName = "ejbF" + finder.getName().substring(1);
/* 1074 */       return bean.getMethod(methodName, finder.getParameterTypes());
/*      */     }
/*      */     catch (NoSuchMethodException e) {
/*      */     }
/* 1078 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean hasMatchingEJBHome(Class bean, Method home)
/*      */   {
/*      */     try
/*      */     {
/* 1086 */       return bean.getMethod(getMatchingEJBHomeName(home.getName()), home.getParameterTypes()) != null;
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/* 1090 */       if (log.isTraceEnabled())
/*      */       {
/* 1092 */         StringBuffer tmp = new StringBuffer("hasMatchingEJBHome(");
/* 1093 */         tmp.append(home.toString());
/* 1094 */         tmp.append(") failure, ");
/* 1095 */         Classes.displayClassInfo(bean, tmp);
/* 1096 */         log.trace(tmp.toString(), e);
/*      */       }
/*      */     }
/* 1098 */     return false;
/*      */   }
/*      */ 
/*      */   protected void fireSpecViolationEvent(BeanMetaData bean, Section section)
/*      */   {
/* 1113 */     fireSpecViolationEvent(bean, null, section);
/*      */   }
/*      */ 
/*      */   protected void fireSpecViolationEvent(BeanMetaData bean, Method method, Section section)
/*      */   {
/* 1119 */     VerificationEvent event = this.factory.createSpecViolationEvent(this.context, section);
/*      */ 
/* 1121 */     event.setName(bean.getEjbName());
/* 1122 */     event.setMethod(method);
/*      */ 
/* 1124 */     this.context.fireSpecViolation(event);
/*      */   }
/*      */ 
/*      */   protected final void fireBeanVerifiedEvent(BeanMetaData bean)
/*      */   {
/* 1129 */     fireBeanVerifiedEvent(bean, null);
/*      */   }
/*      */ 
/*      */   protected final void fireBeanVerifiedEvent(BeanMetaData bean, String msg)
/*      */   {
/* 1134 */     VerificationEvent event = this.factory.createBeanVerifiedEvent(this.context);
/* 1135 */     event.setName(bean.getEjbName());
/*      */ 
/* 1137 */     if (msg != null)
/*      */     {
/* 1139 */       event.setMessage(msg);
/*      */     }
/*      */ 
/* 1142 */     this.context.fireBeanChecked(event);
/*      */   }
/*      */ 
/*      */   public void checkMessageBean(MessageDrivenMetaData bean)
/*      */   {
/*      */   }
/*      */ 
/*      */   public StrategyContext getContext()
/*      */   {
/* 1170 */     return this.context;
/*      */   }
/*      */ 
/*      */   protected boolean isRMIIIOPType(Class type)
/*      */   {
/* 1214 */     if (type.isPrimitive()) {
/* 1215 */       return true;
/*      */     }
/*      */ 
/* 1222 */     if (type.isArray()) {
/* 1223 */       return isRMIIIOPType(type.getComponentType());
/*      */     }
/*      */ 
/* 1230 */     if (org.omg.CORBA.Object.class.isAssignableFrom(type)) {
/* 1231 */       return true;
/*      */     }
/*      */ 
/* 1238 */     if (IDLEntity.class.isAssignableFrom(type)) {
/* 1239 */       return true;
/*      */     }
/*      */ 
/* 1246 */     if (isRMIIDLRemoteInterface(type)) {
/* 1247 */       return true;
/*      */     }
/*      */ 
/* 1254 */     if (isRMIIDLExceptionType(type)) {
/* 1255 */       return true;
/*      */     }
/*      */ 
/* 1263 */     return isRMIIDLValueType(type);
/*      */   }
/*      */ 
/*      */   private boolean isRMIIDLRemoteInterface(Class type)
/*      */   {
/* 1275 */     if (!Remote.class.isAssignableFrom(type)) {
/* 1276 */       return false;
/*      */     }
/* 1278 */     Iterator methodIterator = Arrays.asList(type.getMethods()).iterator();
/* 1279 */     while (methodIterator.hasNext())
/*      */     {
/* 1281 */       Method m = (Method)methodIterator.next();
/*      */ 
/* 1289 */       if (!throwsRemoteException(m)) {
/* 1290 */         return false;
/*      */       }
/*      */ 
/* 1299 */       Iterator it = Arrays.asList(m.getExceptionTypes()).iterator();
/* 1300 */       while (it.hasNext())
/*      */       {
/* 1302 */         Class exception = (Class)it.next();
/* 1303 */         if (!isRMIIDLExceptionType(exception)) {
/* 1304 */           return false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1314 */     Iterator fieldIterator = Arrays.asList(type.getFields()).iterator();
/* 1315 */     while (fieldIterator.hasNext())
/*      */     {
/* 1317 */       Field f = (Field)fieldIterator.next();
/*      */ 
/* 1319 */       if ((!f.getType().isPrimitive()) && 
/* 1322 */         (!f.getType().equals(String.class)))
/*      */       {
/* 1325 */         return false;
/*      */       }
/*      */     }
/* 1328 */     return true;
/*      */   }
/*      */ 
/*      */   private boolean isRMIIDLExceptionType(Class type)
/*      */   {
/* 1339 */     if (!Throwable.class.isAssignableFrom(type)) {
/* 1340 */       return false;
/*      */     }
/* 1342 */     if (Error.class.isAssignableFrom(type)) {
/* 1343 */       return false;
/*      */     }
/*      */ 
/* 1354 */     return isRMIIDLValueType(type);
/*      */   }
/*      */ 
/*      */   protected boolean isRMIIDLValueType(Class type)
/*      */   {
/* 1367 */     if (Remote.class.isAssignableFrom(type)) {
/* 1368 */       return false;
/*      */     }
/*      */ 
/* 1376 */     if ((type.getDeclaringClass() != null) && (!isStatic(type)))
/*      */     {
/* 1378 */       if (!isRMIIDLValueType(type.getDeclaringClass())) {
/* 1379 */         return false;
/*      */       }
/*      */     }
/* 1382 */     return true;
/*      */   }
/*      */ 
/*      */   private String getMatchingEJBHomeName(String homeName)
/*      */   {
/* 1387 */     return "ejbHome" + homeName.substring(0, 1).toUpperCase() + homeName.substring(1);
/*      */   }
/*      */ 
/*      */   private String getMatchingEJBCreateName(String createName)
/*      */   {
/* 1393 */     return "ejb" + createName.substring(0, 1).toUpperCase() + createName.substring(1);
/*      */   }
/*      */ 
/*      */   private String getMatchingEJBPostCreateName(String createName)
/*      */   {
/* 1399 */     int createIdx = createName.indexOf("Create");
/* 1400 */     return "ejbPost" + createName.substring(createIdx >= 0 ? createIdx : 0);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.verifier.strategy.AbstractVerifier
 * JD-Core Version:    0.6.0
 */