/*     */ package org.jboss.util.xml.catalog.readers;
/*     */ 
/*     */ import java.util.Stack;
/*     */ import java.util.Vector;
/*     */ import org.jboss.util.xml.catalog.Catalog;
/*     */ import org.jboss.util.xml.catalog.CatalogEntry;
/*     */ import org.jboss.util.xml.catalog.CatalogException;
/*     */ import org.jboss.util.xml.catalog.Resolver;
/*     */ import org.jboss.util.xml.catalog.helpers.Debug;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class ExtendedXMLCatalogReader extends OASISXMLCatalogReader
/*     */ {
/*     */   public static final String extendedNamespaceName = "http://nwalsh.com/xcatalog/1.0";
/*     */ 
/*     */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/* 105 */     boolean inExtension = inExtensionNamespace();
/*     */ 
/* 107 */     super.startElement(namespaceURI, localName, qName, atts);
/*     */ 
/* 109 */     int entryType = -1;
/* 110 */     Vector entryArgs = new Vector();
/*     */ 
/* 112 */     if ((namespaceURI != null) && ("http://nwalsh.com/xcatalog/1.0".equals(namespaceURI)) && (!inExtension))
/*     */     {
/* 116 */       if (atts.getValue("xml:base") != null) {
/* 117 */         String baseURI = atts.getValue("xml:base");
/* 118 */         entryType = Catalog.BASE;
/* 119 */         entryArgs.add(baseURI);
/* 120 */         this.baseURIStack.push(baseURI);
/*     */ 
/* 122 */         this.debug.message(4, "xml:base", baseURI);
/*     */         try
/*     */         {
/* 125 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 126 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 128 */           if (cex.getExceptionType() == 3)
/* 129 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 130 */           else if (cex.getExceptionType() == 2) {
/* 131 */             this.debug.message(1, "Invalid catalog entry (base)", localName);
/*     */           }
/*     */         }
/*     */ 
/* 135 */         entryType = -1;
/* 136 */         entryArgs = new Vector();
/*     */       } else {
/* 138 */         this.baseURIStack.push(this.baseURIStack.peek());
/*     */       }
/*     */ 
/* 141 */       if (localName.equals("uriSuffix")) {
/* 142 */         if (checkAttributes(atts, "suffix", "uri")) {
/* 143 */           entryType = Resolver.URISUFFIX;
/* 144 */           entryArgs.add(atts.getValue("suffix"));
/* 145 */           entryArgs.add(atts.getValue("uri"));
/*     */ 
/* 147 */           this.debug.message(4, "uriSuffix", atts.getValue("suffix"), atts.getValue("uri"));
/*     */         }
/*     */ 
/*     */       }
/* 151 */       else if (localName.equals("systemSuffix")) {
/* 152 */         if (checkAttributes(atts, "suffix", "uri")) {
/* 153 */           entryType = Resolver.SYSTEMSUFFIX;
/* 154 */           entryArgs.add(atts.getValue("suffix"));
/* 155 */           entryArgs.add(atts.getValue("uri"));
/*     */ 
/* 157 */           this.debug.message(4, "systemSuffix", atts.getValue("suffix"), atts.getValue("uri"));
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 163 */         this.debug.message(1, "Invalid catalog entry type", localName);
/*     */       }
/*     */ 
/* 166 */       if (entryType >= 0)
/*     */         try {
/* 168 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 169 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 171 */           if (cex.getExceptionType() == 3)
/* 172 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 173 */           else if (cex.getExceptionType() == 2)
/* 174 */             this.debug.message(1, "Invalid catalog entry", localName);
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endElement(String namespaceURI, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/* 187 */     super.endElement(namespaceURI, localName, qName);
/*     */ 
/* 191 */     boolean inExtension = inExtensionNamespace();
/*     */ 
/* 193 */     int entryType = -1;
/* 194 */     Vector entryArgs = new Vector();
/*     */ 
/* 196 */     if ((namespaceURI != null) && ("http://nwalsh.com/xcatalog/1.0".equals(namespaceURI)) && (!inExtension))
/*     */     {
/* 200 */       String popURI = (String)this.baseURIStack.pop();
/* 201 */       String baseURI = (String)this.baseURIStack.peek();
/*     */ 
/* 203 */       if (!baseURI.equals(popURI)) {
/* 204 */         entryType = Catalog.BASE;
/* 205 */         entryArgs.add(baseURI);
/*     */ 
/* 207 */         this.debug.message(4, "(reset) xml:base", baseURI);
/*     */         try
/*     */         {
/* 210 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 211 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 213 */           if (cex.getExceptionType() == 3)
/* 214 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 215 */           else if (cex.getExceptionType() == 2)
/* 216 */             this.debug.message(1, "Invalid catalog entry (rbase)", localName);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.readers.ExtendedXMLCatalogReader
 * JD-Core Version:    0.6.0
 */