/*     */ package org.jboss.util.xml.catalog.readers;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.util.Hashtable;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import org.jboss.util.xml.catalog.Catalog;
/*     */ import org.jboss.util.xml.catalog.CatalogException;
/*     */ import org.jboss.util.xml.catalog.CatalogManager;
/*     */ import org.jboss.util.xml.catalog.helpers.Debug;
/*     */ import org.jboss.util.xml.catalog.helpers.Namespaces;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class DOMCatalogReader
/*     */   implements CatalogReader
/*     */ {
/* 117 */   protected Hashtable namespaceMap = new Hashtable();
/*     */ 
/*     */   public void setCatalogParser(String namespaceURI, String rootElement, String parserClass)
/*     */   {
/* 133 */     if (namespaceURI == null)
/* 134 */       this.namespaceMap.put(rootElement, parserClass);
/*     */     else
/* 136 */       this.namespaceMap.put("{" + namespaceURI + "}" + rootElement, parserClass);
/*     */   }
/*     */ 
/*     */   public String getCatalogParser(String namespaceURI, String rootElement)
/*     */   {
/* 152 */     if (namespaceURI == null) {
/* 153 */       return (String)this.namespaceMap.get(rootElement);
/*     */     }
/* 155 */     return (String)this.namespaceMap.get("{" + namespaceURI + "}" + rootElement);
/*     */   }
/*     */ 
/*     */   public void readCatalog(Catalog catalog, InputStream is)
/*     */     throws IOException, CatalogException
/*     */   {
/* 193 */     DocumentBuilderFactory factory = null;
/* 194 */     DocumentBuilder builder = null;
/*     */ 
/* 196 */     factory = DocumentBuilderFactory.newInstance();
/* 197 */     factory.setNamespaceAware(false);
/* 198 */     factory.setValidating(false);
/*     */     try {
/* 200 */       builder = factory.newDocumentBuilder();
/*     */     } catch (ParserConfigurationException pce) {
/* 202 */       throw new CatalogException(6);
/*     */     }
/*     */ 
/* 205 */     Document doc = null;
/*     */     try
/*     */     {
/* 208 */       doc = builder.parse(is);
/*     */     } catch (SAXException se) {
/* 210 */       throw new CatalogException(5);
/*     */     }
/*     */ 
/* 213 */     Element root = doc.getDocumentElement();
/*     */ 
/* 215 */     String namespaceURI = Namespaces.getNamespaceURI(root);
/* 216 */     String localName = Namespaces.getLocalName(root);
/*     */ 
/* 218 */     String domParserClass = getCatalogParser(namespaceURI, localName);
/*     */ 
/* 221 */     if (domParserClass == null) {
/* 222 */       if (namespaceURI == null) {
/* 223 */         catalog.getCatalogManager().debug.message(1, "No Catalog parser for " + localName);
/*     */       }
/*     */       else {
/* 226 */         catalog.getCatalogManager().debug.message(1, "No Catalog parser for {" + namespaceURI + "}" + localName);
/*     */       }
/*     */ 
/* 230 */       return;
/*     */     }
/*     */ 
/* 233 */     DOMCatalogParser domParser = null;
/*     */     try
/*     */     {
/* 236 */       domParser = (DOMCatalogParser)Class.forName(domParserClass).newInstance();
/*     */     } catch (ClassNotFoundException cnfe) {
/* 238 */       catalog.getCatalogManager().debug.message(1, "Cannot load XML Catalog Parser class", domParserClass);
/* 239 */       throw new CatalogException(6);
/*     */     } catch (InstantiationException ie) {
/* 241 */       catalog.getCatalogManager().debug.message(1, "Cannot instantiate XML Catalog Parser class", domParserClass);
/* 242 */       throw new CatalogException(6);
/*     */     } catch (IllegalAccessException iae) {
/* 244 */       catalog.getCatalogManager().debug.message(1, "Cannot access XML Catalog Parser class", domParserClass);
/* 245 */       throw new CatalogException(6);
/*     */     } catch (ClassCastException cce) {
/* 247 */       catalog.getCatalogManager().debug.message(1, "Cannot cast XML Catalog Parser class", domParserClass);
/* 248 */       throw new CatalogException(6);
/*     */     }
/*     */ 
/* 251 */     Node node = root.getFirstChild();
/* 252 */     while (node != null) {
/* 253 */       domParser.parseCatalogEntry(catalog, node);
/* 254 */       node = node.getNextSibling();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readCatalog(Catalog catalog, String fileUrl)
/*     */     throws MalformedURLException, IOException, CatalogException
/*     */   {
/* 276 */     URL url = new URL(fileUrl);
/* 277 */     URLConnection urlCon = url.openConnection();
/* 278 */     readCatalog(catalog, urlCon.getInputStream());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.readers.DOMCatalogReader
 * JD-Core Version:    0.6.0
 */