/*     */ package org.jboss.util.xml.catalog.helpers;
/*     */ 
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public class Namespaces
/*     */ {
/*     */   public static String getPrefix(Element element)
/*     */   {
/*  81 */     String name = element.getTagName();
/*  82 */     String prefix = "";
/*     */ 
/*  84 */     if (name.indexOf(':') > 0) {
/*  85 */       prefix = name.substring(0, name.indexOf(':'));
/*     */     }
/*     */ 
/*  88 */     return prefix;
/*     */   }
/*     */ 
/*     */   public static String getLocalName(Element element)
/*     */   {
/*  99 */     String name = element.getTagName();
/*     */ 
/* 101 */     if (name.indexOf(':') > 0) {
/* 102 */       name = name.substring(name.indexOf(':') + 1);
/*     */     }
/*     */ 
/* 105 */     return name;
/*     */   }
/*     */ 
/*     */   public static String getNamespaceURI(Node node, String prefix)
/*     */   {
/* 118 */     if ((node == null) || (node.getNodeType() != 1)) {
/* 119 */       return null;
/*     */     }
/*     */ 
/* 122 */     if (prefix.equals("")) {
/* 123 */       if (((Element)node).hasAttribute("xmlns"))
/* 124 */         return ((Element)node).getAttribute("xmlns");
/*     */     }
/*     */     else {
/* 127 */       String nsattr = "xmlns:" + prefix;
/* 128 */       if (((Element)node).hasAttribute(nsattr)) {
/* 129 */         return ((Element)node).getAttribute(nsattr);
/*     */       }
/*     */     }
/*     */ 
/* 133 */     return getNamespaceURI(node.getParentNode(), prefix);
/*     */   }
/*     */ 
/*     */   public static String getNamespaceURI(Element element)
/*     */   {
/* 145 */     String prefix = getPrefix(element);
/* 146 */     return getNamespaceURI(element, prefix);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.helpers.Namespaces
 * JD-Core Version:    0.6.0
 */